/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.IlluminaDataType;
import net.sf.picard.illumina.parser.IlluminaFileMap;
import net.sf.picard.illumina.parser.IlluminaFileUtil;
import net.sf.picard.illumina.parser.PerTileParser;
import net.sf.picard.illumina.parser.PositionalData;
import net.sf.picard.illumina.parser.readers.AbstractIlluminaPositionFileReader;
import net.sf.picard.illumina.parser.readers.ClocsFileReader;
import net.sf.picard.illumina.parser.readers.LocsFileReader;
import net.sf.picard.illumina.parser.readers.PosFileReader;
import net.sf.picard.util.CollectionUtil;
import net.sf.samtools.util.CloseableIterator;

public class PosParser
extends PerTileParser<PositionalData> {
    private static Set<IlluminaDataType> supportedTypes = Collections.unmodifiableSet(CollectionUtil.makeSet(IlluminaDataType.Position));
    private final IlluminaFileUtil.SupportedIlluminaFormat fileType;

    public PosParser(IlluminaFileMap illuminaFileMap, IlluminaFileUtil.SupportedIlluminaFormat supportedIlluminaFormat) {
        super(illuminaFileMap);
        this.fileType = supportedIlluminaFormat;
    }

    public PosParser(IlluminaFileMap illuminaFileMap, int n, IlluminaFileUtil.SupportedIlluminaFormat supportedIlluminaFormat) {
        super(illuminaFileMap, n);
        this.fileType = supportedIlluminaFormat;
    }

    @Override
    protected CloseableIterator<PositionalData> makeTileIterator(File file) {
        AbstractIlluminaPositionFileReader abstractIlluminaPositionFileReader;
        switch (this.fileType) {
            case Pos: {
                abstractIlluminaPositionFileReader = new PosFileReader(file);
                break;
            }
            case Locs: {
                abstractIlluminaPositionFileReader = new LocsFileReader(file);
                break;
            }
            case Clocs: {
                abstractIlluminaPositionFileReader = new ClocsFileReader(file);
                break;
            }
            default: {
                throw new PicardException("Unrecognized pos file type " + this.fileType.name());
            }
        }
        return new CloseableIterator<PositionalData>(){
            private AbstractIlluminaPositionFileReader reader;
            {
                this.reader = abstractIlluminaPositionFileReader;
            }

            @Override
            public void close() {
                this.reader.close();
            }

            @Override
            public boolean hasNext() {
                return this.reader.hasNext();
            }

            @Override
            public PositionalData next() {
                final AbstractIlluminaPositionFileReader.PositionInfo positionInfo = this.reader.next();
                return new PositionalData(){

                    @Override
                    public int getXCoordinate() {
                        return positionInfo.xQseqCoord;
                    }

                    @Override
                    public int getYCoordinate() {
                        return positionInfo.yQseqCoord;
                    }

                    public int getLane() {
                        return positionInfo.lane;
                    }

                    public int getTile() {
                        return positionInfo.tile;
                    }
                };
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Set<IlluminaDataType> supportedTypes() {
        return supportedTypes;
    }
}

