/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.BarcodeData;
import net.sf.picard.illumina.parser.BarcodeParser;
import net.sf.picard.illumina.parser.BclParser;
import net.sf.picard.illumina.parser.CifParser;
import net.sf.picard.illumina.parser.CnfParser;
import net.sf.picard.illumina.parser.CycleIlluminaFileMap;
import net.sf.picard.illumina.parser.FilterParser;
import net.sf.picard.illumina.parser.IlluminaDataProvider;
import net.sf.picard.illumina.parser.IlluminaDataType;
import net.sf.picard.illumina.parser.IlluminaFileMap;
import net.sf.picard.illumina.parser.IlluminaFileUtil;
import net.sf.picard.illumina.parser.IlluminaParser;
import net.sf.picard.illumina.parser.OutputMapping;
import net.sf.picard.illumina.parser.PosParser;
import net.sf.picard.illumina.parser.QseqParser;
import net.sf.picard.illumina.parser.ReadStructure;
import net.sf.picard.util.CollectionUtil;
import net.sf.picard.util.Log;
import net.sf.samtools.util.StringUtil;

public class IlluminaDataProviderFactory {
    private static final Log log = Log.getInstance(IlluminaDataProviderFactory.class);
    private static final Map<IlluminaDataType, List<IlluminaFileUtil.SupportedIlluminaFormat>> DATA_TYPE_TO_PREFERRED_FORMATS = new HashMap<IlluminaDataType, List<IlluminaFileUtil.SupportedIlluminaFormat>>();
    private final File basecallDirectory;
    private final int lane;
    private final File intensitiesDirectory;
    private final Set<IlluminaDataType> dataTypes;
    protected final Map<IlluminaFileUtil.SupportedIlluminaFormat, Set<IlluminaDataType>> formatToDataTypes;
    private final IlluminaFileUtil fileUtil;
    private final List<Integer> availableTiles;
    private final OutputMapping outputMapping;

    public IlluminaDataProviderFactory(File file, int n, ReadStructure readStructure, IlluminaDataType ... illuminaDataTypeArray) {
        this.basecallDirectory = file;
        this.intensitiesDirectory = file.getParentFile();
        this.lane = n;
        this.dataTypes = Collections.unmodifiableSet(new HashSet<IlluminaDataType>(Arrays.asList(illuminaDataTypeArray)));
        if (this.dataTypes.isEmpty()) {
            throw new PicardException("No data types have been specified for basecall output " + file + ", lane " + n);
        }
        this.fileUtil = new IlluminaFileUtil(file, n);
        this.formatToDataTypes = IlluminaDataProviderFactory.determineFormats(this.dataTypes, this.fileUtil);
        Set<IlluminaDataType> set = IlluminaDataProviderFactory.findUnmatchedTypes(this.dataTypes, this.formatToDataTypes);
        if (set.size() > 0) {
            throw new PicardException("Could not find a format with available files for the following data types: " + StringUtil.join(", ", new ArrayList<IlluminaDataType>(set)));
        }
        StringBuilder stringBuilder = new StringBuilder(400);
        stringBuilder.append("The following file formats will be used by IlluminaDataProvier: ");
        stringBuilder.append(StringUtil.join("," + this.formatToDataTypes.keySet(), new Object[0]));
        log.debug(stringBuilder.toString());
        this.availableTiles = this.fileUtil.getActualTiles(new ArrayList<IlluminaFileUtil.SupportedIlluminaFormat>(this.formatToDataTypes.keySet()));
        if (this.availableTiles.isEmpty()) {
            throw new PicardException("No available tiles were found, make sure that " + file.getAbsolutePath() + " has a lane " + n);
        }
        this.outputMapping = new OutputMapping(readStructure);
    }

    public ReadStructure getOutputReadStructure() {
        return this.outputMapping.getOutputReadStructure();
    }

    public List<Integer> getAvailableTiles() {
        return this.availableTiles;
    }

    public IlluminaDataProvider makeDataProvider() {
        return this.makeDataProvider(null);
    }

    public IlluminaDataProvider makeDataProvider(List<Integer> list) {
        if (list == null) {
            list = this.availableTiles;
        } else if (list.size() == 0) {
            throw new PicardException("Zero length tile list supplied to makeDataProvider, you must specify at least 1 tile OR pass NULL to use all available tiles");
        }
        HashMap<IlluminaParser, Set<IlluminaDataType>> hashMap = new HashMap<IlluminaParser, Set<IlluminaDataType>>();
        for (Map.Entry<IlluminaFileUtil.SupportedIlluminaFormat, Set<IlluminaDataType>> entry : this.formatToDataTypes.entrySet()) {
            hashMap.put(this.makeParser(entry.getKey(), list), entry.getValue());
        }
        StringBuilder stringBuilder = new StringBuilder(400);
        stringBuilder.append("The following parsers will be used by IlluminaDataProvier: ");
        stringBuilder.append(StringUtil.join("," + hashMap.keySet(), new Object[0]));
        log.debug(stringBuilder.toString());
        return new IlluminaDataProvider(this.outputMapping, hashMap, this.basecallDirectory, this.lane);
    }

    public static Set<IlluminaDataType> findUnmatchedTypes(Set<IlluminaDataType> set, Map<IlluminaFileUtil.SupportedIlluminaFormat, Set<IlluminaDataType>> map) {
        HashSet<IlluminaDataType> hashSet = new HashSet<IlluminaDataType>(set);
        for (Set<IlluminaDataType> set2 : map.values()) {
            hashSet.removeAll(set2);
        }
        return hashSet;
    }

    public static Map<IlluminaFileUtil.SupportedIlluminaFormat, Set<IlluminaDataType>> determineFormats(Set<IlluminaDataType> set, IlluminaFileUtil illuminaFileUtil) {
        IlluminaFileUtil.SupportedIlluminaFormat supportedIlluminaFormat;
        TreeSet<IlluminaDataType> treeSet = new TreeSet<IlluminaDataType>(set);
        HashMap<IlluminaFileUtil.SupportedIlluminaFormat, Set<IlluminaDataType>> hashMap = new HashMap<IlluminaFileUtil.SupportedIlluminaFormat, Set<IlluminaDataType>>();
        HashMap<IlluminaDataType, IlluminaFileUtil.SupportedIlluminaFormat> hashMap2 = new HashMap<IlluminaDataType, IlluminaFileUtil.SupportedIlluminaFormat>();
        boolean bl = false;
        for (IlluminaDataType illuminaDataType : treeSet) {
            supportedIlluminaFormat = IlluminaDataProviderFactory.findPreferredAvailableFormat(illuminaDataType, illuminaFileUtil);
            if (supportedIlluminaFormat == null) continue;
            bl |= supportedIlluminaFormat == IlluminaFileUtil.SupportedIlluminaFormat.Qseq;
            hashMap2.put(illuminaDataType, supportedIlluminaFormat);
        }
        if (bl) {
            HashSet<IlluminaDataType> hashSet = new HashSet<IlluminaDataType>(QseqParser.SUPPORTED_TYPES);
            hashSet.retainAll(treeSet);
            treeSet.removeAll(hashSet);
            hashMap.put(IlluminaFileUtil.SupportedIlluminaFormat.Qseq, (Set<IlluminaDataType>)hashSet);
        }
        for (IlluminaDataType illuminaDataType : treeSet) {
            supportedIlluminaFormat = (IlluminaFileUtil.SupportedIlluminaFormat)((Object)hashMap2.get((Object)illuminaDataType));
            if (supportedIlluminaFormat == null) continue;
            if (hashMap.containsKey((Object)supportedIlluminaFormat)) {
                ((Set)hashMap.get((Object)supportedIlluminaFormat)).add(illuminaDataType);
                continue;
            }
            hashMap.put((IlluminaFileUtil.SupportedIlluminaFormat)((Object)hashMap2.get((Object)illuminaDataType)), CollectionUtil.makeSet(illuminaDataType));
        }
        return hashMap;
    }

    public static IlluminaFileUtil.SupportedIlluminaFormat findPreferredAvailableFormat(IlluminaDataType illuminaDataType, IlluminaFileUtil illuminaFileUtil) {
        List<IlluminaFileUtil.SupportedIlluminaFormat> list = DATA_TYPE_TO_PREFERRED_FORMATS.get((Object)illuminaDataType);
        IlluminaFileUtil.SupportedIlluminaFormat supportedIlluminaFormat = null;
        for (int i = 0; i < list.size() && supportedIlluminaFormat == null; ++i) {
            if (!illuminaFileUtil.getUtil(list.get(i)).filesAvailable()) continue;
            supportedIlluminaFormat = list.get(i);
        }
        return supportedIlluminaFormat;
    }

    private IlluminaParser makeParser(IlluminaFileUtil.SupportedIlluminaFormat supportedIlluminaFormat, List<Integer> list) {
        IlluminaParser<BarcodeData> illuminaParser;
        switch (supportedIlluminaFormat) {
            case Barcode: {
                illuminaParser = new BarcodeParser(this.fileUtil.barcode().getFiles(list));
                break;
            }
            case Bcl: {
                CycleIlluminaFileMap cycleIlluminaFileMap = this.fileUtil.bcl().getFiles(list, this.outputMapping.getOutputCycles());
                cycleIlluminaFileMap.assertValid(list, this.outputMapping.getOutputCycles());
                illuminaParser = new BclParser(this.basecallDirectory, this.lane, cycleIlluminaFileMap, this.outputMapping);
                break;
            }
            case Cif: {
                CycleIlluminaFileMap cycleIlluminaFileMap = this.fileUtil.cif().getFiles(list, this.outputMapping.getOutputCycles());
                cycleIlluminaFileMap.assertValid(list, this.outputMapping.getOutputCycles());
                illuminaParser = new CifParser(this.intensitiesDirectory, this.lane, cycleIlluminaFileMap, this.outputMapping);
                break;
            }
            case Cnf: {
                CycleIlluminaFileMap cycleIlluminaFileMap = this.fileUtil.cnf().getFiles(list, this.outputMapping.getOutputCycles());
                cycleIlluminaFileMap.assertValid(list, this.outputMapping.getOutputCycles());
                illuminaParser = new CnfParser(this.intensitiesDirectory, this.lane, cycleIlluminaFileMap, this.outputMapping);
                break;
            }
            case Filter: {
                IlluminaFileMap illuminaFileMap = this.fileUtil.filter().getFiles(list);
                illuminaParser = new FilterParser(illuminaFileMap);
                break;
            }
            case Locs: 
            case Clocs: 
            case Pos: {
                IlluminaFileUtil.PerTileFileUtil perTileFileUtil = (IlluminaFileUtil.PerTileFileUtil)this.fileUtil.getUtil(supportedIlluminaFormat);
                illuminaParser = new PosParser(perTileFileUtil.getFiles(list), supportedIlluminaFormat);
                break;
            }
            case Qseq: {
                List<IlluminaFileMap> list2 = this.fileUtil.qseq().getFiles(list);
                illuminaParser = new QseqParser(this.lane, list2, this.outputMapping);
                break;
            }
            default: {
                throw new PicardException("Unrecognized data type(" + (Object)((Object)supportedIlluminaFormat) + ") found by IlluminaDataProviderFactory!");
            }
        }
        return illuminaParser;
    }

    static {
        DATA_TYPE_TO_PREFERRED_FORMATS.put(IlluminaDataType.BaseCalls, CollectionUtil.makeList(IlluminaFileUtil.SupportedIlluminaFormat.Bcl, IlluminaFileUtil.SupportedIlluminaFormat.Qseq));
        DATA_TYPE_TO_PREFERRED_FORMATS.put(IlluminaDataType.QualityScores, CollectionUtil.makeList(IlluminaFileUtil.SupportedIlluminaFormat.Bcl, IlluminaFileUtil.SupportedIlluminaFormat.Qseq));
        DATA_TYPE_TO_PREFERRED_FORMATS.put(IlluminaDataType.PF, CollectionUtil.makeList(IlluminaFileUtil.SupportedIlluminaFormat.Filter, IlluminaFileUtil.SupportedIlluminaFormat.Qseq));
        DATA_TYPE_TO_PREFERRED_FORMATS.put(IlluminaDataType.Position, CollectionUtil.makeList(IlluminaFileUtil.SupportedIlluminaFormat.Locs, IlluminaFileUtil.SupportedIlluminaFormat.Clocs, IlluminaFileUtil.SupportedIlluminaFormat.Pos, IlluminaFileUtil.SupportedIlluminaFormat.Qseq));
        DATA_TYPE_TO_PREFERRED_FORMATS.put(IlluminaDataType.Barcodes, CollectionUtil.makeList(IlluminaFileUtil.SupportedIlluminaFormat.Barcode));
        DATA_TYPE_TO_PREFERRED_FORMATS.put(IlluminaDataType.RawIntensities, CollectionUtil.makeList(IlluminaFileUtil.SupportedIlluminaFormat.Cif));
        DATA_TYPE_TO_PREFERRED_FORMATS.put(IlluminaDataType.Noise, CollectionUtil.makeList(IlluminaFileUtil.SupportedIlluminaFormat.Cnf));
    }
}

