/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.filter;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import net.sf.picard.PicardException;
import net.sf.picard.filter.SamRecordFilter;
import net.sf.picard.io.IoUtil;
import net.sf.samtools.SAMRecord;

public class ReadNameFilter
implements SamRecordFilter {
    private boolean includeReads = false;
    private Set<String> readNameFilterSet = new HashSet<String>();

    public ReadNameFilter(File file, boolean bl) {
        BufferedReader bufferedReader;
        IoUtil.assertFileIsReadable(file);
        IoUtil.assertFileSizeNonZero(file);
        try {
            bufferedReader = IoUtil.openFileForBufferedReading(file);
        }
        catch (IOException iOException) {
            throw new PicardException(iOException.getMessage(), iOException);
        }
        Scanner scanner = new Scanner(bufferedReader);
        while (scanner.hasNext()) {
            String string = scanner.nextLine();
            if (string.trim().isEmpty()) continue;
            this.readNameFilterSet.add(string.split("\\s+")[0]);
        }
        scanner.close();
        this.includeReads = bl;
    }

    public ReadNameFilter(Set<String> set, boolean bl) {
        this.readNameFilterSet = set;
        this.includeReads = bl;
    }

    @Override
    public boolean filterOut(SAMRecord sAMRecord) {
        return !(this.includeReads ? this.readNameFilterSet.contains(sAMRecord.getReadName()) : !this.readNameFilterSet.contains(sAMRecord.getReadName()));
    }

    @Override
    public boolean filterOut(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
        return !(this.includeReads ? this.readNameFilterSet.contains(sAMRecord.getReadName()) && this.readNameFilterSet.contains(sAMRecord2.getReadName()) : !this.readNameFilterSet.contains(sAMRecord.getReadName()) && !this.readNameFilterSet.contains(sAMRecord2.getReadName()));
    }
}

