/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.variantFilter;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.molgenis.genotype.variant.GeneticVariant;
import org.molgenis.genotype.variantFilter.VariantFilter;

public class VariantFilterIterator
implements Iterator<GeneticVariant> {
    private final Iterator<GeneticVariant> originalIterator;
    private final VariantFilter variantFilter;
    private GeneticVariant next;

    public VariantFilterIterator(Iterator<GeneticVariant> originalIterator, VariantFilter variantFilter) {
        this.originalIterator = originalIterator;
        this.variantFilter = variantFilter;
        this.goToNext();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public GeneticVariant next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        GeneticVariant currentNext = this.next;
        this.goToNext();
        return currentNext;
    }

    private void goToNext() {
        while (this.originalIterator.hasNext()) {
            GeneticVariant originalNext = this.originalIterator.next();
            if (!this.variantFilter.doesVariantPassFilter(originalNext)) continue;
            this.next = originalNext;
            return;
        }
        this.next = null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

