/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.util.List;
import net.sf.picard.PicardException;
import net.sf.picard.util.AdapterPair;
import net.sf.picard.util.FormatUtil;
import net.sf.picard.util.SolexaQualityConverter;
import net.sf.samtools.util.SequenceUtil;
import net.sf.samtools.util.StringUtil;

public class IlluminaUtil {
    public static final String BARCODE_DELIMITER = "-";

    public static String makeReadName(String string, int n, int n2, int n3, int n4) {
        return string + ":" + n + ":" + n2 + ":" + n3 + ":" + n4;
    }

    public static Integer getTileFromReadName(String string) {
        int n;
        int n2;
        int n3 = string.indexOf(58);
        if (n3 > 0 && (n2 = string.indexOf(58, n3 + 1)) > 0 && (n = string.indexOf(58, n2 + 1)) > 0) {
            return Integer.parseInt(string.substring(n2 + 1, n));
        }
        return null;
    }

    public static byte[] makePhredBinaryFromSolexaQualityAscii_1_3(String string) {
        return IlluminaUtil.makePhredBinaryFromSolexaQualityAscii_1_3(string, 0, string.length());
    }

    public static byte[] makePhredBinaryFromSolexaQualityAscii_1_3(String string, int n, int n2) {
        byte[] byArray = StringUtil.stringToBytes(string, n, n2);
        SolexaQualityConverter.getSingleton().convertSolexa_1_3_QualityCharsToPhredBinary(byArray);
        return byArray;
    }

    public static void convertSolexaQualityAscii_1_1_ToPhredBinary(byte[] byArray) {
        SolexaQualityConverter.getSingleton().convertSolexaQualityCharsToPhredBinary(byArray);
    }

    public static byte getSolexaQualityCharFromFourQualities(String[] stringArray, int n, FormatUtil formatUtil) {
        int n2;
        int n3;
        int n4 = Integer.MIN_VALUE;
        for (n3 = n2 = (n - 1) * 4; n3 < n2 + 4; ++n3) {
            int n5 = formatUtil.parseInt(stringArray[n3]);
            if (n5 <= n4) continue;
            n4 = n5;
        }
        n3 = n4 + 64;
        if (n3 > 255) {
            throw new PicardException("Quality too large: " + n4);
        }
        return (byte)(n3 & 0xFF);
    }

    public static String barcodeSeqsToString(List<String> list) {
        return IlluminaUtil.barcodeSeqsToString(list.toArray(new String[list.size()]));
    }

    public static String barcodeSeqsToString(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(BARCODE_DELIMITER);
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String barcodeSeqsToString(byte[][] byArray) {
        String[] stringArray = new String[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            stringArray[i] = StringUtil.bytesToString(byArray[i]);
        }
        return IlluminaUtil.barcodeSeqsToString(stringArray);
    }

    public static enum IlluminaAdapterPair implements AdapterPair
    {
        PAIRED_END("AATGATACGGCGACCACCGAGATCTACACTCTTTCCCTACACGACGCTCTTCCGATCT", "AGATCGGAAGAGCGGTTCAGCAGGAATGCCGAGACCGATCTCGTATGCCGTCTTCTGCTTG"),
        INDEXED("AATGATACGGCGACCACCGAGATCTACACTCTTTCCCTACACGACGCTCTTCCGATCT", "AGATCGGAAGAGCACACGTCTGAACTCCAGTCACNNNNNNNNATCTCGTATGCCGTCTTCTGCTTG"),
        SINGLE_END("AATGATACGGCGACCACCGAGATCTACACTCTTTCCCTACACGACGCTCTTCCGATCT", "AGATCGGAAGAGCTCGTATGCCGTCTTCTGCTTG"),
        ALTERNATIVE_SINGLE_END("AATGATACGGCGACCACCGACAGGTTCAGAGTTCTACAGTCCGACGATC", "TCGTATGCCGTCTTCTGCTTG"),
        NEXTERA_V1("AATGATACGGCGACCACCGAGATCTACACGCCTCCCTCGCGCCATCAGAGATGTGTATAAGAGACAG", "CTGTCTCTTATACACATCTCTGAGCGGGCTGGCAAGGCAGACCGNNNNNNNNATCTCGTATGCCGTCTTCTGCTTG"),
        NEXTERA_V2("AATGATACGGCGACCACCGAGATCTACACNNNNNNNNTCGTCGGCAGCGTCAGATGTGTATAAGAGACAG", "CTGTCTCTTATACACATCTCCGAGCCCACGAGACNNNNNNNNATCTCGTATGCCGTCTTCTGCTTG"),
        DUAL_INDEXED("AATGATACGGCGACCACCGAGATCTNNNNNNNNACACTCTTTCCCTACACGACGCTCTTCCGATCT", "AGATCGGAAGAGCACACGTCTGAACTCCAGTCACNNNNNNNNATCTCGTATGCCGTCTTCTGCTTG"),
        FLUIDIGM("AATGATACGGCGACCACCGAGATCTACACTGACGACATGGTTCTACA", "AGACCAAGTCTCTGCTACCGTANNNNNNNNNNATCTCGTATGCCGTCTTCTGCTTG"),
        TRUSEQ_SMALLRNA("AATGATACGGCGACCACCGAGATCTACACGTTCAGAGTTCTACAGTCCGACGATC", "TGGAATTCTCGGGTGCCAAGGAACTCCAGTCACNNNNNNATCTCGTATGCCGTCTTCTGCTTG");

        final String fivePrime;
        final String threePrime;
        final String fivePrimeReadOrder;
        final byte[] fivePrimeBytes;
        final byte[] threePrimeBytes;
        final byte[] fivePrimeReadOrderBytes;

        private IlluminaAdapterPair(String string2, String string3) {
            this.threePrime = string3;
            this.threePrimeBytes = StringUtil.stringToBytes(string3);
            this.fivePrime = string2;
            this.fivePrimeReadOrder = SequenceUtil.reverseComplement(string2);
            this.fivePrimeBytes = StringUtil.stringToBytes(string2);
            this.fivePrimeReadOrderBytes = StringUtil.stringToBytes(this.fivePrimeReadOrder);
        }

        @Override
        public String get3PrimeAdapter() {
            return this.threePrime;
        }

        @Override
        public String get5PrimeAdapter() {
            return this.fivePrime;
        }

        @Override
        public String get3PrimeAdapterInReadOrder() {
            return this.threePrime;
        }

        @Override
        public String get5PrimeAdapterInReadOrder() {
            return this.fivePrimeReadOrder;
        }

        @Override
        public byte[] get3PrimeAdapterBytes() {
            return this.threePrimeBytes;
        }

        @Override
        public byte[] get5PrimeAdapterBytes() {
            return this.fivePrimeBytes;
        }

        @Override
        public byte[] get3PrimeAdapterBytesInReadOrder() {
            return this.threePrimeBytes;
        }

        @Override
        public byte[] get5PrimeAdapterBytesInReadOrder() {
            return this.fivePrimeReadOrderBytes;
        }

        @Override
        public String getName() {
            return this.name();
        }
    }
}

