/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.CycleFilesIterator;
import net.sf.samtools.util.StringUtil;

class CycleIlluminaFileMap
extends TreeMap<Integer, CycleFilesIterator> {
    CycleIlluminaFileMap() {
    }

    public CycleIlluminaFileMap keep(List<Integer> list, int[] nArray) {
        if (list == null) {
            list = new ArrayList(this.keySet());
        }
        CycleIlluminaFileMap cycleIlluminaFileMap = new CycleIlluminaFileMap();
        for (Integer n : list) {
            CycleFilesIterator cycleFilesIterator = (CycleFilesIterator)this.get(n);
            if (cycleFilesIterator == null) continue;
            cycleIlluminaFileMap.put(n, new CycleFilesIterator((CycleFilesIterator)this.get(n), nArray));
        }
        return cycleIlluminaFileMap;
    }

    public void assertValid(List<Integer> list, int[] nArray) {
        if (this.size() != list.size()) {
            throw new PicardException("Expected CycledIlluminaFileMap to contain " + list + " tiles but only " + this.size() + " were found!");
        }
        File file = null;
        for (int n : list) {
            CycleFilesIterator cycleFilesIterator = new CycleFilesIterator((CycleFilesIterator)this.get(n), null);
            int n2 = 0;
            while (cycleFilesIterator.hasNext()) {
                if (cycleFilesIterator.getNextCycle() != nArray[n2]) {
                    if (file == null) {
                        file = cycleFilesIterator.next();
                    }
                    cycleFilesIterator.reset();
                    throw new PicardException("Cycles in iterator(" + CycleIlluminaFileMap.remainingCyclesToString(cycleFilesIterator) + ") do not match those expected (" + StringUtil.intValuesToString(nArray) + ") Last file checked (" + file.getAbsolutePath() + ")");
                }
                file = cycleFilesIterator.next();
                if (!file.exists()) {
                    throw new PicardException("Missing cycle file " + file.getName() + " in CycledIlluminaFileMap");
                }
                ++n2;
            }
            if (n2 == nArray.length) continue;
            String string = "Expected tile " + n + " of CycledIlluminaFileMap to contain " + nArray + " cycles but " + n2 + " were found!";
            if (file != null) {
                string = string + "Check to see if the following bcl exists: " + CycleIlluminaFileMap.incrementCycleCount(file).getAbsolutePath();
            }
            throw new PicardException(string);
        }
    }

    public static File incrementCycleCount(File file) {
        File file2 = file.getParentFile();
        int n = Integer.parseInt(file2.getName().substring(1, file2.getName().lastIndexOf(".")));
        return new File(file2.getParentFile(), "C" + n + ".1" + File.separator + file.getName());
    }

    public static String remainingCyclesToString(CycleFilesIterator cycleFilesIterator) {
        String string = "";
        if (cycleFilesIterator.hasNext()) {
            string = string + cycleFilesIterator.getNextCycle();
            cycleFilesIterator.next();
        }
        while (cycleFilesIterator.hasNext()) {
            string = string + ", " + cycleFilesIterator.getNextCycle();
            cycleFilesIterator.next();
        }
        return string;
    }
}

