/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.illumina.IlluminaBasecallsToSam;
import net.sf.picard.illumina.parser.IlluminaDataProviderFactory;
import net.sf.picard.illumina.parser.IlluminaDataType;
import net.sf.picard.illumina.parser.IlluminaFileUtil;
import net.sf.picard.illumina.parser.OutputMapping;
import net.sf.picard.illumina.parser.ReadStructure;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.Log;
import net.sf.samtools.util.StringUtil;

public class CheckIlluminaDirectory
extends CommandLineProgram {
    private static final Log log = Log.getInstance(CheckIlluminaDirectory.class);
    @Usage
    public String USAGE = this.getStandardUsagePreamble() + "Check that the files to provide the data specified by DATA_TYPES are available, exist, and are reasonably sized for every tile/cycle.  " + "Reasonably sized means non-zero sized for files that exist per tile and equal size for binary files that exist per cycle/per tile. " + "CheckIlluminaDirectory DOES NOT check that the individual records in a file are well-formed.\n";
    @Option(doc="The basecalls output directory. ", shortName="B")
    public File BASECALLS_DIR;
    @Option(doc="The data types that should be checked for each tile/cycle.  If no values are provided then the data types checked are those required by IlluminaBaseCallsToSam (which is a superset of those used in ExtractIlluminaBarcodes).  These data types vary slightly depending onwhether or not the run is barcoded so READ_STRUCTURE should be the same as that which will be passed to IlluminaBasecallsToSam.  If this option is left unspecified then both ExtractIlluminaBarcodes and IlluminaBaseCallsToSam should complete successfully UNLESS the individual records of the files themselves are spurious. ", shortName="DT", optional=true)
    public final Set<IlluminaDataType> DATA_TYPES = new TreeSet<IlluminaDataType>();
    @Option(doc="A description of the logical structure of clusters in an Illumina Run, i.e. a description of the structure IlluminaBasecallsToSam assumes the  data to be in. It should consist of integer/character pairs describing the number of cycles and the type of those cycles (B for Barcode, T for Template, and S for skip).  E.g. If the input data consists of 80 base clusters and we provide a read structure of \"36T8B8S28T\" then, before being converted to SAM records those bases will be split into 4 reads where read one consists of 36 cycles of template, read two consists of 8 cycles of barcode, read three will be an 8 base read of skipped cycles and read four is another 28 cycle template read.  The read consisting of skipped cycles would NOT be included in output SAM/BAM file read groups.  Note:  If you want to check whether or not a future IlluminaBasecallsToSam or ExtractIlluminaBarcodes run will fail then be sure to use the exact same READ_STRUCTURE that you would pass to these programs for this run.", shortName="RS")
    public String READ_STRUCTURE;
    @Option(doc="The number of the lane(s) to check. ", shortName="L", minElements=1)
    public List<Integer> LANES;

    public static void main(String[] stringArray) {
        new CheckIlluminaDirectory().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        ReadStructure readStructure = new ReadStructure(this.READ_STRUCTURE);
        if (this.DATA_TYPES.size() == 0) {
            this.DATA_TYPES.addAll(Arrays.asList(IlluminaBasecallsToSam.DATA_TYPES_NO_BARCODE));
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = 0;
        int[] nArray = new OutputMapping(readStructure).getOutputCycles();
        log.info("Checking lanes(" + StringUtil.join(",", this.LANES) + " in basecalls directory (" + this.BASECALLS_DIR.getAbsolutePath() + ")\n");
        log.info("Expected cycles: " + StringUtil.intValuesToString(nArray));
        for (Integer n2 : this.LANES) {
            IlluminaFileUtil illuminaFileUtil = new IlluminaFileUtil(this.BASECALLS_DIR, n2);
            List<Integer> list = illuminaFileUtil.getExpectedTiles();
            log.info("Checking lane " + n2);
            log.info("Expected tiles: " + StringUtil.join(", ", list));
            int n3 = CheckIlluminaDirectory.verifyLane(illuminaFileUtil, list, nArray, this.DATA_TYPES);
            if (n3 > 0) {
                log.info("Lane " + n2 + " FAILED " + " Total Errors: " + n3);
                arrayList.add(n2);
                n += n3;
                continue;
            }
            log.info("Lane " + n2 + " SUCCEEDED ");
        }
        int n4 = 0;
        if (n == 0) {
            log.info("SUCCEEDED!  All required files are present and non-empty.");
        } else {
            n4 = n;
            log.info("FAILED! There were " + n + " in the following lanes: " + StringUtil.join(", ", arrayList));
        }
        return n4;
    }

    private static final int verifyLane(IlluminaFileUtil illuminaFileUtil, List<Integer> list, int[] nArray, Set<IlluminaDataType> set) {
        if (list.size() == 0) {
            throw new PicardException("0 input tiles were specified!  Check to make sure this lane is in the InterOp file!");
        }
        if (nArray.length == 0) {
            throw new PicardException("0 output cycles were specified!");
        }
        int n = 0;
        Map<IlluminaFileUtil.SupportedIlluminaFormat, Set<IlluminaDataType>> map = IlluminaDataProviderFactory.determineFormats(set, illuminaFileUtil);
        Set<IlluminaDataType> set2 = IlluminaDataProviderFactory.findUnmatchedTypes(set, map);
        if (set2.size() > 0) {
            log.info("Could not find a format with available files for the following data types: " + StringUtil.join(", ", new ArrayList<IlluminaDataType>(set2)));
            n += set2.size();
        }
        for (IlluminaFileUtil.SupportedIlluminaFormat supportedIlluminaFormat : map.keySet()) {
            List<String> list2 = illuminaFileUtil.getUtil(supportedIlluminaFormat).verify(list, nArray);
            n += list2.size();
            for (String string : list2) {
                log.info(string);
            }
        }
        return n;
    }

    @Override
    protected String[] customCommandLineValidation() {
        IoUtil.assertDirectoryIsReadable(this.BASECALLS_DIR);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Integer n : this.LANES) {
            if (n >= 1) continue;
            arrayList.add("LANES must be greater than or equal to 1.  LANES passed in " + StringUtil.join(", ", this.LANES));
            break;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

