/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.analysis;

import java.io.File;
import java.util.List;
import java.util.Set;
import net.sf.picard.analysis.AlignmentSummaryMetricsCollector;
import net.sf.picard.analysis.MetricAccumulationLevel;
import net.sf.picard.analysis.SinglePassSamProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.metrics.MetricsFile;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.picard.util.CollectionUtil;
import net.sf.picard.util.IlluminaUtil;
import net.sf.picard.util.Log;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMRecord;

public class CollectAlignmentSummaryMetrics
extends SinglePassSamProgram {
    private static final Log log = Log.getInstance(CollectAlignmentSummaryMetrics.class);
    @Usage
    public String USAGE = this.getStandardUsagePreamble() + "Reads a SAM or BAM file and writes a file containing summary alignment metrics.\n";
    @Option(doc="Paired end reads above this insert size will be considered chimeric along with inter-chromosomal pairs.")
    public int MAX_INSERT_SIZE = 100000;
    @Option(doc="List of adapter sequences to use when processing the alignment metrics")
    public List<String> ADAPTER_SEQUENCE = CollectionUtil.makeList(IlluminaUtil.IlluminaAdapterPair.SINGLE_END.get5PrimeAdapter(), IlluminaUtil.IlluminaAdapterPair.SINGLE_END.get3PrimeAdapter(), IlluminaUtil.IlluminaAdapterPair.PAIRED_END.get5PrimeAdapter(), IlluminaUtil.IlluminaAdapterPair.PAIRED_END.get3PrimeAdapter(), IlluminaUtil.IlluminaAdapterPair.INDEXED.get5PrimeAdapter(), IlluminaUtil.IlluminaAdapterPair.INDEXED.get3PrimeAdapter());
    @Option(shortName="LEVEL", doc="The level(s) at which to accumulate metrics.  ")
    private Set<MetricAccumulationLevel> METRIC_ACCUMULATION_LEVEL = CollectionUtil.makeSet(MetricAccumulationLevel.ALL_READS);
    @Option(shortName="BS", doc="Whether the SAM or BAM file consists of bisulfite sequenced reads.  ")
    public boolean IS_BISULFITE_SEQUENCED = false;
    private AlignmentSummaryMetricsCollector collector;

    public static void main(String[] stringArray) {
        new CollectAlignmentSummaryMetrics().instanceMainWithExit(stringArray);
    }

    protected final int testDoWork() {
        return this.doWork();
    }

    @Override
    protected void setup(SAMFileHeader sAMFileHeader, File file) {
        IoUtil.assertFileIsWritable(this.OUTPUT);
        if (sAMFileHeader.getSequenceDictionary().isEmpty()) {
            log.warn(this.INPUT.getAbsoluteFile() + " has no sequence dictionary.  If any reads " + "in the file are aligned then alignment summary metrics collection will fail.");
        }
        boolean bl = this.REFERENCE_SEQUENCE != null;
        this.collector = new AlignmentSummaryMetricsCollector(this.METRIC_ACCUMULATION_LEVEL, sAMFileHeader.getReadGroups(), bl, this.ADAPTER_SEQUENCE, this.MAX_INSERT_SIZE, this.IS_BISULFITE_SEQUENCED);
    }

    @Override
    protected void acceptRead(SAMRecord sAMRecord, ReferenceSequence referenceSequence) {
        this.collector.acceptRecord(sAMRecord, referenceSequence);
    }

    @Override
    protected void finish() {
        this.collector.finish();
        MetricsFile metricsFile = this.getMetricsFile();
        this.collector.addAllLevelsToFile(metricsFile);
        metricsFile.write(this.OUTPUT);
    }
}

