/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.sf.samtools.AbstractSAMHeaderRecord;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFormatException;
import net.sf.samtools.SAMProgramRecord;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.SAMUtils;
import net.sf.samtools.SAMValidationError;
import net.sf.samtools.TextTagCodec;
import net.sf.samtools.util.DateParser;
import net.sf.samtools.util.LineReader;
import net.sf.samtools.util.RuntimeIOException;
import net.sf.samtools.util.StringUtil;

public class SAMTextHeaderCodec {
    private static final String HEADER_LINE_START = "@";
    private SAMFileHeader mFileHeader;
    private final TextTagCodec mTagCodec = new TextTagCodec();
    private String mCurrentLine;
    private LineReader mReader;
    private String mSource;
    private List<SAMSequenceRecord> sequences;
    private List<SAMReadGroupRecord> readGroups;
    private final StringBuilder textHeader = new StringBuilder();
    private SAMFileReader.ValidationStringency validationStringency = SAMFileReader.ValidationStringency.SILENT;
    private BufferedWriter writer;
    private static final String TAG_KEY_VALUE_SEPARATOR = ":";
    private static final char TAG_KEY_VALUE_SEPARATOR_CHAR = ':';
    private static final String FIELD_SEPARATOR = "\t";
    private static final char FIELD_SEPARATOR_CHAR = '\t';
    private static final Pattern FIELD_SEPARATOR_RE = Pattern.compile("\t");
    public static final String COMMENT_PREFIX = "@" + HeaderRecordType.CO.name() + "\t";

    public SAMFileHeader decode(LineReader lineReader, String string) {
        this.mFileHeader = new SAMFileHeader();
        this.mReader = lineReader;
        this.mSource = string;
        this.sequences = new ArrayList<SAMSequenceRecord>();
        this.readGroups = new ArrayList<SAMReadGroupRecord>();
        block7: while (this.advanceLine() != null) {
            ParsedHeaderLine parsedHeaderLine = new ParsedHeaderLine(this.mCurrentLine);
            if (!parsedHeaderLine.isLineValid()) continue;
            switch (parsedHeaderLine.getHeaderRecordType()) {
                case HD: {
                    this.parseHDLine(parsedHeaderLine);
                    continue block7;
                }
                case PG: {
                    this.parsePGLine(parsedHeaderLine);
                    continue block7;
                }
                case RG: {
                    this.parseRGLine(parsedHeaderLine);
                    continue block7;
                }
                case SQ: {
                    this.parseSQLine(parsedHeaderLine);
                    continue block7;
                }
                case CO: {
                    this.mFileHeader.addComment(this.mCurrentLine);
                    continue block7;
                }
            }
            throw new IllegalStateException("Unrecognized header record type: " + (Object)((Object)parsedHeaderLine.getHeaderRecordType()));
        }
        this.mFileHeader.setSequenceDictionary(new SAMSequenceDictionary(this.sequences));
        this.mFileHeader.setReadGroups(this.readGroups);
        if (!this.mFileHeader.getValidationErrors().isEmpty() || this.textHeader.length() < 0x100000) {
            this.mFileHeader.setTextHeader(this.textHeader.toString());
        }
        SAMUtils.processValidationErrors(this.mFileHeader.getValidationErrors(), -1L, this.validationStringency);
        return this.mFileHeader;
    }

    private String advanceLine() {
        int n = this.mReader.peek();
        if (n != 64) {
            return null;
        }
        this.mCurrentLine = this.mReader.readLine();
        this.textHeader.append(this.mCurrentLine).append("\n");
        return this.mCurrentLine;
    }

    private void transferAttributes(AbstractSAMHeaderRecord abstractSAMHeaderRecord, Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            abstractSAMHeaderRecord.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    private void parsePGLine(ParsedHeaderLine parsedHeaderLine) {
        assert (HeaderRecordType.PG.equals((Object)parsedHeaderLine.getHeaderRecordType()));
        if (!parsedHeaderLine.requireTag("ID")) {
            return;
        }
        SAMProgramRecord sAMProgramRecord = new SAMProgramRecord(parsedHeaderLine.removeValue("ID"));
        this.transferAttributes(sAMProgramRecord, parsedHeaderLine.mKeyValuePairs);
        this.mFileHeader.addProgramRecord(sAMProgramRecord);
    }

    private void parseRGLine(ParsedHeaderLine parsedHeaderLine) {
        String string;
        assert (HeaderRecordType.RG.equals((Object)parsedHeaderLine.getHeaderRecordType()));
        if (!parsedHeaderLine.requireTag("ID")) {
            return;
        }
        parsedHeaderLine.requireTag("SM");
        SAMReadGroupRecord sAMReadGroupRecord = new SAMReadGroupRecord(parsedHeaderLine.removeValue("ID"));
        this.transferAttributes(sAMReadGroupRecord, parsedHeaderLine.mKeyValuePairs);
        String string2 = sAMReadGroupRecord.getAttribute("PI");
        if (string2 != null) {
            try {
                Integer.parseInt(string2);
                sAMReadGroupRecord.setAttribute("PI", string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.reportErrorParsingLine("PI is not numeric: " + string2, SAMValidationError.Type.INVALID_PREDICTED_MEDIAN_INSERT_SIZE, numberFormatException);
            }
        }
        if ((string = sAMReadGroupRecord.getAttribute("DT")) != null) {
            Object object;
            try {
                object = this.mTagCodec.decodeDate(string);
            }
            catch (DateParser.InvalidDateException invalidDateException) {
                object = string;
                this.reportErrorParsingLine("DT tag value '" + string + "' is not parseable as a date", SAMValidationError.Type.INVALID_DATE_STRING, invalidDateException);
            }
            sAMReadGroupRecord.setAttribute("DT", object.toString());
        }
        this.readGroups.add(sAMReadGroupRecord);
    }

    private void parseSQLine(ParsedHeaderLine parsedHeaderLine) {
        assert (HeaderRecordType.SQ.equals((Object)parsedHeaderLine.getHeaderRecordType()));
        if (!parsedHeaderLine.requireTag("SN") || !parsedHeaderLine.requireTag("LN")) {
            return;
        }
        String string = parsedHeaderLine.removeValue("SN");
        string = SAMSequenceRecord.truncateSequenceName(string);
        SAMSequenceRecord sAMSequenceRecord = new SAMSequenceRecord(string, Integer.parseInt(parsedHeaderLine.removeValue("LN")));
        this.transferAttributes(sAMSequenceRecord, parsedHeaderLine.mKeyValuePairs);
        this.sequences.add(sAMSequenceRecord);
    }

    private void parseHDLine(ParsedHeaderLine parsedHeaderLine) {
        assert (HeaderRecordType.HD.equals((Object)parsedHeaderLine.getHeaderRecordType()));
        if (!parsedHeaderLine.requireTag("VN")) {
            return;
        }
        this.transferAttributes(this.mFileHeader, parsedHeaderLine.mKeyValuePairs);
    }

    private void reportErrorParsingLine(String string, SAMValidationError.Type type, Throwable throwable) {
        string = "Error parsing SAM header. " + string + ". Line:\n" + this.mCurrentLine;
        if (this.validationStringency == SAMFileReader.ValidationStringency.STRICT) {
            String string2 = "";
            if (this.mSource != null) {
                string2 = "File " + this.mSource;
            }
            throw new SAMFormatException(string + "; " + string2 + "; Line number " + this.mReader.getLineNumber(), throwable);
        }
        SAMValidationError sAMValidationError = new SAMValidationError(type, string, null, this.mReader.getLineNumber());
        sAMValidationError.setSource(this.mSource);
        this.mFileHeader.addValidationError(sAMValidationError);
    }

    public void encode(Writer writer, SAMFileHeader sAMFileHeader) {
        this.encode(writer, sAMFileHeader, false);
    }

    public void encode(Writer writer, SAMFileHeader sAMFileHeader, boolean bl) {
        this.mFileHeader = sAMFileHeader;
        this.writer = new BufferedWriter(writer);
        this.writeHDLine(bl);
        for (SAMSequenceRecord object : sAMFileHeader.getSequenceDictionary().getSequences()) {
            this.writeSQLine(object);
        }
        for (SAMReadGroupRecord sAMReadGroupRecord : sAMFileHeader.getReadGroups()) {
            this.writeRGLine(sAMReadGroupRecord);
        }
        for (SAMProgramRecord sAMProgramRecord : sAMFileHeader.getProgramRecords()) {
            this.writePGLine(sAMProgramRecord);
        }
        for (String string : sAMFileHeader.getComments()) {
            this.println(string);
        }
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(iOException);
        }
    }

    private void println(String string) {
        try {
            this.writer.append(string);
            this.writer.append("\n");
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(iOException);
        }
    }

    private void writePGLine(SAMProgramRecord sAMProgramRecord) {
        if (sAMProgramRecord == null) {
            return;
        }
        String[] stringArray = new String[2 + sAMProgramRecord.getAttributes().size()];
        stringArray[0] = HEADER_LINE_START + (Object)((Object)HeaderRecordType.PG);
        stringArray[1] = "ID:" + sAMProgramRecord.getProgramGroupId();
        this.encodeTags(sAMProgramRecord, stringArray, 2);
        this.println(StringUtil.join(FIELD_SEPARATOR, stringArray));
    }

    private void writeRGLine(SAMReadGroupRecord sAMReadGroupRecord) {
        String[] stringArray = new String[2 + sAMReadGroupRecord.getAttributes().size()];
        stringArray[0] = HEADER_LINE_START + (Object)((Object)HeaderRecordType.RG);
        stringArray[1] = "ID:" + sAMReadGroupRecord.getReadGroupId();
        this.encodeTags(sAMReadGroupRecord, stringArray, 2);
        this.println(StringUtil.join(FIELD_SEPARATOR, stringArray));
    }

    private void writeHDLine(boolean bl) {
        SAMFileHeader sAMFileHeader;
        if (bl) {
            sAMFileHeader = this.mFileHeader;
        } else {
            sAMFileHeader = new SAMFileHeader();
            for (Map.Entry entry : this.mFileHeader.getAttributes()) {
                if (((String)entry.getKey()).equals("VN")) continue;
                sAMFileHeader.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        String[] stringArray = new String[1 + sAMFileHeader.getAttributes().size()];
        stringArray[0] = HEADER_LINE_START + (Object)((Object)HeaderRecordType.HD);
        this.encodeTags(sAMFileHeader, stringArray, 1);
        this.println(StringUtil.join(FIELD_SEPARATOR, stringArray));
    }

    private void writeSQLine(SAMSequenceRecord sAMSequenceRecord) {
        int n = sAMSequenceRecord.getAttributes() != null ? sAMSequenceRecord.getAttributes().size() : 0;
        String[] stringArray = new String[3 + n];
        stringArray[0] = HEADER_LINE_START + (Object)((Object)HeaderRecordType.SQ);
        stringArray[1] = "SN:" + sAMSequenceRecord.getSequenceName();
        stringArray[2] = "LN:" + Integer.toString(sAMSequenceRecord.getSequenceLength());
        this.encodeTags(sAMSequenceRecord, stringArray, 3);
        this.println(StringUtil.join(FIELD_SEPARATOR, stringArray));
    }

    private void encodeTags(AbstractSAMHeaderRecord abstractSAMHeaderRecord, String[] stringArray, int n) {
        for (Map.Entry<String, String> entry : abstractSAMHeaderRecord.getAttributes()) {
            stringArray[n++] = this.mTagCodec.encodeUntypedTag(entry.getKey(), entry.getValue());
        }
    }

    public void setValidationStringency(SAMFileReader.ValidationStringency validationStringency) {
        if (validationStringency == null) {
            throw new IllegalArgumentException("null validationStringency not allowed");
        }
        this.validationStringency = validationStringency;
    }

    private class ParsedHeaderLine {
        private HeaderRecordType mHeaderRecordType;
        private final Map<String, String> mKeyValuePairs = new HashMap<String, String>();
        private boolean lineValid = false;

        ParsedHeaderLine(String string) {
            assert (string.startsWith(SAMTextHeaderCodec.HEADER_LINE_START));
            String[] stringArray = new String[1024];
            int n = StringUtil.split(string, stringArray, '\t');
            if (n == stringArray.length) {
                stringArray = FIELD_SEPARATOR_RE.split(string);
                n = stringArray.length;
            }
            try {
                this.mHeaderRecordType = HeaderRecordType.valueOf(stringArray[0].substring(1));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                SAMTextHeaderCodec.this.reportErrorParsingLine("Unrecognized header record type", SAMValidationError.Type.UNRECOGNIZED_HEADER_TYPE, null);
                this.mHeaderRecordType = null;
                return;
            }
            if (this.mHeaderRecordType == HeaderRecordType.CO) {
                this.lineValid = true;
                return;
            }
            String[] stringArray2 = new String[2];
            for (int i = 1; i < n; ++i) {
                if (StringUtil.splitConcatenateExcessTokens(stringArray[i], stringArray2, ':') != 2) {
                    SAMTextHeaderCodec.this.reportErrorParsingLine("Problem parsing @" + (Object)((Object)this.mHeaderRecordType) + " key:value pair", SAMValidationError.Type.POORLY_FORMATTED_HEADER_TAG, null);
                    continue;
                }
                if (this.mKeyValuePairs.containsKey(stringArray2[0]) && !this.mKeyValuePairs.get(stringArray2[0]).equals(stringArray2[1])) {
                    SAMTextHeaderCodec.this.reportErrorParsingLine("Problem parsing @" + (Object)((Object)this.mHeaderRecordType) + " key:value pair " + stringArray2[0] + SAMTextHeaderCodec.TAG_KEY_VALUE_SEPARATOR + stringArray2[1] + " clashes with " + stringArray2[0] + SAMTextHeaderCodec.TAG_KEY_VALUE_SEPARATOR + this.mKeyValuePairs.get(stringArray2[0]), SAMValidationError.Type.HEADER_TAG_MULTIPLY_DEFINED, null);
                    continue;
                }
                this.mKeyValuePairs.put(stringArray2[0], stringArray2[1]);
            }
            this.lineValid = true;
        }

        public boolean isLineValid() {
            return this.lineValid;
        }

        boolean requireTag(String string) {
            if (!this.mKeyValuePairs.containsKey(string)) {
                SAMTextHeaderCodec.this.reportErrorParsingLine(SAMTextHeaderCodec.HEADER_LINE_START + (Object)((Object)this.mHeaderRecordType) + " line missing " + string + " tag", SAMValidationError.Type.HEADER_RECORD_MISSING_REQUIRED_TAG, null);
                return false;
            }
            return true;
        }

        public HeaderRecordType getHeaderRecordType() {
            return this.mHeaderRecordType;
        }

        boolean containsKey(String string) {
            return this.mKeyValuePairs.containsKey(string);
        }

        String getValue(String string) {
            return this.mKeyValuePairs.get(string);
        }

        String removeValue(String string) {
            String string2 = this.mKeyValuePairs.get(string);
            this.mKeyValuePairs.remove(string);
            return string2;
        }
    }

    private static enum HeaderRecordType {
        HD,
        SQ,
        RG,
        PG,
        CO;

    }
}

