/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.vcf;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import net.sf.picard.cmdline.CommandLineParser;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.Log;
import net.sf.picard.util.MergingIterator;
import net.sf.picard.util.ProgressLogger;
import net.sf.picard.vcf.VariantContextComparator;
import net.sf.picard.vcf.VariantContextIterator;
import net.sf.picard.vcf.VariantContextUtils;
import net.sf.samtools.SAMSequenceDictionary;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.writer.Options;
import org.broadinstitute.variant.vcf.VCFContigHeaderLine;
import org.broadinstitute.variant.vcf.VCFHeader;
import org.broadinstitute.variant.vcf.VCFUtils;

public class MergeVcfs
extends CommandLineProgram {
    @Usage
    public final String USAGE = CommandLineParser.getStandardUsagePreamble(this.getClass()) + "Merges multiple VCF files into one file. Input files must be sorted by their contigs " + "and, within contigs, by start position. The input files must have the same sample and " + "contig lists. An index file is created and a sequence dictionary is required by default.";
    @Option(shortName="I", doc="VCF input files", minElements=1)
    public List<File> INPUT;
    @Option(shortName="O", doc="The merged VCF file")
    public File OUTPUT;
    @Option(shortName="D", doc="The index sequence dictionary (required if CREATE_INDEX=true)", optional=true)
    public File SEQUENCE_DICTIONARY;
    private final Log log = Log.getInstance(MergeVcfs.class);

    public static void main(String[] stringArray) {
        new MergeVcfs().instanceMainWithExit(stringArray);
    }

    public MergeVcfs() {
        this.CREATE_INDEX = true;
    }

    @Override
    protected int doWork() {
        Object object;
        Object object2;
        File file2;
        ProgressLogger progressLogger = new ProgressLogger(this.log, 10000);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = new ArrayList(this.INPUT.size());
        HashSet<VCFHeader> hashSet = new HashSet<VCFHeader>(this.INPUT.size());
        VariantContextComparator variantContextComparator = null;
        for (File file2 : this.INPUT) {
            IoUtil.assertFileIsReadable(file2);
            object2 = new VariantContextIterator(file2);
            object = ((VariantContextIterator)object2).getHeader();
            if (variantContextComparator == null) {
                variantContextComparator = new VariantContextComparator((Collection<VCFContigHeaderLine>)((VCFHeader)object).getContigLines());
            } else if (!variantContextComparator.isCompatible(((VCFHeader)object).getContigLines())) {
                throw new IllegalArgumentException("The contig entries in input file " + file2.getAbsolutePath() + " are not compatible with the others.");
            }
            if (arrayList.isEmpty()) {
                arrayList.addAll(((VCFHeader)object).getSampleNamesInOrder());
            } else if (!arrayList.equals(((VCFHeader)object).getSampleNamesInOrder())) {
                throw new IllegalArgumentException("Input file " + file2.getAbsolutePath() + " has sample entries that don't match the other files.");
            }
            hashSet.add((VCFHeader)object);
            arrayList2.add(object2);
        }
        EnumSet<Options> enumSet = this.CREATE_INDEX != false ? EnumSet.of(Options.INDEX_ON_THE_FLY) : EnumSet.noneOf(Options.class);
        file2 = this.SEQUENCE_DICTIONARY != null ? VariantContextUtils.getSequenceDictionary(this.SEQUENCE_DICTIONARY) : null;
        object2 = VariantContextUtils.getConditionallyCompressingWriter(this.OUTPUT, (SAMSequenceDictionary)((Object)file2), enumSet);
        object2.writeHeader(new VCFHeader(VCFUtils.smartMergeHeaders(hashSet, false), arrayList));
        object = new MergingIterator<VariantContext>(variantContextComparator, arrayList2);
        while (((MergingIterator)object).hasNext()) {
            VariantContext variantContext = (VariantContext)((MergingIterator)object).next();
            object2.add(variantContext);
            progressLogger.record(variantContext.getChr(), variantContext.getStart());
        }
        object2.close();
        return 0;
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.CREATE_INDEX.booleanValue() && this.SEQUENCE_DICTIONARY == null) {
            return new String[]{"If CREATE_INDEX is set a sequence dictionary must be specified."};
        }
        return null;
    }
}

