/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.picard.PicardException;
import net.sf.picard.metrics.MetricBase;
import net.sf.picard.metrics.MetricsFile;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.picard.reference.ReferenceSequenceFile;
import net.sf.picard.reference.ReferenceSequenceFileWalker;
import net.sf.picard.sam.CoordinateSortedPairInfoMap;
import net.sf.picard.sam.ReservedTagConstants;
import net.sf.picard.util.FastqQualityFormat;
import net.sf.picard.util.Histogram;
import net.sf.picard.util.Log;
import net.sf.picard.util.ProgressLogger;
import net.sf.picard.util.QualityEncodingDetector;
import net.sf.samtools.BamIndexValidator;
import net.sf.samtools.FileTruncatedException;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFormatException;
import net.sf.samtools.SAMProgramRecord;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;
import net.sf.samtools.SAMSortOrderChecker;
import net.sf.samtools.SAMTag;
import net.sf.samtools.SAMValidationError;
import net.sf.samtools.util.BlockCompressedInputStream;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.CloserUtil;
import net.sf.samtools.util.IOUtil;
import net.sf.samtools.util.SequenceUtil;
import net.sf.samtools.util.StringUtil;

public class SamFileValidator {
    private Histogram<SAMValidationError.Type> errorsByType = new Histogram();
    private final PrintWriter out;
    private PairEndInfoMap pairEndInfoByName;
    private ReferenceSequenceFileWalker refFileWalker = null;
    private boolean verbose = false;
    private int maxVerboseOutput = 100;
    private SAMSortOrderChecker orderChecker;
    private Set<SAMValidationError.Type> errorsToIgnore = EnumSet.noneOf(SAMValidationError.Type.class);
    private boolean ignoreWarnings = false;
    private boolean bisulfiteSequenced = false;
    private boolean validateIndex = false;
    private boolean sequenceDictionaryEmptyAndNoWarningEmitted = false;
    private final int maxTempFiles;
    private static final Log log = Log.getInstance(SamFileValidator.class);

    public SamFileValidator(PrintWriter printWriter, int n) {
        this.out = printWriter;
        this.maxTempFiles = n;
    }

    public void setErrorsToIgnore(Collection<SAMValidationError.Type> collection) {
        if (!collection.isEmpty()) {
            this.errorsToIgnore = EnumSet.copyOf(collection);
        }
    }

    public void setIgnoreWarnings(boolean bl) {
        this.ignoreWarnings = bl;
    }

    public boolean validateSamFileSummary(SAMFileReader sAMFileReader, ReferenceSequenceFile referenceSequenceFile) {
        this.init(referenceSequenceFile, sAMFileReader.getFileHeader());
        this.validateSamFile(sAMFileReader, this.out);
        boolean bl = this.errorsByType.isEmpty();
        if (this.errorsByType.getCount() > 0.0) {
            Histogram<String> histogram = new Histogram<String>("Error Type", "Count");
            for (Histogram.Bin bin : this.errorsByType.values()) {
                histogram.increment(((SAMValidationError.Type)((Object)bin.getId())).getHistogramString(), bin.getValue());
            }
            MetricsFile metricsFile = new MetricsFile();
            this.errorsByType.setBinLabel("Error Type");
            this.errorsByType.setValueLabel("Count");
            metricsFile.setHistogram(histogram);
            metricsFile.write(this.out);
        }
        this.cleanup();
        return bl;
    }

    public boolean validateSamFileVerbose(SAMFileReader sAMFileReader, ReferenceSequenceFile referenceSequenceFile) {
        this.init(referenceSequenceFile, sAMFileReader.getFileHeader());
        try {
            this.validateSamFile(sAMFileReader, this.out);
        }
        catch (MaxOutputExceededException maxOutputExceededException) {
            this.out.println("Maximum output of [" + this.maxVerboseOutput + "] errors reached.");
        }
        boolean bl = this.errorsByType.isEmpty();
        this.cleanup();
        return bl;
    }

    public void validateBamFileTermination(File file) {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = IOUtil.toBufferedStream(new FileInputStream(file));
            if (!BlockCompressedInputStream.isValidFile(bufferedInputStream)) {
                return;
            }
            BlockCompressedInputStream.FileTermination fileTermination = BlockCompressedInputStream.checkTermination(file);
            if (fileTermination.equals((Object)BlockCompressedInputStream.FileTermination.DEFECTIVE)) {
                this.addError(new SAMValidationError(SAMValidationError.Type.TRUNCATED_FILE, "BAM file has defective last gzip block", file.getPath()));
            } else if (fileTermination.equals((Object)BlockCompressedInputStream.FileTermination.HAS_HEALTHY_LAST_BLOCK)) {
                this.addError(new SAMValidationError(SAMValidationError.Type.BAM_FILE_MISSING_TERMINATOR_BLOCK, "Older BAM file -- does not have terminator block", file.getPath()));
            }
        }
        catch (IOException iOException) {
            throw new PicardException("IOException", iOException);
        }
        finally {
            if (bufferedInputStream != null) {
                CloserUtil.close(bufferedInputStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateSamFile(SAMFileReader sAMFileReader, PrintWriter printWriter) {
        try {
            sAMFileReader.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
            this.validateHeader(sAMFileReader.getFileHeader());
            this.orderChecker = new SAMSortOrderChecker(sAMFileReader.getFileHeader().getSortOrder());
            this.validateSamRecordsAndQualityFormat(sAMFileReader, sAMFileReader.getFileHeader());
            this.validateUnmatchedPairs();
            if (this.validateIndex) {
                try {
                    BamIndexValidator.exhaustivelyTestIndex(sAMFileReader);
                }
                catch (Exception exception) {
                    this.addError(new SAMValidationError(SAMValidationError.Type.INVALID_INDEX_FILE_POINTER, exception.getMessage(), null));
                }
            }
            if (this.errorsByType.isEmpty()) {
                printWriter.println("No errors found");
            }
        }
        finally {
            printWriter.flush();
        }
    }

    private void validateUnmatchedPairs() {
        InMemoryPairEndInfoMap inMemoryPairEndInfoMap;
        if (this.pairEndInfoByName instanceof CoordinateSortedPairEndInfoMap) {
            inMemoryPairEndInfoMap = new InMemoryPairEndInfoMap();
            Iterator iterator = ((CoordinateSortedPairEndInfoMap)this.pairEndInfoByName).iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                PairEndInfo pairEndInfo = inMemoryPairEndInfoMap.remove(((PairEndInfo)entry.getValue()).readReferenceIndex, (String)entry.getKey());
                if (pairEndInfo != null) {
                    List<SAMValidationError> list = pairEndInfo.validateMates((PairEndInfo)entry.getValue(), (String)entry.getKey());
                    for (SAMValidationError sAMValidationError : list) {
                        this.addError(sAMValidationError);
                    }
                    continue;
                }
                inMemoryPairEndInfoMap.put(((PairEndInfo)entry.getValue()).mateReferenceIndex, (String)entry.getKey(), (PairEndInfo)entry.getValue());
            }
            iterator.close();
        } else {
            inMemoryPairEndInfoMap = (InMemoryPairEndInfoMap)this.pairEndInfoByName;
        }
        for (Map.Entry entry : inMemoryPairEndInfoMap) {
            this.addError(new SAMValidationError(SAMValidationError.Type.MATE_NOT_FOUND, "Mate not found for paired read", (String)entry.getKey()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateSamRecordsAndQualityFormat(Iterable<SAMRecord> iterable, SAMFileHeader sAMFileHeader) {
        SAMRecordIterator sAMRecordIterator = (SAMRecordIterator)iterable.iterator();
        ProgressLogger progressLogger = new ProgressLogger(log, 10000000, "Validated Read");
        QualityEncodingDetector qualityEncodingDetector = new QualityEncodingDetector();
        try {
            Object object;
            while (sAMRecordIterator.hasNext()) {
                object = (SAMRecord)sAMRecordIterator.next();
                qualityEncodingDetector.add((SAMRecord)object);
                long l = progressLogger.getCount() + 1L;
                List<SAMValidationError> list = ((SAMRecord)object).isValid();
                if (list != null) {
                    for (SAMValidationError sAMValidationError : list) {
                        sAMValidationError.setRecordNumber(l);
                        this.addError(sAMValidationError);
                    }
                }
                this.validateMateFields((SAMRecord)object, l);
                this.validateSortOrder((SAMRecord)object, l);
                this.validateReadGroup((SAMRecord)object, sAMFileHeader);
                boolean bl = this.validateCigar((SAMRecord)object, l);
                if (bl) {
                    this.validateNmTag((SAMRecord)object, l);
                }
                this.validateSecondaryBaseCalls((SAMRecord)object, l);
                this.validateTags((SAMRecord)object, l);
                if (this.sequenceDictionaryEmptyAndNoWarningEmitted && !((SAMRecord)object).getReadUnmappedFlag()) {
                    this.addError(new SAMValidationError(SAMValidationError.Type.MISSING_SEQUENCE_DICTIONARY, "Sequence dictionary is empty", null));
                    this.sequenceDictionaryEmptyAndNoWarningEmitted = false;
                }
                progressLogger.record((SAMRecord)object);
            }
            try {
                if (progressLogger.getCount() > 0L && (object = qualityEncodingDetector.generateBestGuess(QualityEncodingDetector.FileContext.SAM)) != FastqQualityFormat.Standard) {
                    this.addError(new SAMValidationError(SAMValidationError.Type.INVALID_QUALITY_FORMAT, String.format("Detected %s quality score encoding, but expected %s.", new Object[]{object, FastqQualityFormat.Standard}), null));
                }
            }
            catch (PicardException picardException) {
                this.addError(new SAMValidationError(SAMValidationError.Type.INVALID_QUALITY_FORMAT, picardException.getMessage(), null));
            }
        }
        catch (SAMFormatException sAMFormatException) {
            String string = "SAMFormatException on record " + progressLogger.getCount() + 1;
            this.out.println(string);
            throw new PicardException(string, sAMFormatException);
        }
        catch (FileTruncatedException fileTruncatedException) {
            this.addError(new SAMValidationError(SAMValidationError.Type.TRUNCATED_FILE, "File is truncated", null));
        }
        finally {
            sAMRecordIterator.close();
        }
    }

    private void validateReadGroup(SAMRecord sAMRecord, SAMFileHeader sAMFileHeader) {
        SAMReadGroupRecord sAMReadGroupRecord = sAMRecord.getReadGroup();
        if (sAMReadGroupRecord == null) {
            this.addError(new SAMValidationError(SAMValidationError.Type.RECORD_MISSING_READ_GROUP, "A record is missing a read group", sAMRecord.getReadName()));
        } else if (!sAMFileHeader.getReadGroups().contains(sAMReadGroupRecord)) {
            this.addError(new SAMValidationError(SAMValidationError.Type.READ_GROUP_NOT_FOUND, "A record has a read group not found in the header: ", sAMRecord.getReadName() + ", " + sAMReadGroupRecord.getReadGroupId()));
        }
    }

    private void validateTags(SAMRecord sAMRecord, long l) {
        for (SAMRecord.SAMTagAndValue sAMTagAndValue : sAMRecord.getAttributes()) {
            if (!(sAMTagAndValue.value instanceof Long)) continue;
            this.addError(new SAMValidationError(SAMValidationError.Type.TAG_VALUE_TOO_LARGE, "Numeric value too large for tag " + sAMTagAndValue.tag, sAMRecord.getReadName(), l));
        }
    }

    private void validateSecondaryBaseCalls(SAMRecord sAMRecord, long l) {
        Object object;
        String string = (String)sAMRecord.getAttribute(SAMTag.E2.name());
        if (string != null) {
            if (string.length() != sAMRecord.getReadLength()) {
                this.addError(new SAMValidationError(SAMValidationError.Type.MISMATCH_READ_LENGTH_AND_E2_LENGTH, String.format("E2 tag length (%d) != read length (%d)", string.length(), sAMRecord.getReadLength()), sAMRecord.getReadName(), l));
            }
            object = sAMRecord.getReadBases();
            byte[] byArray = StringUtil.stringToBytes(string);
            for (int i = 0; i < Math.min(((Object)object).length, byArray.length); ++i) {
                if (SequenceUtil.isNoCall((byte)object[i]) || SequenceUtil.isNoCall(byArray[i]) || !SequenceUtil.basesEqual((byte)object[i], byArray[i])) continue;
                this.addError(new SAMValidationError(SAMValidationError.Type.E2_BASE_EQUALS_PRIMARY_BASE, String.format("Secondary base call  (%c) == primary base call (%c)", Character.valueOf((char)byArray[i]), Character.valueOf((char)object[i])), sAMRecord.getReadName(), l));
                break;
            }
        }
        if ((object = (String)sAMRecord.getAttribute(SAMTag.U2.name())) != null && ((String)object).length() != sAMRecord.getReadLength()) {
            this.addError(new SAMValidationError(SAMValidationError.Type.MISMATCH_READ_LENGTH_AND_U2_LENGTH, String.format("U2 tag length (%d) != read length (%d)", ((String)object).length(), sAMRecord.getReadLength()), sAMRecord.getReadName(), l));
        }
    }

    private boolean validateCigar(SAMRecord sAMRecord, long l) {
        if (sAMRecord.getReadUnmappedFlag()) {
            return true;
        }
        SAMFileReader.ValidationStringency validationStringency = sAMRecord.getValidationStringency();
        sAMRecord.setValidationStringency(SAMFileReader.ValidationStringency.LENIENT);
        List<SAMValidationError> list = sAMRecord.validateCigar(l);
        sAMRecord.setValidationStringency(validationStringency);
        if (list == null) {
            return true;
        }
        boolean bl = true;
        for (SAMValidationError sAMValidationError : list) {
            this.addError(sAMValidationError);
            bl = false;
        }
        return bl;
    }

    private void validateSortOrder(SAMRecord sAMRecord, long l) {
        SAMRecord sAMRecord2 = this.orderChecker.getPreviousRecord();
        if (!this.orderChecker.isSorted(sAMRecord)) {
            this.addError(new SAMValidationError(SAMValidationError.Type.RECORD_OUT_OF_ORDER, String.format("The record is out of [%s] order, prior read name [%s], prior coodinates [%d:%d]", sAMRecord.getHeader().getSortOrder().name(), sAMRecord2.getReadName(), sAMRecord2.getReferenceIndex(), sAMRecord2.getAlignmentStart()), sAMRecord.getReadName(), l));
        }
    }

    private void init(ReferenceSequenceFile referenceSequenceFile, SAMFileHeader sAMFileHeader) {
        this.pairEndInfoByName = sAMFileHeader.getSortOrder() == SAMFileHeader.SortOrder.coordinate ? new CoordinateSortedPairEndInfoMap() : new InMemoryPairEndInfoMap();
        if (referenceSequenceFile != null) {
            this.refFileWalker = new ReferenceSequenceFileWalker(referenceSequenceFile);
        }
    }

    private void cleanup() {
        this.errorsByType = null;
        this.pairEndInfoByName = null;
        this.refFileWalker = null;
    }

    private void validateNmTag(SAMRecord sAMRecord, long l) {
        if (!sAMRecord.getReadUnmappedFlag()) {
            ReferenceSequence referenceSequence;
            int n;
            Integer n2 = sAMRecord.getIntegerAttribute(ReservedTagConstants.NM);
            if (n2 == null) {
                this.addError(new SAMValidationError(SAMValidationError.Type.MISSING_TAG_NM, "NM tag (nucleotide differences) is missing", sAMRecord.getReadName(), l));
            } else if (this.refFileWalker != null && !n2.equals(n = SequenceUtil.calculateSamNmTag(sAMRecord, (referenceSequence = this.refFileWalker.get(sAMRecord.getReferenceIndex())).getBases(), 0, this.isBisulfiteSequenced()))) {
                this.addError(new SAMValidationError(SAMValidationError.Type.INVALID_TAG_NM, "NM tag (nucleotide differences) in file [" + n2 + "] does not match reality [" + n + "]", sAMRecord.getReadName(), l));
            }
        }
    }

    private void validateMateFields(SAMRecord sAMRecord, long l) {
        if (!sAMRecord.getReadPairedFlag() || sAMRecord.getNotPrimaryAlignmentFlag()) {
            return;
        }
        PairEndInfo pairEndInfo = this.pairEndInfoByName.remove(sAMRecord.getReferenceIndex(), sAMRecord.getReadName());
        if (pairEndInfo == null) {
            this.pairEndInfoByName.put(sAMRecord.getMateReferenceIndex(), sAMRecord.getReadName(), new PairEndInfo(sAMRecord, l));
        } else {
            List<SAMValidationError> list = pairEndInfo.validateMates(new PairEndInfo(sAMRecord, l), sAMRecord.getReadName());
            for (SAMValidationError sAMValidationError : list) {
                this.addError(sAMValidationError);
            }
        }
    }

    private void validateHeader(SAMFileHeader sAMFileHeader) {
        int n;
        for (SAMValidationError sAMValidationError : sAMFileHeader.getValidationErrors()) {
            this.addError(sAMValidationError);
        }
        if (sAMFileHeader.getVersion() == null) {
            this.addError(new SAMValidationError(SAMValidationError.Type.MISSING_VERSION_NUMBER, "Header has no version number", null));
        } else if (!SAMFileHeader.ACCEPTABLE_VERSIONS.contains(sAMFileHeader.getVersion())) {
            this.addError(new SAMValidationError(SAMValidationError.Type.INVALID_VERSION_NUMBER, "Header version: " + sAMFileHeader.getVersion() + " does not match any of the acceptable versions: " + StringUtil.join(", ", SAMFileHeader.ACCEPTABLE_VERSIONS.toArray(new String[0])), null));
        }
        if (sAMFileHeader.getSequenceDictionary().isEmpty()) {
            this.sequenceDictionaryEmptyAndNoWarningEmitted = true;
        }
        if (sAMFileHeader.getReadGroups().isEmpty()) {
            this.addError(new SAMValidationError(SAMValidationError.Type.MISSING_READ_GROUP, "Read groups is empty", null));
        }
        List<SAMProgramRecord> list = sAMFileHeader.getProgramRecords();
        for (int i = 0; i < list.size() - 1; ++i) {
            for (n = i + 1; n < list.size(); ++n) {
                if (!((SAMProgramRecord)list.get(i)).getProgramGroupId().equals(((SAMProgramRecord)list.get(n)).getProgramGroupId())) continue;
                this.addError(new SAMValidationError(SAMValidationError.Type.DUPLICATE_PROGRAM_GROUP_ID, "Duplicate program group id: " + ((SAMProgramRecord)list.get(i)).getProgramGroupId(), null));
            }
        }
        List<SAMReadGroupRecord> list2 = sAMFileHeader.getReadGroups();
        for (n = 0; n < list2.size() - 1; ++n) {
            for (int i = n + 1; i < list2.size(); ++i) {
                if (!list2.get(n).getReadGroupId().equals(list2.get(i).getReadGroupId())) continue;
                this.addError(new SAMValidationError(SAMValidationError.Type.DUPLICATE_READ_GROUP_ID, "Duplicate read group id: " + list2.get(n).getReadGroupId(), null));
            }
        }
    }

    private void addError(SAMValidationError sAMValidationError) {
        if (this.errorsToIgnore.contains((Object)sAMValidationError.getType())) {
            return;
        }
        if (this.ignoreWarnings && sAMValidationError.getType().severity == SAMValidationError.Severity.WARNING) {
            return;
        }
        this.errorsByType.increment(sAMValidationError.getType());
        if (this.verbose) {
            this.out.println(sAMValidationError);
            this.out.flush();
            if (this.errorsByType.getCount() >= (double)this.maxVerboseOutput) {
                throw new MaxOutputExceededException();
            }
        }
    }

    public void setVerbose(boolean bl, int n) {
        this.verbose = bl;
        this.maxVerboseOutput = n;
    }

    public boolean isBisulfiteSequenced() {
        return this.bisulfiteSequenced;
    }

    public void setBisulfiteSequenced(boolean bl) {
        this.bisulfiteSequenced = bl;
    }

    public SamFileValidator setValidateIndex(boolean bl) {
        this.validateIndex = bl;
        return this;
    }

    private static class InMemoryPairEndInfoMap
    implements PairEndInfoMap {
        private final Map<String, PairEndInfo> map = new HashMap<String, PairEndInfo>();

        private InMemoryPairEndInfoMap() {
        }

        @Override
        public void put(int n, String string, PairEndInfo pairEndInfo) {
            if (n != pairEndInfo.mateReferenceIndex) {
                throw new IllegalArgumentException("mateReferenceIndex does not agree with PairEndInfo");
            }
            this.map.put(string, pairEndInfo);
        }

        @Override
        public PairEndInfo remove(int n, String string) {
            return this.map.remove(string);
        }

        @Override
        public CloseableIterator<Map.Entry<String, PairEndInfo>> iterator() {
            final Iterator<Map.Entry<String, PairEndInfo>> iterator = this.map.entrySet().iterator();
            return new CloseableIterator<Map.Entry<String, PairEndInfo>>(){

                @Override
                public void close() {
                }

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Map.Entry<String, PairEndInfo> next() {
                    return (Map.Entry)iterator.next();
                }

                @Override
                public void remove() {
                    iterator.remove();
                }
            };
        }
    }

    private class CoordinateSortedPairEndInfoMap
    implements PairEndInfoMap {
        private final CoordinateSortedPairInfoMap<String, PairEndInfo> onDiskMap;

        private CoordinateSortedPairEndInfoMap() {
            this.onDiskMap = new CoordinateSortedPairInfoMap<String, PairEndInfo>(SamFileValidator.this.maxTempFiles, new Codec());
        }

        @Override
        public void put(int n, String string, PairEndInfo pairEndInfo) {
            this.onDiskMap.put(n, string, pairEndInfo);
        }

        @Override
        public PairEndInfo remove(int n, String string) {
            return this.onDiskMap.remove(n, string);
        }

        @Override
        public CloseableIterator<Map.Entry<String, PairEndInfo>> iterator() {
            return this.onDiskMap.iterator();
        }

        private class Codec
        implements CoordinateSortedPairInfoMap.Codec<String, PairEndInfo> {
            private DataInputStream in;
            private DataOutputStream out;

            private Codec() {
            }

            @Override
            public void setOutputStream(OutputStream outputStream) {
                this.out = new DataOutputStream(outputStream);
            }

            @Override
            public void setInputStream(InputStream inputStream) {
                this.in = new DataInputStream(inputStream);
            }

            @Override
            public void encode(String string, PairEndInfo pairEndInfo) {
                try {
                    this.out.writeUTF(string);
                    this.out.writeInt(pairEndInfo.readAlignmentStart);
                    this.out.writeInt(pairEndInfo.readReferenceIndex);
                    this.out.writeBoolean(pairEndInfo.readNegStrandFlag);
                    this.out.writeBoolean(pairEndInfo.readUnmappedFlag);
                    this.out.writeInt(pairEndInfo.mateAlignmentStart);
                    this.out.writeInt(pairEndInfo.mateReferenceIndex);
                    this.out.writeBoolean(pairEndInfo.mateNegStrandFlag);
                    this.out.writeBoolean(pairEndInfo.mateUnmappedFlag);
                    this.out.writeBoolean(pairEndInfo.firstOfPairFlag);
                    this.out.writeLong(pairEndInfo.recordNumber);
                }
                catch (IOException iOException) {
                    throw new PicardException("Error spilling PairInfo to disk", iOException);
                }
            }

            @Override
            public Map.Entry<String, PairEndInfo> decode() {
                try {
                    String string = this.in.readUTF();
                    int n = this.in.readInt();
                    int n2 = this.in.readInt();
                    boolean bl = this.in.readBoolean();
                    boolean bl2 = this.in.readBoolean();
                    int n3 = this.in.readInt();
                    int n4 = this.in.readInt();
                    boolean bl3 = this.in.readBoolean();
                    boolean bl4 = this.in.readBoolean();
                    boolean bl5 = this.in.readBoolean();
                    long l = this.in.readLong();
                    PairEndInfo pairEndInfo = new PairEndInfo(n, n2, bl, bl2, n3, n4, bl3, bl4, bl5, l);
                    return new AbstractMap.SimpleEntry<String, PairEndInfo>(string, pairEndInfo);
                }
                catch (IOException iOException) {
                    throw new PicardException("Error reading PairInfo from disk", iOException);
                }
            }
        }
    }

    static interface PairEndInfoMap
    extends Iterable<Map.Entry<String, PairEndInfo>> {
        public void put(int var1, String var2, PairEndInfo var3);

        public PairEndInfo remove(int var1, String var2);

        @Override
        public CloseableIterator<Map.Entry<String, PairEndInfo>> iterator();
    }

    private static class MaxOutputExceededException
    extends PicardException {
        MaxOutputExceededException() {
            super("maxVerboseOutput exceeded.");
        }
    }

    private static class PairEndInfo {
        private final int readAlignmentStart;
        private final int readReferenceIndex;
        private final boolean readNegStrandFlag;
        private final boolean readUnmappedFlag;
        private final int mateAlignmentStart;
        private final int mateReferenceIndex;
        private final boolean mateNegStrandFlag;
        private final boolean mateUnmappedFlag;
        private final boolean firstOfPairFlag;
        private final long recordNumber;

        public PairEndInfo(SAMRecord sAMRecord, long l) {
            this.recordNumber = l;
            this.readAlignmentStart = sAMRecord.getAlignmentStart();
            this.readNegStrandFlag = sAMRecord.getReadNegativeStrandFlag();
            this.readReferenceIndex = sAMRecord.getReferenceIndex();
            this.readUnmappedFlag = sAMRecord.getReadUnmappedFlag();
            this.mateAlignmentStart = sAMRecord.getMateAlignmentStart();
            this.mateNegStrandFlag = sAMRecord.getMateNegativeStrandFlag();
            this.mateReferenceIndex = sAMRecord.getMateReferenceIndex();
            this.mateUnmappedFlag = sAMRecord.getMateUnmappedFlag();
            this.firstOfPairFlag = sAMRecord.getFirstOfPairFlag();
        }

        private PairEndInfo(int n, int n2, boolean bl, boolean bl2, int n3, int n4, boolean bl3, boolean bl4, boolean bl5, long l) {
            this.readAlignmentStart = n;
            this.readReferenceIndex = n2;
            this.readNegStrandFlag = bl;
            this.readUnmappedFlag = bl2;
            this.mateAlignmentStart = n3;
            this.mateReferenceIndex = n4;
            this.mateNegStrandFlag = bl3;
            this.mateUnmappedFlag = bl4;
            this.firstOfPairFlag = bl5;
            this.recordNumber = l;
        }

        public List<SAMValidationError> validateMates(PairEndInfo pairEndInfo, String string) {
            ArrayList<SAMValidationError> arrayList = new ArrayList<SAMValidationError>();
            this.validateMateFields(this, pairEndInfo, string, arrayList);
            this.validateMateFields(pairEndInfo, this, string, arrayList);
            if (this.firstOfPairFlag == pairEndInfo.firstOfPairFlag) {
                String string2 = this.firstOfPairFlag ? "first" : "second";
                arrayList.add(new SAMValidationError(SAMValidationError.Type.MATES_ARE_SAME_END, "Both mates are marked as " + string2 + " of pair", string, this.recordNumber));
            }
            return arrayList;
        }

        private void validateMateFields(PairEndInfo pairEndInfo, PairEndInfo pairEndInfo2, String string, List<SAMValidationError> list) {
            if (pairEndInfo.mateAlignmentStart != pairEndInfo2.readAlignmentStart) {
                list.add(new SAMValidationError(SAMValidationError.Type.MISMATCH_MATE_ALIGNMENT_START, "Mate alignment does not match alignment start of mate", string, pairEndInfo.recordNumber));
            }
            if (pairEndInfo.mateNegStrandFlag != pairEndInfo2.readNegStrandFlag) {
                list.add(new SAMValidationError(SAMValidationError.Type.MISMATCH_FLAG_MATE_NEG_STRAND, "Mate negative strand flag does not match read negative strand flag of mate", string, pairEndInfo.recordNumber));
            }
            if (pairEndInfo.mateReferenceIndex != pairEndInfo2.readReferenceIndex) {
                list.add(new SAMValidationError(SAMValidationError.Type.MISMATCH_MATE_REF_INDEX, "Mate reference index (MRNM) does not match reference index of mate", string, pairEndInfo.recordNumber));
            }
            if (pairEndInfo.mateUnmappedFlag != pairEndInfo2.readUnmappedFlag) {
                list.add(new SAMValidationError(SAMValidationError.Type.MISMATCH_FLAG_MATE_UNMAPPED, "Mate unmapped flag does not match read unmapped flag of mate", string, pairEndInfo.recordNumber));
            }
        }
    }

    public static class ValidationMetrics
    extends MetricBase {
    }
}

