/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import net.sf.picard.PicardException;
import net.sf.picard.filter.FilteringIterator;
import net.sf.picard.filter.SamRecordFilter;
import net.sf.picard.sam.PrimaryAlignmentSelectionStrategy;
import net.sf.picard.util.Log;
import net.sf.picard.util.PeekableIterator;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordQueryNameComparator;
import net.sf.samtools.SAMTag;
import net.sf.samtools.SAMUtils;
import net.sf.samtools.util.CloseableIterator;

class MultiHitAlignedReadIterator
implements CloseableIterator<HitsForInsert> {
    private static final Log log = Log.getInstance(MultiHitAlignedReadIterator.class);
    private final PeekableIterator<SAMRecord> peekIterator;
    private final HitIndexComparator comparator = new HitIndexComparator();
    private final SAMRecordQueryNameComparator queryNameComparator = new SAMRecordQueryNameComparator();
    private final PrimaryAlignmentSelectionStrategy primaryAlignmentSelectionStrategy;
    private final Random random = new Random(1L);

    MultiHitAlignedReadIterator(CloseableIterator<SAMRecord> closeableIterator, PrimaryAlignmentSelectionStrategy primaryAlignmentSelectionStrategy) {
        this.primaryAlignmentSelectionStrategy = primaryAlignmentSelectionStrategy;
        this.peekIterator = new PeekableIterator<SAMRecord>(new FilteringIterator(closeableIterator, new SamRecordFilter(){

            @Override
            public boolean filterOut(SAMRecord sAMRecord) {
                return sAMRecord.getReadUnmappedFlag() || SAMUtils.cigarMapsNoBasesToRef(sAMRecord.getCigar());
            }

            @Override
            public boolean filterOut(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
                return !(!sAMRecord.getReadUnmappedFlag() && !SAMUtils.cigarMapsNoBasesToRef(sAMRecord.getCigar()) || !sAMRecord2.getReadUnmappedFlag() && !SAMUtils.cigarMapsNoBasesToRef(sAMRecord2.getCigar()));
            }
        }));
    }

    @Override
    public void close() {
        this.peekIterator.close();
    }

    @Override
    public boolean hasNext() {
        return this.peekIterator.hasNext();
    }

    @Override
    public HitsForInsert next() {
        String string = this.peekIterator.peek().getReadName();
        HitsForInsert hitsForInsert = new HitsForInsert();
        Boolean bl = null;
        while (this.peekIterator.hasNext() && this.peekIterator.peek().getReadName().equals(string)) {
            SAMRecord sAMRecord = this.peekIterator.next();
            if (this.peekIterator.hasNext() && this.queryNameComparator.fileOrderCompare(sAMRecord, this.peekIterator.peek()) > 0) {
                throw new IllegalStateException("Underlying iterator is not queryname sorted: " + sAMRecord + " > " + this.peekIterator.peek());
            }
            if (SAMUtils.cigarMapsNoBasesToRef(sAMRecord.getCigar())) {
                SAMUtils.makeReadUnmapped(sAMRecord);
            }
            if (bl == null) {
                bl = sAMRecord.getReadPairedFlag();
            } else if (bl.booleanValue() != sAMRecord.getReadPairedFlag()) {
                throw new PicardException("Got a mix of paired and unpaired alignments for read " + string);
            }
            if (!sAMRecord.getReadPairedFlag() || sAMRecord.getFirstOfPairFlag()) {
                hitsForInsert.firstOfPairOrFragment.add(sAMRecord);
                continue;
            }
            if (sAMRecord.getSecondOfPairFlag()) {
                hitsForInsert.secondOfPair.add(sAMRecord);
                continue;
            }
            throw new PicardException("Read is marked as pair but neither first or second: " + string);
        }
        if (!hitsForInsert.firstOfPairOrFragment.isEmpty() && !hitsForInsert.secondOfPair.isEmpty()) {
            if (hitsForInsert.firstOfPairOrFragment.size() != hitsForInsert.secondOfPair.size()) {
                throw new PicardException("Unequal number of first and second of pair hits for read: " + string);
            }
            if (hitsForInsert.firstOfPairOrFragment.size() > 1) {
                Collections.sort(hitsForInsert.firstOfPairOrFragment, this.comparator);
                Collections.sort(hitsForInsert.secondOfPair, this.comparator);
                for (int i = 0; i < hitsForInsert.firstOfPairOrFragment.size(); ++i) {
                    if (((SAMRecord)hitsForInsert.firstOfPairOrFragment.get(i)).getIntegerAttribute(SAMTag.HI.name()) == null) {
                        throw new PicardException("Missing HI tag on multi-hit alignment for read: " + string);
                    }
                    if (((SAMRecord)hitsForInsert.firstOfPairOrFragment.get(i)).getIntegerAttribute(SAMTag.HI.name()).equals(((SAMRecord)hitsForInsert.secondOfPair.get(i)).getIntegerAttribute(SAMTag.HI.name()))) continue;
                    throw new PicardException("Hit index mismatch for multi-hit alignment for read: " + string);
                }
            }
        }
        NumPrimaryAlignmentState numPrimaryAlignmentState = hitsForInsert.tallyPrimaryAlignments(hitsForInsert.firstOfPairOrFragment);
        NumPrimaryAlignmentState numPrimaryAlignmentState2 = hitsForInsert.tallyPrimaryAlignments(hitsForInsert.secondOfPair);
        if (numPrimaryAlignmentState == NumPrimaryAlignmentState.NONE && numPrimaryAlignmentState2 == NumPrimaryAlignmentState.NONE || numPrimaryAlignmentState == NumPrimaryAlignmentState.MORE_THAN_ONE || numPrimaryAlignmentState2 == NumPrimaryAlignmentState.MORE_THAN_ONE) {
            this.primaryAlignmentSelectionStrategy.pickPrimaryAlignment(hitsForInsert);
        } else {
            int n = hitsForInsert.findPrimaryAlignment(hitsForInsert.firstOfPairOrFragment);
            int n2 = hitsForInsert.findPrimaryAlignment(hitsForInsert.secondOfPair);
            if (n != -1 && n2 != -1 && n != n2) {
                throw new PicardException("Mismatched primary alignments for paired read " + hitsForInsert.getReadName());
            }
        }
        return hitsForInsert;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static class HitIndexComparator
    implements Comparator<SAMRecord> {
        private HitIndexComparator() {
        }

        @Override
        public int compare(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
            Integer n = sAMRecord.getIntegerAttribute(SAMTag.HI.name());
            Integer n2 = sAMRecord2.getIntegerAttribute(SAMTag.HI.name());
            if (n == null || n2 == null) {
                throw new PicardException("HI tag missing for multi-hit paired alignments for read: " + sAMRecord.getReadName());
            }
            return n.compareTo(n2);
        }
    }

    private static enum NumPrimaryAlignmentState {
        NONE,
        ONE,
        MORE_THAN_ONE;

    }

    public class HitsForInsert {
        private final List<SAMRecord> firstOfPairOrFragment = new ArrayList<SAMRecord>();
        private final List<SAMRecord> secondOfPair = new ArrayList<SAMRecord>();

        public String getReadName() {
            return this.getRepresentativeRead().getReadName();
        }

        public boolean isPaired() {
            return this.getRepresentativeRead().getReadPairedFlag();
        }

        public SAMRecord getRepresentativeRead() {
            for (SAMRecord sAMRecord : this.firstOfPairOrFragment) {
                if (sAMRecord == null) continue;
                return sAMRecord;
            }
            for (SAMRecord sAMRecord : this.secondOfPair) {
                if (sAMRecord == null) continue;
                return sAMRecord;
            }
            throw new IllegalStateException("Should not be called if numHits == 0");
        }

        public int numHits() {
            return Math.max(this.firstOfPairOrFragment.size(), this.secondOfPair.size());
        }

        public SAMRecord getFirstOfPair(int n) {
            if (this.firstOfPairOrFragment.isEmpty()) {
                return null;
            }
            return this.firstOfPairOrFragment.get(n);
        }

        public SAMRecord getFragment(int n) {
            SAMRecord sAMRecord = this.firstOfPairOrFragment.get(n);
            if (sAMRecord.getReadPairedFlag()) {
                throw new UnsupportedOperationException("getFragment called for paired read");
            }
            return sAMRecord;
        }

        public SAMRecord getSecondOfPair(int n) {
            if (this.secondOfPair.isEmpty()) {
                return null;
            }
            return this.secondOfPair.get(n);
        }

        public void setPrimaryAlignment(int n) {
            if (n < 0 || n >= this.numHits()) {
                throw new IllegalArgumentException("primaryAlignmentIndex(" + n + ") out of range for numHits(" + this.numHits() + ")");
            }
            for (int i = 0; i < this.numHits(); ++i) {
                boolean bl;
                boolean bl2 = bl = i != n;
                if (this.getFirstOfPair(i) != null) {
                    this.getFirstOfPair(i).setNotPrimaryAlignmentFlag(bl);
                }
                if (this.getSecondOfPair(i) == null) continue;
                this.getSecondOfPair(i).setNotPrimaryAlignmentFlag(bl);
            }
        }

        public void filterReads(SamRecordFilter samRecordFilter, PrimaryAlignmentSelectionStrategy primaryAlignmentSelectionStrategy) {
            int n;
            this.filterReads(samRecordFilter, this.firstOfPairOrFragment);
            this.filterReads(samRecordFilter, this.secondOfPair);
            if (!this.firstOfPairOrFragment.isEmpty() && !this.secondOfPair.isEmpty()) {
                if (this.firstOfPairOrFragment.size() != this.secondOfPair.size()) {
                    throw new IllegalStateException("Both ends of pair have hits, but not the same number of hits for each end");
                }
                for (n = this.firstOfPairOrFragment.size() - 1; n >= 0; --n) {
                    if (this.firstOfPairOrFragment.get(n) == null) {
                        if (this.secondOfPair.get(n) == null) {
                            this.firstOfPairOrFragment.remove(n);
                            this.secondOfPair.remove(n);
                            continue;
                        }
                        this.secondOfPair.get(n).setAttribute(SAMTag.HI.name(), null);
                        continue;
                    }
                    if (this.secondOfPair.get(n) != null) continue;
                    this.firstOfPairOrFragment.get(n).setAttribute(SAMTag.HI.name(), null);
                }
                if (this.areAllElementsNull(this.firstOfPairOrFragment)) {
                    this.firstOfPairOrFragment.clear();
                }
                if (this.areAllElementsNull(this.secondOfPair)) {
                    this.secondOfPair.clear();
                }
            } else {
                this.squeezeList(this.firstOfPairOrFragment);
                this.squeezeList(this.secondOfPair);
            }
            if (this.numHits() == 0) {
                return;
            }
            if (this.numHits() == 1) {
                if (this.getFirstOfPair(0) != null) {
                    this.getFirstOfPair(0).setAttribute(SAMTag.HI.name(), null);
                }
                if (this.getSecondOfPair(0) != null) {
                    this.getSecondOfPair(0).setAttribute(SAMTag.HI.name(), null);
                }
            } else {
                for (n = 0; n < this.numHits(); ++n) {
                    if (this.getFirstOfPair(n) != null) {
                        this.getFirstOfPair(n).setAttribute(SAMTag.HI.name(), (Object)n);
                    }
                    if (this.getSecondOfPair(n) == null) continue;
                    this.getSecondOfPair(n).setAttribute(SAMTag.HI.name(), (Object)n);
                }
            }
            n = this.findPrimaryAlignment(this.firstOfPairOrFragment);
            int n2 = this.findPrimaryAlignment(this.secondOfPair);
            if (n != -1 ? (n2 == -1 ? this.getSecondOfPair(n) != null : n != n2) : n2 != -1 && this.getFirstOfPair(n2) != null) {
                throw new IllegalStateException("Mismatched primary alignments for read " + this.getReadName());
            }
            if (n == -1 && n2 == -1) {
                primaryAlignmentSelectionStrategy.pickPrimaryAlignment(this);
            }
        }

        private void filterReads(SamRecordFilter samRecordFilter, List<SAMRecord> list) {
            for (int i = 0; i < list.size(); ++i) {
                if (!samRecordFilter.filterOut(list.get(i))) continue;
                list.set(i, null);
            }
        }

        private void squeezeList(List<SAMRecord> list) {
            for (int i = list.size() - 1; i >= 0; --i) {
                if (list.get(i) != null) continue;
                list.remove(i);
            }
        }

        private boolean areAllElementsNull(List<SAMRecord> list) {
            for (SAMRecord sAMRecord : list) {
                if (sAMRecord == null) continue;
                return false;
            }
            return true;
        }

        private NumPrimaryAlignmentState tallyPrimaryAlignments(List<SAMRecord> list) {
            boolean bl = false;
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) == null || list.get(i).getNotPrimaryAlignmentFlag()) continue;
                if (bl) {
                    return NumPrimaryAlignmentState.MORE_THAN_ONE;
                }
                bl = true;
            }
            if (bl) {
                return NumPrimaryAlignmentState.ONE;
            }
            return NumPrimaryAlignmentState.NONE;
        }

        private int findPrimaryAlignment(List<SAMRecord> list) {
            int n = -1;
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) == null || list.get(i).getNotPrimaryAlignmentFlag()) continue;
                if (n != -1) {
                    throw new IllegalStateException("Multiple primary alignments found for read " + this.getReadName());
                }
                n = i;
            }
            return n;
        }
    }
}

