/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser.readers;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.readers.BinaryFileIterator;
import net.sf.picard.illumina.parser.readers.MMapBackedIteratorFactory;
import net.sf.picard.util.UnsignedTypeUtil;

public class TileMetricsOutReader
implements Iterator<IlluminaTileMetrics> {
    private static final int HEADER_SIZE = 2;
    private static final int EXPECTED_RECORD_SIZE = 10;
    private static final int EXPECTED_VERSION = 2;
    private final BinaryFileIterator<ByteBuffer> bbIterator;

    public TileMetricsOutReader(File file) {
        this.bbIterator = MMapBackedIteratorFactory.getByteBufferIterator(2, 10, file);
        ByteBuffer byteBuffer = this.bbIterator.getHeaderBytes();
        int n = UnsignedTypeUtil.uByteToInt(byteBuffer.get());
        if (n != 2) {
            throw new PicardException("TileMetricsOutReader expects the version number to be 2.  Actual Version in Header( " + n + ")");
        }
        int n2 = UnsignedTypeUtil.uByteToInt(byteBuffer.get());
        if (10 != n2) {
            throw new PicardException("TileMetricsOutReader expects the record size to be 10.  Actual Record Size in Header( " + n2 + ")");
        }
    }

    @Override
    public boolean hasNext() {
        return this.bbIterator.hasNext();
    }

    @Override
    public IlluminaTileMetrics next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return new IlluminaTileMetrics(this.bbIterator.next());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public class IlluminaTileMetrics {
        private final int laneNumber;
        private final int tileNumber;
        private final int metricCode;
        private final float metricValue;

        public IlluminaTileMetrics(ByteBuffer byteBuffer) {
            this.laneNumber = UnsignedTypeUtil.uShortToInt(byteBuffer.getShort());
            this.tileNumber = UnsignedTypeUtil.uShortToInt(byteBuffer.getShort());
            this.metricCode = UnsignedTypeUtil.uShortToInt(byteBuffer.getShort());
            this.metricValue = byteBuffer.getFloat();
        }

        public int getLaneNumber() {
            return this.laneNumber;
        }

        public int getTileNumber() {
            return this.tileNumber;
        }

        public int getMetricCode() {
            return this.metricCode;
        }

        public float getMetricValue() {
            return this.metricValue;
        }
    }
}

