/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.vcf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.genotype.Allele;
import org.molgenis.genotype.Alleles;
import org.molgenis.genotype.GenotypeDataException;
import org.molgenis.genotype.variant.GenotypeRecord;
import org.molgenis.vcf.VcfRecord;
import org.molgenis.vcf.VcfSample;
import org.molgenis.vcf.meta.VcfMeta;
import org.molgenis.vcf.meta.VcfMetaFormat;

public class VcfGenotypeRecord
implements GenotypeRecord {
    private final VcfMeta vcfMeta;
    private final VcfRecord vcfRecord;
    private final VcfSample vcfSample;

    public VcfGenotypeRecord(VcfMeta vcfMeta, VcfRecord vcfRecord, VcfSample vcfSample) {
        if (vcfMeta == null) {
            throw new IllegalArgumentException("vcfMeta is null");
        }
        if (vcfRecord == null) {
            throw new IllegalArgumentException("vcfRecord is null");
        }
        if (vcfSample == null) {
            throw new IllegalArgumentException("vcfSample is null");
        }
        this.vcfMeta = vcfMeta;
        this.vcfRecord = vcfRecord.createClone();
        this.vcfSample = vcfSample.createClone();
    }

    @Override
    public Object getGenotypeRecordData(String recordId) {
        List<String> value;
        int idx = this.vcfRecord.getFormatIndex(recordId);
        if (idx == -1) {
            throw new GenotypeDataException("unknown record id [" + recordId + "]");
        }
        String data = this.vcfSample.getData(idx);
        VcfMetaFormat format = this.vcfMeta.getFormatMeta(recordId);
        if (format == null) {
            throw new GenotypeDataException("missing vcf format data for record id [" + recordId + "]");
        }
        switch (format.getType()) {
            case CHARACTER: {
                return Character.valueOf(data.charAt(0));
            }
            case FLOAT: {
                if (this.isListValue(format.getNumber())) {
                    String[] tokens = StringUtils.split((String)data, (char)',');
                    ArrayList<String> doubles = new ArrayList<String>(tokens.length);
                    for (String token : tokens) {
                        doubles.add((String)((Object)Double.valueOf(token)));
                    }
                    value = doubles;
                    break;
                }
                value = Double.valueOf(data);
                break;
            }
            case INTEGER: {
                if (this.isListValue(format.getNumber())) {
                    String[] tokens = StringUtils.split((String)data, (char)',');
                    ArrayList<String> integers = new ArrayList<String>(tokens.length);
                    for (String token : tokens) {
                        integers.add((String)((Object)Integer.valueOf(token)));
                    }
                    value = integers;
                    break;
                }
                value = Integer.valueOf(data);
                break;
            }
            case STRING: {
                if (this.isListValue(format.getNumber())) {
                    value = Arrays.asList(StringUtils.split((String)data, (char)','));
                    break;
                }
                value = data;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid vcf format type [" + (Object)((Object)format.getType()) + "]");
            }
        }
        return value;
    }

    @Override
    public Alleles getSampleAlleles() {
        List<Allele> alleles = this.vcfSample.getAlleles();
        if (this.vcfSample.getAlleles() != null) {
            return Alleles.createAlleles(alleles);
        }
        return null;
    }

    private boolean isListValue(String number) {
        return number.equals("A") || number.equals("R") || number.equals("G") || number.equals(".") || Integer.valueOf(number) > 1;
    }

    @Override
    public float[] getSampleProbs() {
        List probs = (List)this.getGenotypeRecordData("GP");
        if (probs != null) {
            float[] probsArray = new float[probs.size()];
            for (int i = 0; i < probs.size(); ++i) {
                probsArray[i] = ((Double)probs.get(i)).floatValue();
            }
            return probsArray;
        }
        return null;
    }

    @Override
    public float getSampleDosage() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean containsGenotypeRecord(String recordId) {
        return this.vcfRecord.getFormatIndex(recordId) != -1;
    }
}

