/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMTagUtil;
import net.sf.samtools.SQTagUtil;
import net.sf.samtools.util.SequenceUtil;
import net.sf.samtools.util.StringUtil;

public class SAMRecordUtil {
    private static final short[] STRING_TAGS_TO_REVERSE = new short[]{SAMTagUtil.getSingleton().U2, SAMTagUtil.getSingleton().OQ};

    public static void reverseComplement(SAMRecord sAMRecord) {
        String string;
        byte[] byArray = sAMRecord.getReadBases();
        SequenceUtil.reverseComplement(byArray);
        sAMRecord.setReadBases(byArray);
        byte[] byArray2 = sAMRecord.getBaseQualities();
        SAMRecordUtil.reverseArray(byArray2);
        sAMRecord.setBaseQualities(byArray2);
        byte[] byArray3 = (byte[])sAMRecord.getAttribute(SAMTagUtil.getSingleton().SQ);
        if (byArray3 != null) {
            SQTagUtil.reverseComplementSqArray(byArray3);
            sAMRecord.setAttribute(SAMTagUtil.getSingleton().SQ, (Object)byArray3);
        }
        if ((string = (String)sAMRecord.getAttribute(SAMTagUtil.getSingleton().E2)) != null) {
            byte[] objectArray = StringUtil.stringToBytes(string);
            SequenceUtil.reverseComplement(objectArray);
            sAMRecord.setAttribute(SAMTagUtil.getSingleton().E2, (Object)StringUtil.bytesToString(objectArray));
        }
        for (short s : STRING_TAGS_TO_REVERSE) {
            String string2 = (String)sAMRecord.getAttribute(s);
            if (string2 == null) continue;
            sAMRecord.setAttribute(s, (Object)StringUtil.reverseString(string2));
        }
    }

    public static void reverseArray(byte[] byArray) {
        int n = byArray.length - 1;
        int n2 = 0;
        for (int i = n; n2 < i; ++n2, --i) {
            byte by = byArray[n2];
            byArray[n2] = byArray[i];
            byArray[i] = by;
        }
    }
}

