/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser.readers;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.readers.BclQualityEvaluationStrategy;
import net.sf.picard.util.UnsignedTypeUtil;
import net.sf.samtools.util.CloserUtil;

public class BclReader
implements Iterator<BclValue> {
    private static final int HEADER_SIZE = 4;
    private final BclQualityEvaluationStrategy bclQualityEvaluationStrategy;
    public final long numClusters;
    private final InputStream inputStream;
    private final String filePath;
    private static final byte BASE_MASK = 3;
    private static final byte A_VAL = 0;
    private static final byte C_VAL = 1;
    private static final byte G_VAL = 2;
    private static final byte T_VAL = 3;
    private long nextCluster;

    public BclReader(File file, BclQualityEvaluationStrategy bclQualityEvaluationStrategy) {
        this.bclQualityEvaluationStrategy = bclQualityEvaluationStrategy;
        this.filePath = file.getAbsolutePath();
        boolean bl = this.filePath.endsWith(".gz");
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            this.inputStream = bl ? new GZIPInputStream(bufferedInputStream) : bufferedInputStream;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PicardException("File not found: (" + this.filePath + ")", fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new PicardException("Error reading file: (" + this.filePath + ")", iOException);
        }
        this.numClusters = this.getNumClusters();
        if (file.length() == 0L) {
            throw new PicardException("Zero length BCL file detected: " + this.filePath);
        }
        if (!bl) {
            this.assertProperFileStructure(file);
        }
        this.nextCluster = 0L;
    }

    private long getNumClusters() {
        byte[] byArray = new byte[4];
        try {
            int n = this.inputStream.read(byArray);
            if (n != 4) {
                throw new PicardException("Malformed file, expected header of size 4 but received " + n);
            }
        }
        catch (IOException iOException) {
            throw new PicardException("Unable to read header for file (" + this.filePath + ")", iOException);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return UnsignedTypeUtil.uIntToLong(byteBuffer.getInt());
    }

    private void assertProperFileStructure(File file) {
        long l = file.length() - 4L;
        if (this.numClusters != l) {
            throw new PicardException("Expected " + this.numClusters + " in file but found " + l);
        }
    }

    @Override
    public boolean hasNext() {
        return this.nextCluster < this.numClusters;
    }

    @Override
    public BclValue next() {
        byte by;
        byte by2;
        byte[] byArray = new byte[1];
        try {
            if (this.inputStream.read(byArray) != 1) {
                throw new PicardException("Error when reading byte from file (" + this.filePath + ")");
            }
        }
        catch (EOFException eOFException) {
            throw new PicardException("Attempted to read byte from file but none were available: (" + this.filePath + ")", eOFException);
        }
        catch (IOException iOException) {
            throw new PicardException("Error when reading byte from file (" + this.filePath + ")", iOException);
        }
        byte by3 = byArray[0];
        if (by3 == 0) {
            by2 = 46;
            by = 2;
        } else {
            switch (by3 & 3) {
                case 0: {
                    by2 = 65;
                    break;
                }
                case 1: {
                    by2 = 67;
                    break;
                }
                case 2: {
                    by2 = 71;
                    break;
                }
                case 3: {
                    by2 = 84;
                    break;
                }
                default: {
                    throw new PicardException("Impossible case! BCL Base value neither A, C, G, nor T! Value(" + (by3 & 3) + ") + in file(" + this.filePath + ")");
                }
            }
            by = this.bclQualityEvaluationStrategy.reviseAndConditionallyLogQuality((byte)(UnsignedTypeUtil.uByteToInt(by3) >>> 2));
        }
        ++this.nextCluster;
        return new BclValue(by2, by);
    }

    public void close() {
        CloserUtil.close(this.inputStream);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public class BclValue {
        public final byte base;
        public final byte quality;

        public BclValue(byte by, byte by2) {
            this.base = by;
            this.quality = by2;
        }
    }
}

