/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.readers.TileMetricsOutReader;
import net.sf.samtools.util.CollectionUtil;

public class TileMetricsUtil {
    private static final Integer DENSITY_ID_CODE = 100;
    private static final Integer CLUSTER_ID_CODE = 102;
    public static String INTEROP_SUBDIRECTORY_NAME = "InterOp";
    public static String TILE_METRICS_OUT_FILE_NAME = "TileMetricsOut.bin";

    public static File renderTileMetricsFileFromBasecallingDirectory(File file) {
        return new File(new File(file, INTEROP_SUBDIRECTORY_NAME), TILE_METRICS_OUT_FILE_NAME);
    }

    public static Collection<Tile> parseTileMetrics(File file) throws FileNotFoundException {
        HashSet<TileMetricsOutReader.IlluminaTileMetrics> hashSet = new HashSet<TileMetricsOutReader.IlluminaTileMetrics>(CollectionUtil.makeCollection(new TileMetricsOutReader(file)));
        Map<String, Collection<TileMetricsOutReader.IlluminaTileMetrics>> map = CollectionUtil.partition(hashSet, new CollectionUtil.Partitioner<TileMetricsOutReader.IlluminaTileMetrics, String>(){

            @Override
            public String getPartition(TileMetricsOutReader.IlluminaTileMetrics illuminaTileMetrics) {
                return TileMetricsUtil.renderMetricLocationKey(illuminaTileMetrics);
            }
        });
        LinkedList<Tile> linkedList = new LinkedList<Tile>();
        for (Map.Entry<String, Collection<TileMetricsOutReader.IlluminaTileMetrics>> entry : map.entrySet()) {
            Collection<TileMetricsOutReader.IlluminaTileMetrics> collection = entry.getValue();
            Map<Integer, Collection<TileMetricsOutReader.IlluminaTileMetrics>> map2 = CollectionUtil.partition(collection, new CollectionUtil.Partitioner<TileMetricsOutReader.IlluminaTileMetrics, Integer>(){

                @Override
                public Integer getPartition(TileMetricsOutReader.IlluminaTileMetrics illuminaTileMetrics) {
                    return illuminaTileMetrics.getMetricCode();
                }
            });
            Set<Integer> set = map2.keySet();
            if (!set.contains(DENSITY_ID_CODE) || !set.contains(CLUSTER_ID_CODE)) {
                throw new PicardException(String.format("Expected to find cluster and density record codes (%s and %s) in records read for tile location %s (lane:tile), but found only %s.", CLUSTER_ID_CODE, DENSITY_ID_CODE, entry.getKey(), set));
            }
            TileMetricsOutReader.IlluminaTileMetrics illuminaTileMetrics = CollectionUtil.getSoleElement(map2.get(DENSITY_ID_CODE));
            TileMetricsOutReader.IlluminaTileMetrics illuminaTileMetrics2 = CollectionUtil.getSoleElement(map2.get(CLUSTER_ID_CODE));
            linkedList.add(new Tile(illuminaTileMetrics.getLaneNumber(), illuminaTileMetrics.getTileNumber(), illuminaTileMetrics.getMetricValue(), illuminaTileMetrics2.getMetricValue()));
        }
        return Collections.unmodifiableCollection(linkedList);
    }

    private static String renderMetricLocationKey(TileMetricsOutReader.IlluminaTileMetrics illuminaTileMetrics) {
        return String.format("%s:%s", illuminaTileMetrics.getLaneNumber(), illuminaTileMetrics.getTileNumber());
    }

    public static class Tile {
        private final int lane;
        private final int tile;
        private final float density;
        private final float clusters;

        protected Tile(int n, int n2, float f, float f2) {
            this.lane = n;
            this.tile = n2;
            this.density = f;
            this.clusters = f2;
        }

        public int getLaneNumber() {
            return this.lane;
        }

        public int getTileNumber() {
            return this.tile;
        }

        public float getClusterDensity() {
            return this.density;
        }

        public float getClusterCount() {
            return this.clusters;
        }
    }
}

