/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;
import org.molgenis.genotype.Allele;
import org.molgenis.genotype.Alleles;
import org.molgenis.genotype.GenotypeDataException;
import org.molgenis.genotype.RandomAccessGenotypeData;
import org.molgenis.genotype.RandomAccessGenotypeDataReaderFormats;
import org.molgenis.genotype.multipart.IncompatibleMultiPartGenotypeDataException;
import org.molgenis.genotype.sampleFilter.SampleIdIncludeFilter;
import org.molgenis.genotype.tabix.TabixFileNotFoundException;
import org.molgenis.genotype.util.GenotypeCountCalculator;
import org.molgenis.genotype.variant.GeneticVariant;
import org.molgenis.genotype.variantFilter.VariantFilter;
import org.molgenis.genotype.variantFilter.VariantFilterSeqPos;

public class GenotypeInfo {
    private static final Logger LOGGER;
    private static final Options OPTIONS;
    private static final Pattern CHR_POS_SPLITTER;
    public static final NumberFormat DEFAULT_NUMBER_FORMATTER;

    public static void main(String[] args) throws IOException {
        try {
            RandomAccessGenotypeData inputData;
            SampleIdIncludeFilter sampleFilter;
            VariantFilterSeqPos varFilter;
            double minimumPosteriorProbability;
            RandomAccessGenotypeDataReaderFormats inputType;
            String[] inputBasePaths;
            CommandLine commandLine;
            block40: {
                PosixParser parser = new PosixParser();
                commandLine = parser.parse(OPTIONS, args, true);
                inputBasePaths = commandLine.getOptionValues('i');
                try {
                    if (commandLine.hasOption('I')) {
                        inputType = RandomAccessGenotypeDataReaderFormats.valueOf(commandLine.getOptionValue('I').toUpperCase());
                        break block40;
                    }
                    if (inputBasePaths[0].endsWith(".vcf")) {
                        throw new ParseException("Only vcf.gz is supported. Please see manual on how to do create a vcf.gz file.");
                    }
                    try {
                        inputType = RandomAccessGenotypeDataReaderFormats.matchFormatToPath(inputBasePaths[0]);
                    }
                    catch (GenotypeDataException e) {
                        throw new ParseException("Unable to determine input type based on specified path. Please specify --inputType");
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new ParseException("Error parsing --inputType \"" + commandLine.getOptionValue('I') + "\" is not a valid input data format");
                }
            }
            String outputBasePath = commandLine.getOptionValue('o');
            File sampleFilterListFile = commandLine.hasOption("sf") ? new File(commandLine.getOptionValue("sf")) : null;
            File variantPosFilterListFile = commandLine.hasOption("pf") ? new File(commandLine.getOptionValue("pf")) : null;
            try {
                minimumPosteriorProbability = commandLine.hasOption("ip") ? Double.parseDouble(commandLine.getOptionValue("ip")) : 0.8;
            }
            catch (NumberFormatException e) {
                throw new ParseException("Error parsing --inputProb \"" + commandLine.getOptionValue("ip") + "\" is not an double");
            }
            StringBuilder inputPaths = new StringBuilder();
            for (String path : inputBasePaths) {
                inputPaths.append(path);
                inputPaths.append(' ');
            }
            String forceSeqName = commandLine.hasOption('f') ? commandLine.getOptionValue('f') : null;
            LOGGER.info((Object)("Input base path: " + inputPaths));
            LOGGER.info((Object)("Input data type: " + inputType.getName()));
            LOGGER.info((Object)("Output base path: " + outputBasePath));
            LOGGER.info((Object)("Force input sequence name: " + (forceSeqName == null ? "not forcing" : "forcing to: " + forceSeqName)));
            if (sampleFilterListFile != null) {
                LOGGER.info((Object)("Filter input data to samples present in: " + sampleFilterListFile));
            }
            if (variantPosFilterListFile != null) {
                LOGGER.info((Object)("Filter input data to variants present in: " + variantPosFilterListFile));
            }
            LOGGER.info((Object)("Minimum posterior probability for input data: " + minimumPosteriorProbability));
            if (variantPosFilterListFile != null) {
                varFilter = new VariantFilterSeqPos();
                int includeCountVar = 0;
                try {
                    String line;
                    BufferedReader variantChrPosFilterReader = new BufferedReader(new FileReader(variantPosFilterListFile));
                    while ((line = variantChrPosFilterReader.readLine()) != null) {
                        String[] elements = CHR_POS_SPLITTER.split(line);
                        if (elements.length != 2) {
                            LOGGER.error((Object)("Error parsing chr pos for line: " + line + " skipping line"));
                            continue;
                        }
                        ++includeCountVar;
                        varFilter.addSeqPos(elements[0], Integer.parseInt(elements[1]));
                    }
                    LOGGER.info((Object)("Included " + DEFAULT_NUMBER_FORMATTER.format(includeCountVar) + " variants from file with chr and pos"));
                }
                catch (FileNotFoundException ex) {
                    LOGGER.fatal((Object)("Unable to find file with variants to filter on at: " + variantPosFilterListFile.getAbsolutePath()));
                    System.exit(1);
                }
                catch (IOException e) {
                    LOGGER.fatal((Object)("Error reading file with variants to filter on at: " + variantPosFilterListFile), (Throwable)e);
                    System.exit(1);
                }
            } else {
                varFilter = null;
            }
            if (sampleFilterListFile != null) {
                HashSet<String> samples = new HashSet<String>();
                try {
                    String line;
                    BufferedReader sampleIdFilterReader = new BufferedReader(new FileReader(sampleFilterListFile));
                    while ((line = sampleIdFilterReader.readLine()) != null) {
                        samples.add(line);
                    }
                }
                catch (FileNotFoundException ex) {
                    LOGGER.fatal((Object)("Unable to find file with samples to filter on at: " + sampleFilterListFile.getAbsolutePath()));
                    System.exit(1);
                }
                catch (IOException e) {
                    LOGGER.fatal((Object)("Error reading file with samples to filter on at: " + sampleFilterListFile.getAbsolutePath()), (Throwable)e);
                    System.exit(1);
                }
                sampleFilter = new SampleIdIncludeFilter(samples);
            } else {
                sampleFilter = null;
            }
            try {
                inputData = inputType.createFilteredGenotypeData(inputBasePaths, 0, (VariantFilter)varFilter, sampleFilter, forceSeqName, minimumPosteriorProbability);
            }
            catch (TabixFileNotFoundException e) {
                LOGGER.fatal((Object)("Tabix file not found for input data at: " + e.getPath() + "\nPlease see README on how to create a tabix file"));
                System.exit(1);
                return;
            }
            catch (IOException e) {
                LOGGER.fatal((Object)("Error reading input data: " + e.getMessage()), (Throwable)e);
                System.exit(1);
                return;
            }
            catch (IncompatibleMultiPartGenotypeDataException e) {
                LOGGER.fatal((Object)("Error combining the impute genotype data files: " + e.getMessage()), (Throwable)e);
                System.exit(1);
                return;
            }
            catch (GenotypeDataException e) {
                LOGGER.fatal((Object)("Error reading input data: " + e.getMessage()), (Throwable)e);
                System.exit(1);
                return;
            }
            LOGGER.info((Object)"Data loaded");
            int[] sampleHetCounts = new int[inputData.getSamples().size()];
            int[] sampleCallCounts = new int[inputData.getSamples().size()];
            double sumVariantCallRate = 0.0;
            File variantInfoFile = new File(outputBasePath + ".vars");
            if (variantInfoFile.getParentFile() != null) {
                variantInfoFile.getParentFile().mkdirs();
            }
            BufferedWriter variantInfoWriter = new BufferedWriter(new FileWriter(variantInfoFile));
            variantInfoWriter.append("ID\tCHR\tPOS\tAlleles\tMA\tMAF\tCALL\tHWE\tMACH_R2\tGenotype_Counts\n");
            int variantCount = 0;
            for (GeneticVariant variant : inputData) {
                variantInfoWriter.append(variant.getPrimaryVariantId());
                variantInfoWriter.append('\t');
                variantInfoWriter.append(variant.getSequenceName());
                variantInfoWriter.append('\t');
                variantInfoWriter.append(String.valueOf(variant.getStartPos()));
                variantInfoWriter.append('\t');
                boolean notFirst = false;
                for (Allele a : variant.getVariantAlleles()) {
                    if (notFirst) {
                        variantInfoWriter.append('/');
                    }
                    variantInfoWriter.append(a.getAlleleAsString());
                    notFirst = true;
                }
                variantInfoWriter.append('\t');
                variantInfoWriter.append(String.valueOf(variant.getMinorAllele()));
                variantInfoWriter.append('\t');
                variantInfoWriter.append(String.valueOf(variant.getMinorAlleleFrequency()));
                variantInfoWriter.append('\t');
                double callrate = variant.getCallRate();
                sumVariantCallRate += callrate;
                variantInfoWriter.append(String.valueOf(callrate));
                variantInfoWriter.append('\t');
                variantInfoWriter.append(String.valueOf(variant.getHwePvalue()));
                variantInfoWriter.append('\t');
                variantInfoWriter.append(String.valueOf(variant.getMachR2()));
                variantInfoWriter.append('\t');
                ArrayList<GenotypeCountCalculator.GenotypeCount> genotypeCounts = GenotypeCountCalculator.countGenotypes(variant);
                Iterator iterator = genotypeCounts.iterator();
                while (iterator.hasNext()) {
                    GenotypeCountCalculator.GenotypeCount genotypeCount = (GenotypeCountCalculator.GenotypeCount)iterator.next();
                    variantInfoWriter.append(genotypeCount.getGenotype().toString());
                    variantInfoWriter.append(": ");
                    variantInfoWriter.append(String.valueOf(genotypeCount.getCount()));
                    variantInfoWriter.append(", ");
                }
                variantInfoWriter.append('\n');
                List<Alleles> sampleAlleles = variant.getSampleVariants();
                float[][] probs = variant.getSampleGenotypeProbilities();
                for (int j = 0; j < sampleAlleles.size(); ++j) {
                    Alleles sampleAllele = sampleAlleles.get(j);
                    if (sampleAllele.getAlleleCount() == 0 || sampleAllele.contains(Allele.ZERO)) continue;
                    int n = j;
                    sampleCallCounts[n] = sampleCallCounts[n] + 1;
                    if (sampleAllele.getAlleleCount() <= 1) continue;
                    Allele a1 = sampleAllele.getAlleles().get(0);
                    for (Allele a2 : sampleAllele.getAlleles()) {
                        if (a1 == a2) continue;
                        int n2 = j;
                        sampleHetCounts[n2] = sampleHetCounts[n2] + 1;
                    }
                }
                if (++variantCount % 100000 != 0) continue;
                System.out.println("Processed " + DEFAULT_NUMBER_FORMATTER.format(variantCount) + " variants");
            }
            variantInfoWriter.close();
            File sampleInfoFile = new File(outputBasePath + ".samples");
            if (sampleInfoFile.getParentFile() != null) {
                sampleInfoFile.getParentFile().mkdirs();
            }
            double sumSampleCallRate = 0.0;
            BufferedWriter sampleInfoWriter = new BufferedWriter(new FileWriter(sampleInfoFile));
            sampleInfoWriter.append("ID\tCallRate\tHetRate\n");
            int j = 0;
            for (String sample : inputData.getSampleNames()) {
                sampleInfoWriter.append(sample);
                sampleInfoWriter.append('\t');
                double sampleCallRate = (double)sampleCallCounts[j] / (double)variantCount;
                sumSampleCallRate += sampleCallRate;
                sampleInfoWriter.append(String.valueOf(sampleCallRate));
                sampleInfoWriter.append('\t');
                double sampleHetRate = (double)sampleHetCounts[j] / (double)variantCount;
                sampleInfoWriter.append(String.valueOf(sampleHetRate));
                sampleInfoWriter.append('\n');
                ++j;
            }
            sampleInfoWriter.close();
            double averageVariantCallRate = sumVariantCallRate / (double)variantCount;
            double averageSampleCallRate = sumSampleCallRate / (double)inputData.getSamples().size();
            System.out.println("Samples: " + inputData.getSampleNames().length);
            System.out.println("Variants: " + variantCount);
            System.out.println("Average variant call rate: " + averageVariantCallRate);
            System.out.println("Average sample call rate: " + averageSampleCallRate);
            LOGGER.info((Object)"Done writing genotype info");
        }
        catch (ParseException ex) {
            LOGGER.fatal((Object)"Invalid command line arguments: ");
            LOGGER.fatal((Object)ex.getMessage());
            System.err.println();
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(" ", OPTIONS);
        }
    }

    static {
        CHR_POS_SPLITTER = Pattern.compile("\\s+|:");
        DEFAULT_NUMBER_FORMATTER = NumberFormat.getInstance();
        LOGGER = Logger.getLogger(GenotypeInfo.class);
        OPTIONS = new Options();
        OptionBuilder.withArgName((String)"basePath");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"The base path of the data to align. The extensions are determined based on the input data type.");
        OptionBuilder.withLongOpt((String)"input");
        OptionBuilder.isRequired();
        Option option = OptionBuilder.create((String)"i");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName((String)"type");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"The input data type. If not defined will attempt to automatically select the first matching dataset on the specified path\n* PED_MAP - plink PED MAP files.\n* PLINK_BED - plink BED BIM FAM files.\n* VCF - bgziped vcf with tabix index file\n* VCFFOLDER - matches all bgziped vcf files + tabix index in a folder\n* SHAPEIT2 - shapeit2 phased haplotypes .haps & .sample\n* GEN - Oxford .gen & .sample\n* TRITYPER - TriTyper format folder");
        OptionBuilder.withLongOpt((String)"inputType");
        option = OptionBuilder.create((String)"I");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName((String)"basePath");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"The output bash path");
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.isRequired();
        option = OptionBuilder.create((String)"o");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Path to file with samples IDs to include from input data. For plink data only the sample id (column 2) is used");
        OptionBuilder.withLongOpt((String)"sampleFilterList");
        option = OptionBuilder.create((String)"sf");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Path to file with variant CHR\tPOS or CHR:POS to include from input data.");
        OptionBuilder.withLongOpt((String)"variantPosFilterList");
        option = OptionBuilder.create((String)"pf");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Shapeit2 does not output the sequence name in the first column of the haplotype file. Use this option to force the chromosome for all variants. This option is only valid in combination with --inputType SHAPEIT2");
        OptionBuilder.withLongOpt((String)"forceChr");
        option = OptionBuilder.create((String)"f");
        OPTIONS.addOption(option);
        OptionBuilder.withArgName((String)"double");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"The minimum posterior probability to call genotypes in the input data 0.8");
        OptionBuilder.withLongOpt((String)"inputProb");
        option = OptionBuilder.create((String)"ip");
        OPTIONS.addOption(option);
    }
}

