/*
 * Decompiled with CFR 0.152.
 */
package JSci.physics.particles;

import JSci.physics.particles.AntiTauNeutrino;
import JSci.physics.particles.Lepton;
import JSci.physics.particles.Tau;
import JSci.physics.particles.WMinus;
import JSci.physics.particles.WPlus;
import JSci.physics.particles.ZZero;
import JSci.physics.quantum.QuantumParticle;

public final class TauNeutrino
extends Lepton {
    public double restMass() {
        return 0.0;
    }

    public int charge() {
        return 0;
    }

    public int eLeptonQN() {
        return 0;
    }

    public int muLeptonQN() {
        return 0;
    }

    public int tauLeptonQN() {
        return 1;
    }

    public QuantumParticle anti() {
        return new AntiTauNeutrino();
    }

    public boolean isAnti(QuantumParticle quantumParticle) {
        return quantumParticle != null && quantumParticle instanceof AntiTauNeutrino;
    }

    public String toString() {
        return new String("Tau neutrino");
    }

    public Tau emit(WPlus wPlus) {
        Tau tau = new Tau();
        tau.momentum = this.momentum.subtract(wPlus.momentum);
        return tau;
    }

    public Tau absorb(WMinus wMinus) {
        Tau tau = new Tau();
        tau.momentum = this.momentum.add(wMinus.momentum);
        return tau;
    }

    public TauNeutrino emit(ZZero zZero) {
        this.momentum = this.momentum.subtract(zZero.momentum);
        return this;
    }

    public TauNeutrino absorb(ZZero zZero) {
        this.momentum = this.momentum.add(zZero.momentum);
        return this;
    }
}

