/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet;

import JSci.maths.AbstractMath;
import JSci.maths.EngineerMath;
import JSci.maths.wavelet.FWTCoef;

public final class FWTCoefMath
extends AbstractMath {
    private FWTCoefMath() {
    }

    public static boolean areCompatible(FWTCoef fWTCoef, FWTCoef fWTCoef2) {
        if (fWTCoef.getJ() != fWTCoef2.getJ()) {
            return false;
        }
        for (int i = 0; i < fWTCoef.getJ(); ++i) {
            if (fWTCoef.dimension(i) == fWTCoef2.dimension(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean areCompatible(FWTCoef[] fWTCoefArray) {
        if (fWTCoefArray.length == 1) {
            return true;
        }
        for (int i = 0; i < fWTCoefArray.length - 1; ++i) {
            if (FWTCoefMath.areCompatible(fWTCoefArray[i], fWTCoefArray[i + 1])) continue;
            return false;
        }
        return true;
    }

    public static int getJ(FWTCoef[] fWTCoefArray) {
        if (!FWTCoefMath.areCompatible(fWTCoefArray)) {
            throw new IllegalArgumentException("The objects are not compatible.");
        }
        return fWTCoefArray[0].getJ();
    }

    public static double sumSquares(FWTCoef[] fWTCoefArray, int n) {
        if (!FWTCoefMath.areCompatible(fWTCoefArray)) {
            throw new IllegalArgumentException("The objects are not compatible.");
        }
        if (n < 0 || n >= FWTCoefMath.getJ(fWTCoefArray)) {
            throw new IllegalArgumentException("The integer parameter " + n + " should be between 0 and " + (FWTCoefMath.getJ(fWTCoefArray) - 1));
        }
        double d = 0.0;
        for (int i = 0; i < fWTCoefArray.length; ++i) {
            d += fWTCoefArray[i].sumSquares(n);
        }
        return d;
    }

    public static double variance(FWTCoef[] fWTCoefArray, int n) {
        if (!FWTCoefMath.areCompatible(fWTCoefArray)) {
            throw new IllegalArgumentException("The objects are not compatible.");
        }
        if (n < 0 || n >= FWTCoefMath.getJ(fWTCoefArray)) {
            throw new IllegalArgumentException("The integer parameter " + n + " should be between 0 and " + (FWTCoefMath.getJ(fWTCoefArray) - 1));
        }
        double d = 0.0;
        for (int i = 0; i < fWTCoefArray.length; ++i) {
            d += fWTCoefArray[i].variance(n);
        }
        return d;
    }

    public static double sumEnergies(FWTCoef[] fWTCoefArray) {
        if (!FWTCoefMath.areCompatible(fWTCoefArray)) {
            throw new IllegalArgumentException("The Objects of type FWTCoef are not compatible.");
        }
        if (FWTCoefMath.getJ(fWTCoefArray) <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        double d = 0.0;
        for (int i = 0; i < fWTCoefArray.length; ++i) {
            d += fWTCoefArray[i].sumEnergies();
        }
        return d;
    }

    public static double entropy(FWTCoef[] fWTCoefArray, int n) {
        if (!FWTCoefMath.areCompatible(fWTCoefArray)) {
            throw new IllegalArgumentException("The Objects of type FWTCoef are not compatible.");
        }
        if (n < 0 || n >= FWTCoefMath.getJ(fWTCoefArray)) {
            throw new IllegalArgumentException("The integer parameter " + n + " should be between 0 and " + (FWTCoefMath.getJ(fWTCoefArray) - 1));
        }
        double d = FWTCoefMath.sumSquares(fWTCoefArray, n);
        int n2 = fWTCoefArray[0].coefs[n].length;
        double[] dArray = new double[n2];
        int n3 = 0;
        for (int i = 0; i < fWTCoefArray[0].coefs[n].length; ++i) {
            for (int j = 0; j < fWTCoefArray.length; ++j) {
                int n4 = n3;
                dArray[n4] = dArray[n4] + fWTCoefArray[j].coefs[n][i] * fWTCoefArray[j].coefs[n][i] / d;
            }
            ++n3;
        }
        return EngineerMath.icf(dArray);
    }

    public static double entropy(FWTCoef[] fWTCoefArray) {
        if (!FWTCoefMath.areCompatible(fWTCoefArray)) {
            throw new IllegalArgumentException("The Objects of type FWTCoef are not compatible.");
        }
        if (FWTCoefMath.getJ(fWTCoefArray) <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        double d = FWTCoefMath.sumEnergies(fWTCoefArray);
        int n = 0;
        for (int i = 1; i < fWTCoefArray[0].coefs.length; ++i) {
            n += fWTCoefArray[0].coefs[i].length;
        }
        double[] dArray = new double[n];
        int n2 = 0;
        for (int i = 1; i < fWTCoefArray[0].coefs.length; ++i) {
            for (int j = 0; j < fWTCoefArray[0].coefs[i].length; ++j) {
                for (int k = 0; k < fWTCoefArray.length; ++k) {
                    int n3 = n2;
                    dArray[n3] = dArray[n3] + fWTCoefArray[k].coefs[i][j] * fWTCoefArray[k].coefs[i][j] / d;
                }
                ++n2;
            }
        }
        return EngineerMath.icf(dArray);
    }

    public static double sumVariance(FWTCoef[] fWTCoefArray) {
        if (!FWTCoefMath.areCompatible(fWTCoefArray)) {
            throw new IllegalArgumentException("The objects are not compatible");
        }
        if (FWTCoefMath.getJ(fWTCoefArray) <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        double d = 0.0;
        for (int i = 0; i < fWTCoefArray.length; ++i) {
            d += fWTCoefArray[i].sumVariance();
        }
        return d;
    }

    public static double energyRatio(FWTCoef[] fWTCoefArray, int n) {
        if (!FWTCoefMath.areCompatible(fWTCoefArray)) {
            throw new IllegalArgumentException("The Objects of type FWTCoef are not compatible.");
        }
        if (FWTCoefMath.getJ(fWTCoefArray) <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        if (n < 1 || n >= FWTCoefMath.getJ(fWTCoefArray)) {
            throw new IllegalArgumentException("The integer parameter " + n + " should be between 0 and " + (FWTCoefMath.getJ(fWTCoefArray) - 1));
        }
        if (FWTCoefMath.sumEnergies(fWTCoefArray) == 0.0) {
            if (FWTCoefMath.getJ(fWTCoefArray) != 0) {
                return 1 / FWTCoefMath.getJ(fWTCoefArray);
            }
            throw new IllegalArgumentException("No energy!");
        }
        return FWTCoefMath.sumSquares(fWTCoefArray, n) / FWTCoefMath.sumEnergies(fWTCoefArray);
    }

    public static double varianceRatio(FWTCoef[] fWTCoefArray, int n) {
        if (!FWTCoefMath.areCompatible(fWTCoefArray)) {
            throw new IllegalArgumentException("The Objects of type FWTCoef are not compatible.");
        }
        if (FWTCoefMath.getJ(fWTCoefArray) <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        if (n < 1 || n >= FWTCoefMath.getJ(fWTCoefArray)) {
            throw new IllegalArgumentException("The integer parameter " + n + " should be between 0 and " + (FWTCoefMath.getJ(fWTCoefArray) - 1));
        }
        if (FWTCoefMath.sumVariance(fWTCoefArray) == 0.0) {
            if (FWTCoefMath.getJ(fWTCoefArray) != 0) {
                return 1 / FWTCoefMath.getJ(fWTCoefArray);
            }
            throw new IllegalArgumentException("No energy!");
        }
        return FWTCoefMath.variance(fWTCoefArray, n) / FWTCoefMath.sumVariance(fWTCoefArray);
    }

    public static double icf(FWTCoef[] fWTCoefArray) {
        if (!FWTCoefMath.areCompatible(fWTCoefArray)) {
            throw new IllegalArgumentException("The Objects of type FWTCoef are not compatible.");
        }
        if (FWTCoefMath.getJ(fWTCoefArray) <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        double[] dArray = new double[FWTCoefMath.getJ(fWTCoefArray) - 1];
        for (int i = 1; i < FWTCoefMath.getJ(fWTCoefArray); ++i) {
            dArray[i - 1] = FWTCoefMath.energyRatio(fWTCoefArray, i);
        }
        return EngineerMath.icf(dArray);
    }

    public static double icfVariance(FWTCoef[] fWTCoefArray) {
        if (!FWTCoefMath.areCompatible(fWTCoefArray)) {
            throw new IllegalArgumentException("The Objects of type FWTCoef are not compatible.");
        }
        if (FWTCoefMath.getJ(fWTCoefArray) <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        double[] dArray = new double[FWTCoefMath.getJ(fWTCoefArray) - 1];
        for (int i = 1; i < FWTCoefMath.getJ(fWTCoefArray); ++i) {
            dArray[i - 1] = FWTCoefMath.varianceRatio(fWTCoefArray, i);
        }
        return EngineerMath.icf(dArray);
    }
}

