/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IntervalTree<V>
implements Iterable<Node<V>> {
    private Node<V> mRoot;
    private V mSentinel;

    public int size() {
        return this.mRoot == null ? 0 : this.mRoot.getSize();
    }

    public void clear() {
        this.mRoot = null;
    }

    public V put(int n, int n2, V v) {
        if (n > n2) {
            throw new IllegalArgumentException("Start cannot exceed end.");
        }
        V v2 = this.mSentinel;
        if (this.mRoot == null) {
            this.mRoot = new Node<V>(n, n2, v);
        } else {
            Node<V> node = null;
            Node<V> node2 = this.mRoot;
            int n3 = 0;
            while (node2 != null) {
                node = node2;
                n3 = node2.compare(n, n2);
                if (n3 == 0) break;
                node2 = n3 < 0 ? node2.getLeft() : node2.getRight();
            }
            if (n3 == 0) {
                v2 = node.setValue(v);
            } else {
                this.mRoot = n3 < 0 ? node.insertLeft(n, n2, v, this.mRoot) : node.insertRight(n, n2, v, this.mRoot);
            }
        }
        return v2;
    }

    public V remove(int n, int n2) {
        V v = this.mSentinel;
        Node<V> node = this.mRoot;
        while (node != null) {
            int n3 = node.compare(n, n2);
            if (n3 == 0) {
                v = node.getValue();
                this.mRoot = node.remove(this.mRoot);
                break;
            }
            node = n3 < 0 ? node.getLeft() : node.getRight();
        }
        return v;
    }

    public Node<V> find(int n, int n2) {
        int n3;
        Node<V> node = this.mRoot;
        while (node != null && (n3 = node.compare(n, n2)) != 0) {
            node = n3 < 0 ? node.getLeft() : node.getRight();
        }
        return node;
    }

    public Node<V> findByIndex(int n) {
        return Node.findByRank(this.mRoot, n + 1);
    }

    public int getIndex(int n, int n2) {
        return Node.getRank(this.mRoot, n, n2) - 1;
    }

    public Node<V> min() {
        Node<V> node = null;
        for (Node<V> node2 = this.mRoot; node2 != null; node2 = node2.getLeft()) {
            node = node2;
        }
        return node;
    }

    public Node<V> min(int n, int n2) {
        Node<V> node = null;
        Node<V> node2 = this.mRoot;
        int n3 = 0;
        while (node2 != null) {
            node = node2;
            n3 = node2.compare(n, n2);
            if (n3 == 0) break;
            node2 = n3 < 0 ? node2.getLeft() : node2.getRight();
        }
        if (n3 > 0) {
            node = node.getNext();
        }
        return node;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Node<V> minOverlapper(int n, int n2) {
        Node<V> node = null;
        Node<V> node2 = this.mRoot;
        if (node2 == null || node2.getMaxEnd() < n) return node;
        while (true) {
            if (node2.getStart() <= n2 && n <= node2.getEnd()) {
                node = node2;
                if ((node2 = node2.getLeft()) != null && node2.getMaxEnd() >= n) continue;
                return node;
            }
            Node<V> node3 = node2.getLeft();
            if (node3 != null && node3.getMaxEnd() >= n) {
                node2 = node3;
                continue;
            }
            if (node2.getStart() > n2 || (node2 = node2.getRight()) == null || node2.getMaxEnd() < n) return node;
        }
    }

    public Node<V> max() {
        Node<V> node = null;
        for (Node<V> node2 = this.mRoot; node2 != null; node2 = node2.getRight()) {
            node = node2;
        }
        return node;
    }

    public Node<V> max(int n, int n2) {
        Node<V> node = null;
        Node<V> node2 = this.mRoot;
        int n3 = 0;
        while (node2 != null) {
            node = node2;
            n3 = node2.compare(n, n2);
            if (n3 == 0) break;
            node2 = n3 < 0 ? node2.getLeft() : node2.getRight();
        }
        if (n3 < 0) {
            node = node.getPrev();
        }
        return node;
    }

    @Override
    public Iterator<Node<V>> iterator() {
        return new FwdIterator(this.min());
    }

    public Iterator<Node<V>> iterator(int n, int n2) {
        return new FwdIterator(this.min(n, n2));
    }

    public Iterator<Node<V>> overlappers(int n, int n2) {
        return new OverlapIterator(n, n2);
    }

    public Iterator<Node<V>> reverseIterator() {
        return new RevIterator(this.max());
    }

    public Iterator<Node<V>> reverseIterator(int n, int n2) {
        return new RevIterator(this.max(n, n2));
    }

    public V getSentinel() {
        return this.mSentinel;
    }

    public V setSentinel(V v) {
        V v2 = this.mSentinel;
        this.mSentinel = v;
        return v2;
    }

    public void checkMaxEnds() {
        if (this.mRoot != null) {
            this.mRoot.checkMaxEnd();
        }
    }

    public void printTree() {
        if (this.mRoot != null) {
            this.mRoot.printNode();
        }
    }

    void removeNode(Node<V> node) {
        this.mRoot = node.remove(this.mRoot);
    }

    public static class ValuesIterator<V1>
    implements Iterator<V1> {
        private final Iterator<Node<V1>> mItr;

        public ValuesIterator(Iterator<Node<V1>> iterator) {
            this.mItr = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.mItr.hasNext();
        }

        @Override
        public V1 next() {
            return this.mItr.next().getValue();
        }

        @Override
        public void remove() {
            this.mItr.remove();
        }
    }

    public class OverlapIterator
    implements Iterator<Node<V>> {
        private Node<V> mNext;
        private Node<V> mLast;
        private final int mStart;
        private final int mEnd;

        public OverlapIterator(int n, int n2) {
            this.mNext = IntervalTree.this.minOverlapper(n, n2);
            this.mStart = n;
            this.mEnd = n2;
        }

        @Override
        public boolean hasNext() {
            return this.mNext != null;
        }

        @Override
        public Node<V> next() {
            if (this.mNext == null) {
                throw new NoSuchElementException("No next element.");
            }
            if (this.mNext.wasRemoved()) {
                throw new ConcurrentModificationException("Current element was removed.");
            }
            this.mLast = this.mNext;
            this.mNext = Node.getNextOverlapper(this.mNext, this.mStart, this.mEnd);
            return this.mLast;
        }

        @Override
        public void remove() {
            if (this.mLast == null) {
                throw new IllegalStateException("No entry to remove.");
            }
            IntervalTree.this.removeNode(this.mLast);
            this.mLast = null;
        }
    }

    public class RevIterator
    implements Iterator<Node<V>> {
        private Node<V> mNext;
        private Node<V> mLast;

        public RevIterator(Node<V> node) {
            this.mNext = node;
        }

        @Override
        public boolean hasNext() {
            return this.mNext != null;
        }

        @Override
        public Node<V> next() {
            if (this.mNext == null) {
                throw new NoSuchElementException("No next element.");
            }
            if (this.mNext.wasRemoved()) {
                this.mNext = IntervalTree.this.max(this.mNext.getStart(), this.mNext.getEnd());
                if (this.mNext == null) {
                    throw new ConcurrentModificationException("Current element was removed, and there are no more elements.");
                }
            }
            this.mLast = this.mNext;
            this.mNext = this.mNext.getPrev();
            return this.mLast;
        }

        @Override
        public void remove() {
            if (this.mLast == null) {
                throw new IllegalStateException("No entry to remove.");
            }
            IntervalTree.this.removeNode(this.mLast);
            this.mLast = null;
        }
    }

    public class FwdIterator
    implements Iterator<Node<V>> {
        private Node<V> mNext;
        private Node<V> mLast;

        public FwdIterator(Node<V> node) {
            this.mNext = node;
        }

        @Override
        public boolean hasNext() {
            return this.mNext != null;
        }

        @Override
        public Node<V> next() {
            if (this.mNext == null) {
                throw new NoSuchElementException("No next element.");
            }
            if (this.mNext.wasRemoved()) {
                this.mNext = IntervalTree.this.min(this.mNext.getStart(), this.mNext.getEnd());
                if (this.mNext == null) {
                    throw new ConcurrentModificationException("Current element was removed, and there are no more elements.");
                }
            }
            this.mLast = this.mNext;
            this.mNext = this.mNext.getNext();
            return this.mLast;
        }

        @Override
        public void remove() {
            if (this.mLast == null) {
                throw new IllegalStateException("No entry to remove.");
            }
            IntervalTree.this.removeNode(this.mLast);
            this.mLast = null;
        }
    }

    public static class Node<V1> {
        public static final int HAS_LESSER_PART = 1;
        public static final int HAS_OVERLAPPING_PART = 2;
        public static final int HAS_GREATER_PART = 4;
        public static final int IS_ADJACENT_AND_EMPTY = 0;
        public static final int IS_STRICTLY_LESS = 1;
        public static final int IS_SUBSET = 2;
        public static final int IS_LEFT_OVERHANGING_OVERLAPPER = 3;
        public static final int IS_STRICTLY_GREATER = 4;
        public static final int IS_RIGHT_OVERHANGING_OVERLAPPER = 6;
        public static final int IS_SUPERSET = 7;
        private Node<V1> mParent;
        private Node<V1> mLeft;
        private Node<V1> mRight;
        private final int mStart;
        private final int mEnd;
        private V1 mValue;
        private int mSize;
        private int mMaxEnd;
        private boolean mIsBlack;

        Node(int n, int n2, V1 V1) {
            this.mStart = n;
            this.mEnd = n2;
            this.mValue = V1;
            this.mSize = 1;
            this.mMaxEnd = this.mEnd;
            this.mIsBlack = true;
        }

        Node(Node<V1> node, int n, int n2, V1 V1) {
            this.mParent = node;
            this.mStart = n;
            this.mEnd = n2;
            this.mValue = V1;
            this.mMaxEnd = this.mEnd;
            this.mSize = 1;
        }

        public int getStart() {
            return this.mStart;
        }

        public int getEnd() {
            return this.mEnd;
        }

        public int getLength() {
            return this.mEnd - this.mStart;
        }

        public int getRelationship(Node<V1> node) {
            int n = 0;
            if (this.mStart < node.getStart()) {
                n = 1;
            }
            if (this.mEnd > node.getEnd()) {
                n |= 4;
            }
            if (this.mStart < node.getEnd() && node.getStart() < this.mEnd) {
                n |= 2;
            }
            return n;
        }

        public boolean isAdjacent(Node<V1> node) {
            return this.mStart == node.getEnd() || this.mEnd == node.getStart();
        }

        public V1 getValue() {
            return this.mValue;
        }

        public V1 setValue(V1 V1) {
            V1 V12 = this.mValue;
            this.mValue = V1;
            return V12;
        }

        int getSize() {
            return this.mSize;
        }

        int getMaxEnd() {
            return this.mMaxEnd;
        }

        Node<V1> getLeft() {
            return this.mLeft;
        }

        Node<V1> insertLeft(int n, int n2, V1 V1, Node<V1> node) {
            this.mLeft = new Node<V1>(this, n, n2, V1);
            return Node.insertFixup(this.mLeft, node);
        }

        Node<V1> getRight() {
            return this.mRight;
        }

        Node<V1> insertRight(int n, int n2, V1 V1, Node<V1> node) {
            this.mRight = new Node<V1>(this, n, n2, V1);
            return Node.insertFixup(this.mRight, node);
        }

        Node<V1> getNext() {
            Node<V1> node;
            if (this.mRight != null) {
                node = this.mRight;
                while (node.mLeft != null) {
                    node = node.mLeft;
                }
            } else {
                Node<V1> node2 = this;
                node = this.mParent;
                while (node != null && node2 == node.mRight) {
                    node2 = node;
                    node = node.mParent;
                }
            }
            return node;
        }

        Node<V1> getPrev() {
            Node<V1> node;
            if (this.mLeft != null) {
                node = this.mLeft;
                while (node.mRight != null) {
                    node = node.mRight;
                }
            } else {
                Node<V1> node2 = this;
                node = this.mParent;
                while (node != null && node2 == node.mLeft) {
                    node2 = node;
                    node = node.mParent;
                }
            }
            return node;
        }

        boolean wasRemoved() {
            return this.mSize == 0;
        }

        Node<V1> remove(Node<V1> node) {
            if (this.mSize == 0) {
                throw new IllegalStateException("Entry was already removed.");
            }
            if (this.mLeft == null) {
                if (this.mRight == null) {
                    if (this.mParent == null) {
                        node = null;
                    } else if (this.mParent.mLeft == this) {
                        this.mParent.mLeft = null;
                        Node.fixup(this.mParent);
                        if (this.mIsBlack) {
                            node = Node.removeFixup(this.mParent, null, node);
                        }
                    } else {
                        this.mParent.mRight = null;
                        Node.fixup(this.mParent);
                        if (this.mIsBlack) {
                            node = Node.removeFixup(this.mParent, null, node);
                        }
                    }
                } else {
                    node = this.spliceOut(this.mRight, node);
                }
            } else if (this.mRight == null) {
                node = this.spliceOut(this.mLeft, node);
            } else {
                Node<V1> node2 = this.getNext();
                node = node2.remove(node);
                node2.mParent = this.mParent;
                if (node2.mParent == null) {
                    node = node2;
                } else if (this.mParent.mLeft == this) {
                    this.mParent.mLeft = node2;
                } else {
                    this.mParent.mRight = node2;
                }
                node2.mLeft = this.mLeft;
                if (node2.mLeft != null) {
                    this.mLeft.mParent = node2;
                }
                if ((node2.mRight = this.mRight) != null) {
                    this.mRight.mParent = node2;
                }
                node2.mIsBlack = this.mIsBlack;
                node2.mSize = this.mSize;
                Node.fixup(node2);
            }
            this.mSize = 0;
            return node;
        }

        int compare(int n, int n2) {
            int n3 = 0;
            if (n > this.mStart) {
                n3 = 1;
            } else if (n < this.mStart) {
                n3 = -1;
            } else if (n2 > this.mEnd) {
                n3 = 1;
            } else if (n2 < this.mEnd) {
                n3 = -1;
            }
            return n3;
        }

        static <V1> Node<V1> getNextOverlapper(Node<V1> node, int n, int n2) {
            do {
                Node<V1> node2;
                if ((node2 = node.mRight) != null && node2.mMaxEnd >= n) {
                    node = node2;
                    while ((node2 = node.mLeft) != null && node2.mMaxEnd >= n) {
                        node = node2;
                    }
                } else {
                    node2 = node;
                    while ((node = node2.mParent) != null && node.mRight == node2) {
                        node2 = node;
                    }
                }
                if (node == null || node.mStart <= n2) continue;
                node = null;
            } while (node != null && (node.mStart > n2 || n > node.mEnd));
            return node;
        }

        static <V1> Node<V1> findByRank(Node<V1> node, int n) {
            int n2;
            while (node != null && n != (n2 = super.getRank())) {
                if (n < n2) {
                    node = node.mLeft;
                    continue;
                }
                node = node.mRight;
                n -= n2;
            }
            return node;
        }

        static <V1> int getRank(Node<V1> node, int n, int n2) {
            int n3 = 0;
            while (node != null) {
                int n4 = node.compare(n, n2);
                if (n4 < 0) {
                    node = node.mLeft;
                    continue;
                }
                n3 += super.getRank();
                if (n4 == 0) {
                    return n3;
                }
                node = node.mRight;
            }
            return 0;
        }

        private int getRank() {
            int n = 1;
            if (this.mLeft != null) {
                n = this.mLeft.mSize + 1;
            }
            return n;
        }

        private Node<V1> spliceOut(Node<V1> node, Node<V1> node2) {
            node.mParent = this.mParent;
            if (node.mParent == null) {
                node2 = node;
                node.mIsBlack = true;
            } else {
                if (this.mParent.mLeft == this) {
                    this.mParent.mLeft = node;
                } else {
                    this.mParent.mRight = node;
                }
                Node.fixup(this.mParent);
                if (this.mIsBlack) {
                    node2 = Node.removeFixup(this.mParent, node, node2);
                }
            }
            return node2;
        }

        private Node<V1> rotateLeft(Node<V1> node) {
            Node<V1> node2 = this.mRight;
            int n = node2.mSize;
            node2.mSize = this.mSize;
            this.mSize -= n;
            this.mRight = node2.mLeft;
            if (this.mRight != null) {
                this.mRight.mParent = this;
                this.mSize += this.mRight.mSize;
            }
            if ((node2.mParent = this.mParent) == null) {
                node = node2;
            } else if (this == this.mParent.mLeft) {
                this.mParent.mLeft = node2;
            } else {
                this.mParent.mRight = node2;
            }
            node2.mLeft = this;
            this.mParent = node2;
            this.setMaxEnd();
            super.setMaxEnd();
            return node;
        }

        private Node<V1> rotateRight(Node<V1> node) {
            Node<V1> node2 = this.mLeft;
            int n = node2.mSize;
            node2.mSize = this.mSize;
            this.mSize -= n;
            this.mLeft = node2.mRight;
            if (this.mLeft != null) {
                this.mLeft.mParent = this;
                this.mSize += this.mLeft.mSize;
            }
            if ((node2.mParent = this.mParent) == null) {
                node = node2;
            } else if (this == this.mParent.mLeft) {
                this.mParent.mLeft = node2;
            } else {
                this.mParent.mRight = node2;
            }
            node2.mRight = this;
            this.mParent = node2;
            this.setMaxEnd();
            super.setMaxEnd();
            return node;
        }

        private void setMaxEnd() {
            this.mMaxEnd = this.mEnd;
            if (this.mLeft != null) {
                this.mMaxEnd = Math.max(this.mMaxEnd, this.mLeft.mMaxEnd);
            }
            if (this.mRight != null) {
                this.mMaxEnd = Math.max(this.mMaxEnd, this.mRight.mMaxEnd);
            }
        }

        private static <V1> void fixup(Node<V1> node) {
            do {
                node.mSize = 1;
                node.mMaxEnd = node.mEnd;
                if (node.mLeft != null) {
                    node.mSize += node.mLeft.mSize;
                    node.mMaxEnd = Math.max(node.mMaxEnd, node.mLeft.mMaxEnd);
                }
                if (node.mRight == null) continue;
                node.mSize += node.mRight.mSize;
                node.mMaxEnd = Math.max(node.mMaxEnd, node.mRight.mMaxEnd);
            } while ((node = node.mParent) != null);
        }

        /*
         * Enabled aggressive block sorting
         */
        private static <V1> Node<V1> insertFixup(Node<V1> node, Node<V1> node2) {
            Node<V1> node3 = node.mParent;
            Node.fixup(node3);
            while (node3 != null && !node3.mIsBlack) {
                block8: {
                    Node<V1> node4 = node3.mParent;
                    Node<V1> node5 = node4.mLeft;
                    if (node5 == node3) {
                        node5 = node4.mRight;
                        if (node5 != null && !node5.mIsBlack) {
                            node3.mIsBlack = true;
                            node5.mIsBlack = true;
                            node4.mIsBlack = false;
                            node = node4;
                            break block8;
                        } else {
                            if (node == node3.mRight) {
                                node2 = super.rotateLeft(node2);
                                node3 = node;
                            }
                            node3.mIsBlack = true;
                            node4.mIsBlack = false;
                            node2 = super.rotateRight(node2);
                            break;
                        }
                    }
                    if (node5 != null && !node5.mIsBlack) {
                        node3.mIsBlack = true;
                        node5.mIsBlack = true;
                        node4.mIsBlack = false;
                        node = node4;
                    } else {
                        if (node == node3.mLeft) {
                            node2 = super.rotateRight(node2);
                            node3 = node;
                        }
                        node3.mIsBlack = true;
                        node4.mIsBlack = false;
                        node2 = super.rotateLeft(node2);
                        break;
                    }
                }
                node3 = node.mParent;
            }
            node2.mIsBlack = true;
            return node2;
        }

        private static <V1> Node<V1> removeFixup(Node<V1> node, Node<V1> node2, Node<V1> node3) {
            do {
                Node<V1> node4;
                if (node2 == node.mLeft) {
                    node4 = node.mRight;
                    if (!node4.mIsBlack) {
                        node4.mIsBlack = true;
                        node.mIsBlack = false;
                        node3 = super.rotateLeft(node3);
                        node4 = node.mRight;
                    }
                    if ((node4.mLeft == null || node4.mLeft.mIsBlack) && (node4.mRight == null || node4.mRight.mIsBlack)) {
                        node4.mIsBlack = false;
                        node2 = node;
                        continue;
                    }
                    if (node4.mRight == null || node4.mRight.mIsBlack) {
                        node4.mLeft.mIsBlack = true;
                        node4.mIsBlack = false;
                        node3 = super.rotateRight(node3);
                        node4 = node.mRight;
                    }
                    node4.mIsBlack = node.mIsBlack;
                    node.mIsBlack = true;
                    node4.mRight.mIsBlack = true;
                    node3 = super.rotateLeft(node3);
                    node2 = node3;
                    continue;
                }
                node4 = node.mLeft;
                if (!node4.mIsBlack) {
                    node4.mIsBlack = true;
                    node.mIsBlack = false;
                    node3 = super.rotateRight(node3);
                    node4 = node.mLeft;
                }
                if ((node4.mLeft == null || node4.mLeft.mIsBlack) && (node4.mRight == null || node4.mRight.mIsBlack)) {
                    node4.mIsBlack = false;
                    node2 = node;
                    continue;
                }
                if (node4.mLeft == null || node4.mLeft.mIsBlack) {
                    node4.mRight.mIsBlack = true;
                    node4.mIsBlack = false;
                    node3 = super.rotateLeft(node3);
                    node4 = node.mLeft;
                }
                node4.mIsBlack = node.mIsBlack;
                node.mIsBlack = true;
                node4.mLeft.mIsBlack = true;
                node3 = super.rotateRight(node3);
                node2 = node3;
            } while ((node = node2.mParent) != null && node2.mIsBlack);
            node2.mIsBlack = true;
            return node3;
        }

        public void checkMaxEnd() {
            if (this.mMaxEnd != this.calcMaxEnd()) {
                throw new IllegalStateException("Max end mismatch " + this.mMaxEnd + " vs " + this.calcMaxEnd() + ": " + this);
            }
            if (this.mLeft != null) {
                this.mLeft.checkMaxEnd();
            }
            if (this.mRight != null) {
                this.mRight.checkMaxEnd();
            }
        }

        private int calcMaxEnd() {
            int n = this.mEnd;
            if (this.mLeft != null) {
                n = Math.max(n, this.mLeft.mMaxEnd);
            }
            if (this.mRight != null) {
                n = Math.max(n, this.mRight.mMaxEnd);
            }
            return n;
        }

        public void printNode() {
            this.printNodeInternal("", "root: ");
        }

        private void printNodeInternal(String string, String string2) {
            System.out.println(string + string2 + " " + this);
            if (this.mLeft != null) {
                super.printNodeInternal(string + "  ", "left: ");
            }
            if (this.mRight != null) {
                super.printNodeInternal(string + "  ", "right:");
            }
        }

        public String toString() {
            return "Node(" + this.mStart + "," + this.mEnd + "," + this.mValue + "," + this.mSize + "," + this.mMaxEnd + "," + this.mIsBlack + ")";
        }
    }
}

