/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import java.util.List;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.CigarUtil;
import net.sf.picard.util.Log;
import net.sf.picard.util.ProgressLogger;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;
import net.sf.samtools.SAMSequenceRecord;

public class CleanSam
extends CommandLineProgram {
    @Usage
    public String USAGE = this.getStandardUsagePreamble() + "Read SAM and perform various fix-ups.  " + "Currently, the only fix-ups are 1: to soft-clip an alignment that hangs off the end of its reference sequence; " + "and 2: to set MAPQ to 0 if a read is unmapped.";
    @Option(shortName="I", doc="Input SAM to be cleaned.")
    public File INPUT;
    @Option(shortName="O", doc="Where to write cleaned SAM.")
    public File OUTPUT;

    public static void main(String[] stringArray) {
        new CleanSam().instanceMainWithExit(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doWork() {
        IoUtil.assertFileIsReadable(this.INPUT);
        IoUtil.assertFileIsWritable(this.OUTPUT);
        SAMFileReader.ValidationStringency validationStringency = SAMFileReader.getDefaultValidationStringency();
        if (this.VALIDATION_STRINGENCY == SAMFileReader.ValidationStringency.STRICT) {
            SAMFileReader.setDefaultValidationStringency(SAMFileReader.ValidationStringency.LENIENT);
        }
        try {
            SAMFileReader sAMFileReader = new SAMFileReader(this.INPUT);
            SAMFileWriter sAMFileWriter = new SAMFileWriterFactory().makeSAMOrBAMWriter(sAMFileReader.getFileHeader(), true, this.OUTPUT);
            SAMRecordIterator sAMRecordIterator = sAMFileReader.iterator();
            ProgressLogger progressLogger = new ProgressLogger(Log.getInstance(CleanSam.class));
            while (sAMRecordIterator.hasNext()) {
                SAMRecord sAMRecord = (SAMRecord)sAMRecordIterator.next();
                if (!sAMRecord.getReadUnmappedFlag()) {
                    SAMSequenceRecord sAMSequenceRecord = sAMRecord.getHeader().getSequence(sAMRecord.getReferenceIndex());
                    if (sAMRecord.getAlignmentEnd() > sAMSequenceRecord.getSequenceLength()) {
                        int n = sAMSequenceRecord.getSequenceLength() - sAMRecord.getAlignmentStart() + 1;
                        List<CigarElement> list = CigarUtil.softClipEndOfRead(n, sAMRecord.getCigar().getCigarElements());
                        sAMRecord.setCigar(new Cigar(list));
                    }
                } else if (sAMRecord.getMappingQuality() != 0) {
                    sAMRecord.setMappingQuality(0);
                }
                sAMFileWriter.addAlignment(sAMRecord);
                progressLogger.record(sAMRecord);
            }
            sAMFileWriter.close();
            sAMRecordIterator.close();
        }
        finally {
            SAMFileReader.setDefaultValidationStringency(validationStringency);
        }
        return 0;
    }
}

