/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.pedigree;

import net.sf.picard.pedigree.PedFile;
import net.sf.picard.pedigree.Sex;

public class PedTrio {
    public static final Number NO_PHENO = new Integer(-9);
    public static final Sex UNKNOWN_SEX = Sex.Unknown;
    private final String familyId;
    private final String individualId;
    private final String paternalId;
    private final String maternalId;
    private final Sex sex;
    private final Number phenotype;

    public PedTrio(String string, String string2, String string3, String string4, Sex sex, Number number) {
        if (PedFile.WHITESPACE.split(string).length != 1) {
            throw new IllegalArgumentException("FamilyID     cannot contain whitespace: [" + string + "]");
        }
        if (PedFile.WHITESPACE.split(string2).length != 1) {
            throw new IllegalArgumentException("IndividualID cannot contain whitespace: [" + string2 + "]");
        }
        if (PedFile.WHITESPACE.split(string3).length != 1) {
            throw new IllegalArgumentException("PaternalID   cannot contain whitespace: [" + string3 + "]");
        }
        if (PedFile.WHITESPACE.split(string4).length != 1) {
            throw new IllegalArgumentException("MaternalID   cannot contain whitespace: [" + string4 + "]");
        }
        this.familyId = string;
        this.individualId = string2;
        this.paternalId = string3;
        this.maternalId = string4;
        this.sex = sex;
        this.phenotype = number;
    }

    public boolean hasBothParents() {
        return this.paternalId != null && this.maternalId != null;
    }

    public String getFamilyId() {
        return this.familyId;
    }

    public String getIndividualId() {
        return this.individualId;
    }

    public String getPaternalId() {
        return this.paternalId;
    }

    public String getMaternalId() {
        return this.maternalId;
    }

    public Sex getSex() {
        return this.sex;
    }

    public Number getPhenotype() {
        return this.phenotype;
    }
}

