/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.util;

import java.util.Iterator;
import org.molgenis.genotype.GenotypeData;
import org.molgenis.genotype.variant.GeneticVariant;

public class GenotypeDataCompareTool {
    public static boolean same(GenotypeData gd1, GenotypeData gd2) {
        if (gd1.getSamples().equals(gd2.getSamples()) && gd1.getVariantAnnotations().equals(gd2.getVariantAnnotations())) {
            Iterator it1 = gd1.iterator();
            Iterator it2 = gd2.iterator();
            while (it1.hasNext()) {
                GeneticVariant v2;
                if (!it2.hasNext()) {
                    return false;
                }
                GeneticVariant v1 = (GeneticVariant)it1.next();
                if (GenotypeDataCompareTool.same(v1, v2 = (GeneticVariant)it2.next())) continue;
                return false;
            }
            return !it2.hasNext();
        }
        return false;
    }

    public static boolean same(GeneticVariant v1, GeneticVariant v2) {
        if (!v1.getVariantId().isSameId(v2.getVariantId())) {
            return false;
        }
        if (!v1.getSequenceName().equals(v2.getSequenceName())) {
            return false;
        }
        if (v1.getStartPos() != v2.getStartPos()) {
            return false;
        }
        if (!v1.getVariantAlleles().equals(v2.getVariantAlleles())) {
            return false;
        }
        if (!v1.getSampleVariants().equals(v2.getSampleVariants())) {
            return false;
        }
        return v1.getAnnotationValues().equals(v1.getAnnotationValues());
    }
}

