/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.variantFilter;

import java.util.HashSet;
import java.util.Set;
import org.molgenis.genotype.variant.GeneticVariant;
import org.molgenis.genotype.variantFilter.VariantFilter;

public class VariantIdIncludeFilter
implements VariantFilter {
    private final Set<String> include;

    public VariantIdIncludeFilter(Set<String> include) {
        this.include = include == null ? new HashSet() : include;
    }

    public VariantIdIncludeFilter(String ... ids) {
        this.include = new HashSet<String>();
        for (String id : ids) {
            this.include.add(id);
        }
    }

    @Override
    public boolean doesVariantPassFilter(GeneticVariant variant) {
        return this.include.contains(variant.getPrimaryVariantId());
    }

    public void addIdToInclude(String id) {
        this.include.add(id);
    }

    @Override
    public boolean doesIdPassFilter(String id) {
        return this.include.contains(id);
    }
}

