/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.modifiable;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.molgenis.genotype.AbstractRandomAccessGenotypeData;
import org.molgenis.genotype.Allele;
import org.molgenis.genotype.Alleles;
import org.molgenis.genotype.GenotypeDataException;
import org.molgenis.genotype.RandomAccessGenotypeData;
import org.molgenis.genotype.Sample;
import org.molgenis.genotype.Sequence;
import org.molgenis.genotype.annotation.Annotation;
import org.molgenis.genotype.annotation.SampleAnnotation;
import org.molgenis.genotype.modifiable.ModifiableGeneticVariant;
import org.molgenis.genotype.modifiable.ModifiableGeneticVariantIterator;
import org.molgenis.genotype.modifiable.ModifiableGenotypeData;
import org.molgenis.genotype.variant.GeneticVariant;
import org.molgenis.genotype.variant.id.GeneticVariantId;
import org.molgenis.genotype.variant.sampleProvider.SampleVariantsProvider;
import org.molgenis.genotype.variant.sampleProvider.SwappingSampleVariantsProvider;

public class ModifiableGenotypeDataInMemory
extends AbstractRandomAccessGenotypeData
implements ModifiableGenotypeData {
    private final RandomAccessGenotypeData sourceGenotypeData;
    private final HashMap<GeneticVariant, GeneticVariantId> idUpdates;
    private final HashMap<GeneticVariant, Allele> refAlleleUpdate;
    private final HashMap<GeneticVariant, Alleles> allelesUpdate;
    private final HashMap<GeneticVariant, SampleVariantsProvider> variantProviderUpdates;
    private final HashSet<ModifiableGeneticVariant> filteredOutVariants;
    private final HashMap<SampleVariantsProvider, SampleVariantsProvider> swappingSampleVariantProviders;

    public ModifiableGenotypeDataInMemory(RandomAccessGenotypeData sourceGenotypeData) {
        this.sourceGenotypeData = sourceGenotypeData;
        this.idUpdates = new HashMap();
        this.refAlleleUpdate = new HashMap();
        this.allelesUpdate = new HashMap();
        this.variantProviderUpdates = new HashMap();
        this.swappingSampleVariantProviders = new HashMap();
        this.filteredOutVariants = new HashSet();
    }

    @Override
    public List<String> getSeqNames() {
        return this.sourceGenotypeData.getSeqNames();
    }

    @Override
    public Iterable<Sequence> getSequences() {
        return this.sourceGenotypeData.getSequences();
    }

    @Override
    public Sequence getSequenceByName(String name) {
        return this.sourceGenotypeData.getSequenceByName(name);
    }

    @Override
    public Iterable<GeneticVariant> getVariantsByPos(String seqName, int startPos) {
        return ModifiableGeneticVariantIterator.createGeneticVariantIterableBackByModifiable(this.sourceGenotypeData.getVariantsByPos(seqName, startPos).iterator(), this, this.filteredOutVariants);
    }

    @Override
    public GeneticVariant getSnpVariantByPos(String seqName, int startPos) {
        return this.getModifiableSnpVariantByPos(seqName, startPos);
    }

    @Override
    public Iterable<GeneticVariant> getSequenceGeneticVariants(String seqName) {
        return ModifiableGeneticVariantIterator.createGeneticVariantIterableBackByModifiable(this.sourceGenotypeData.getSequenceGeneticVariants(seqName).iterator(), this, this.filteredOutVariants);
    }

    @Override
    public List<Annotation> getVariantAnnotations() {
        return this.sourceGenotypeData.getVariantAnnotations();
    }

    @Override
    public Annotation getVariantAnnotation(String annotationId) {
        return this.sourceGenotypeData.getVariantAnnotation(annotationId);
    }

    @Override
    public List<Sample> getSamples() {
        return this.sourceGenotypeData.getSamples();
    }

    @Override
    public Iterator<GeneticVariant> iterator() {
        return ModifiableGeneticVariantIterator.createGeneticVariantIterableBackByModifiable(this.sourceGenotypeData.iterator(), this, this.filteredOutVariants).iterator();
    }

    @Override
    public synchronized GeneticVariantId getUpdatedId(ModifiableGeneticVariant geneticVariant) {
        return this.idUpdates.get(geneticVariant.getOriginalVariant());
    }

    @Override
    public synchronized Allele getUpdatedRef(ModifiableGeneticVariant geneticVariant) {
        return this.refAlleleUpdate.get(geneticVariant.getOriginalVariant());
    }

    @Override
    public synchronized SampleVariantsProvider getUpdatedSampleVariantProvider(ModifiableGeneticVariant geneticVariant) {
        return this.variantProviderUpdates.get(geneticVariant.getOriginalVariant());
    }

    @Override
    public synchronized void updateVariantId(ModifiableGeneticVariant geneticVariant, GeneticVariantId newGeneticVariantId) {
        GeneticVariant originalGeneticVariant = geneticVariant.getOriginalVariant();
        if (originalGeneticVariant.getVariantId().equals(newGeneticVariantId)) {
            this.idUpdates.remove(originalGeneticVariant);
            return;
        }
        this.idUpdates.put(originalGeneticVariant, newGeneticVariantId);
    }

    @Override
    public synchronized void updateVariantPrimaryId(ModifiableGeneticVariant geneticVariant, String newPrimaryId) {
        GeneticVariant originalGeneticVariant = geneticVariant.getOriginalVariant();
        GeneticVariantId currentId = this.idUpdates.get(originalGeneticVariant);
        if (currentId != null ? currentId.getPrimairyId().equals(newPrimaryId) : (currentId = originalGeneticVariant.getVariantId()).getPrimairyId().equals(newPrimaryId)) {
            return;
        }
        String oldPrimairyId = currentId.getPrimairyId();
        ArrayList<String> newAlternativeAlleles = new ArrayList<String>(currentId.getAlternativeIds());
        newAlternativeAlleles.remove(newPrimaryId);
        newAlternativeAlleles.add(oldPrimairyId);
        this.updateVariantId(geneticVariant, GeneticVariantId.createVariantId(newPrimaryId, newAlternativeAlleles));
    }

    @Override
    public synchronized void swapGeneticVariant(ModifiableGeneticVariant geneticVariant) {
        SampleVariantsProvider swappingSampleVariantsProvider;
        SampleVariantsProvider sampleVariantProvider;
        Allele refAllele;
        GeneticVariant originalGeneticVariant = geneticVariant.getOriginalVariant();
        Alleles variantAlleles = this.getUpdatedAlleles(geneticVariant);
        if (variantAlleles == null) {
            variantAlleles = originalGeneticVariant.getVariantAlleles();
        }
        if ((refAllele = this.getUpdatedRef(geneticVariant)) == null) {
            refAllele = originalGeneticVariant.getRefAllele();
        }
        if ((sampleVariantProvider = this.getUpdatedSampleVariantProvider(geneticVariant)) == null) {
            sampleVariantProvider = originalGeneticVariant.getSampleVariantsProvider();
        }
        if ((swappingSampleVariantsProvider = this.swappingSampleVariantProviders.get(sampleVariantProvider)) == null) {
            swappingSampleVariantsProvider = new SwappingSampleVariantsProvider(sampleVariantProvider);
            this.swappingSampleVariantProviders.put(sampleVariantProvider, swappingSampleVariantsProvider);
        }
        this.allelesUpdate.put(originalGeneticVariant, variantAlleles.getComplement());
        this.variantProviderUpdates.put(originalGeneticVariant, swappingSampleVariantsProvider);
        if (refAllele != null) {
            this.refAlleleUpdate.put(originalGeneticVariant, refAllele.getComplement());
        }
    }

    @Override
    public synchronized void updateRefAllele(ModifiableGeneticVariant geneticVariant, Allele newRefAllele) {
        GeneticVariant originalGeneticVariant = geneticVariant.getOriginalVariant();
        if (originalGeneticVariant.getRefAllele() == newRefAllele && !this.refAlleleUpdate.containsKey(originalGeneticVariant)) {
            return;
        }
        Alleles variantAlleles = this.getUpdatedAlleles(geneticVariant);
        if (variantAlleles == null) {
            variantAlleles = originalGeneticVariant.getVariantAlleles();
        }
        if (!variantAlleles.contains(newRefAllele)) {
            throw new GenotypeDataException("Can not update to reference allele (" + newRefAllele + ") is not a found in supplied alleles " + variantAlleles.getAllelesAsString() + " for variant with ID: " + originalGeneticVariant.getPrimaryVariantId() + " at: " + originalGeneticVariant.getSequenceName() + ":" + originalGeneticVariant.getStartPos());
        }
        ArrayList<Allele> allelesWithoutRef = new ArrayList<Allele>(variantAlleles.getAlleles());
        allelesWithoutRef.remove(newRefAllele);
        allelesWithoutRef.add(0, newRefAllele);
        this.allelesUpdate.put(originalGeneticVariant, Alleles.createAlleles(allelesWithoutRef));
        this.refAlleleUpdate.put(originalGeneticVariant, newRefAllele);
    }

    @Override
    public synchronized Alleles getUpdatedAlleles(ModifiableGeneticVariant geneticVariant) {
        return this.allelesUpdate.get(geneticVariant.getOriginalVariant());
    }

    @Override
    public Iterable<ModifiableGeneticVariant> getModifiableSequenceGeneticVariants(String seqName) {
        Iterator<GeneticVariant> originalIterator = this.sourceGenotypeData.getSequenceGeneticVariants(seqName).iterator();
        return ModifiableGeneticVariantIterator.createModifiableGeneticVariantIterable(originalIterator, this, this.filteredOutVariants);
    }

    @Override
    public Iterable<ModifiableGeneticVariant> getModifiableVariantsByPos(String seqName, int startPos) {
        Iterator<GeneticVariant> originalIterator = this.sourceGenotypeData.getVariantsByPos(seqName, startPos).iterator();
        return ModifiableGeneticVariantIterator.createModifiableGeneticVariantIterable(originalIterator, this, this.filteredOutVariants);
    }

    @Override
    public ModifiableGeneticVariant getModifiableSnpVariantByPos(String seqName, int startPos) {
        GeneticVariant originalVariant = this.sourceGenotypeData.getSnpVariantByPos(seqName, startPos);
        if (originalVariant == null) {
            return null;
        }
        ModifiableGeneticVariant modifiableVariant = new ModifiableGeneticVariant(originalVariant, this);
        if (this.filteredOutVariants.contains(modifiableVariant)) {
            return null;
        }
        return modifiableVariant;
    }

    @Override
    public Iterable<ModifiableGeneticVariant> getModifiableGeneticVariants() {
        return ModifiableGeneticVariantIterator.createModifiableGeneticVariantIterable(this.sourceGenotypeData.iterator(), this, this.filteredOutVariants);
    }

    @Override
    public void excludeVariant(ModifiableGeneticVariant geneticVariant) {
        this.filteredOutVariants.add(geneticVariant);
    }

    @Override
    public int getExcludedVariantCount() {
        return this.filteredOutVariants.size();
    }

    @Override
    public List<SampleAnnotation> getSampleAnnotations() {
        return this.sourceGenotypeData.getSampleAnnotations();
    }

    @Override
    public Annotation getSampleAnnotation(String annotationId) {
        return this.sourceGenotypeData.getSampleAnnotation(annotationId);
    }

    @Override
    public Iterable<GeneticVariant> getVariantsByRange(String seqName, int rangeStart, int rangeEnd) {
        return ModifiableGeneticVariantIterator.createGeneticVariantIterableBackByModifiable(this.sourceGenotypeData.getVariantsByRange(seqName, rangeStart, rangeEnd).iterator(), this, this.filteredOutVariants);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Map<String, Annotation> getVariantAnnotationsMap() {
        return this.sourceGenotypeData.getVariantAnnotationsMap();
    }

    @Override
    public Map<String, SampleAnnotation> getSampleAnnotationsMap() {
        return this.sourceGenotypeData.getSampleAnnotationsMap();
    }

    @Override
    public boolean isOnlyContaingSaveProbabilityGenotypes() {
        return this.sourceGenotypeData.isOnlyContaingSaveProbabilityGenotypes();
    }
}

