/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.picard.PicardException;
import net.sf.picard.filter.AggregateFilter;
import net.sf.picard.filter.DuplicateReadFilter;
import net.sf.picard.filter.FilteringIterator;
import net.sf.picard.filter.SamRecordFilter;
import net.sf.picard.filter.SecondaryOrSupplementaryFilter;
import net.sf.picard.util.Interval;
import net.sf.picard.util.IntervalList;
import net.sf.picard.util.IntervalListReferenceSequenceMask;
import net.sf.picard.util.Locus;
import net.sf.picard.util.LocusComparator;
import net.sf.picard.util.LocusImpl;
import net.sf.picard.util.Log;
import net.sf.picard.util.PeekableIterator;
import net.sf.picard.util.ReferenceSequenceMask;
import net.sf.picard.util.SamRecordIntervalIteratorFactory;
import net.sf.picard.util.WholeGenomeReferenceSequenceMask;
import net.sf.samtools.AlignmentBlock;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.util.CloseableIterator;

public class SamLocusIterator
implements Iterable<LocusInfo>,
CloseableIterator<LocusInfo> {
    private static final Log LOG = Log.getInstance(SamLocusIterator.class);
    private final SAMFileReader samReader;
    private final ReferenceSequenceMask referenceSequenceMask;
    private PeekableIterator<SAMRecord> samIterator;
    private List<SamRecordFilter> samFilters = Arrays.asList(new SecondaryOrSupplementaryFilter(), new DuplicateReadFilter());
    private final List<Interval> intervals;
    private final boolean useIndex;
    private final LinkedList<LocusInfo> complete = new LinkedList();
    private final LinkedList<LocusInfo> accumulator = new LinkedList();
    private int qualityScoreCutoff = Integer.MIN_VALUE;
    private int mappingQualityScoreCutoff = Integer.MIN_VALUE;
    private boolean emitUncoveredLoci = true;
    private int lastReferenceSequence = 0;
    private int lastPosition = 0;
    private boolean finishedAlignedReads = false;
    private final LocusComparator<Locus> locusComparator = new LocusComparator();

    public SamLocusIterator(SAMFileReader sAMFileReader) {
        this(sAMFileReader, null);
    }

    public SamLocusIterator(SAMFileReader sAMFileReader, IntervalList intervalList) {
        this(sAMFileReader, intervalList, false);
    }

    public SamLocusIterator(SAMFileReader sAMFileReader, IntervalList intervalList, boolean bl) {
        if (sAMFileReader.getFileHeader().getSortOrder() == null || sAMFileReader.getFileHeader().getSortOrder() == SAMFileHeader.SortOrder.unsorted) {
            LOG.warn("SamLocusIterator constructed with samReader that has SortOrder == unsorted.  ", "Assuming SAM is coordinate sorted, but exceptions may occur if it is not.");
        } else if (sAMFileReader.getFileHeader().getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
            throw new PicardException("SamLocusIterator cannot operate on a SAM file that is not coordinate sorted.");
        }
        this.samReader = sAMFileReader;
        this.useIndex = bl;
        if (intervalList != null) {
            this.intervals = intervalList.getUniqueIntervals();
            this.referenceSequenceMask = new IntervalListReferenceSequenceMask(intervalList);
        } else {
            this.intervals = null;
            this.referenceSequenceMask = new WholeGenomeReferenceSequenceMask(sAMFileReader.getFileHeader());
        }
    }

    @Override
    public Iterator<LocusInfo> iterator() {
        if (this.samIterator != null) {
            throw new IllegalStateException("Cannot call iterator() more than once on SamLocusIterator");
        }
        CloseableIterator<SAMRecord> closeableIterator = this.intervals != null ? new SamRecordIntervalIteratorFactory().makeSamRecordIntervalIterator(this.samReader, this.intervals, this.useIndex) : this.samReader.iterator();
        if (this.samFilters != null) {
            closeableIterator = new FilteringIterator(closeableIterator, new AggregateFilter(this.samFilters));
        }
        this.samIterator = new PeekableIterator<SAMRecord>(closeableIterator);
        return this;
    }

    @Override
    public void close() {
        this.samIterator.close();
    }

    private boolean samHasMore() {
        return !this.finishedAlignedReads && this.samIterator.peek() != null;
    }

    @Override
    public boolean hasNext() {
        while (this.complete.isEmpty() && (!this.accumulator.isEmpty() || this.samHasMore() || this.hasRemainingMaskBases())) {
            LocusInfo locusInfo = this.next();
            if (locusInfo == null) continue;
            this.complete.addFirst(locusInfo);
        }
        return !this.complete.isEmpty();
    }

    private boolean hasRemainingMaskBases() {
        if (!this.emitUncoveredLoci) {
            return false;
        }
        return this.lastReferenceSequence < this.referenceSequenceMask.getMaxSequenceIndex() || this.lastReferenceSequence == this.referenceSequenceMask.getMaxSequenceIndex() && this.lastPosition < this.referenceSequenceMask.nextPosition(this.lastReferenceSequence, this.lastPosition);
    }

    @Override
    public LocusInfo next() {
        LocusImpl locusImpl;
        Object object;
        while (this.complete.isEmpty() && this.samHasMore()) {
            object = this.samIterator.peek();
            if (((SAMRecord)object).getReferenceIndex() == -1) {
                this.finishedAlignedReads = true;
                continue;
            }
            if (((SAMRecord)object).getReadUnmappedFlag()) {
                this.samIterator.next();
                continue;
            }
            locusImpl = new LocusImpl(((SAMRecord)object).getReferenceIndex(), ((SAMRecord)object).getAlignmentStart());
            while (!this.accumulator.isEmpty() && this.locusComparator.compare(this.accumulator.getFirst(), locusImpl) < 0) {
                LocusInfo locusInfo = this.accumulator.getFirst();
                this.populateCompleteQueue(locusImpl);
                if (!this.complete.isEmpty()) {
                    return this.complete.removeFirst();
                }
                if (this.accumulator.isEmpty() || locusInfo != this.accumulator.getFirst()) continue;
                throw new PicardException("Stuck in infinite loop");
            }
            if (!(this.accumulator.isEmpty() || this.accumulator.getFirst().getSequenceIndex() == ((SAMRecord)object).getReferenceIndex().intValue() && this.accumulator.getFirst().position == ((SAMRecord)object).getAlignmentStart())) {
                throw new IllegalStateException("accumulator should be empty or aligned with current SAMRecord");
            }
            this.accumulateSamRecord((SAMRecord)object);
            this.samIterator.next();
        }
        object = new LocusImpl(Integer.MAX_VALUE, Integer.MAX_VALUE);
        if (this.complete.isEmpty() && !this.samHasMore()) {
            while (!this.accumulator.isEmpty()) {
                this.populateCompleteQueue((Locus)object);
                if (this.complete.isEmpty()) continue;
                return this.complete.removeFirst();
            }
        }
        if (!this.complete.isEmpty()) {
            return this.complete.removeFirst();
        }
        if (this.emitUncoveredLoci) {
            locusImpl = new LocusImpl(this.referenceSequenceMask.getMaxSequenceIndex(), this.referenceSequenceMask.getMaxPosition() + 1);
            return this.createNextUncoveredLocusInfo(locusImpl);
        }
        return null;
    }

    private void accumulateSamRecord(SAMRecord sAMRecord) {
        for (AlignmentBlock alignmentBlock : sAMRecord.getAlignmentBlocks()) {
            for (int i = 0; i < alignmentBlock.getLength(); ++i) {
                int n = alignmentBlock.getReadStart() + i - 1;
                int n2 = alignmentBlock.getReferenceStart() + i;
                int n3 = n2 - sAMRecord.getAlignmentStart();
                for (int j = this.accumulator.size(); j <= n3; ++j) {
                    this.accumulator.add(new LocusInfo(this.getReferenceSequence(sAMRecord.getReferenceIndex()), sAMRecord.getAlignmentStart() + j));
                }
                if (sAMRecord.getBaseQualities()[n] < this.getQualityScoreCutoff() || sAMRecord.getMappingQuality() < this.getMappingQualityScoreCutoff()) continue;
                this.accumulator.get(n3).add(sAMRecord, n);
            }
        }
    }

    private LocusInfo createNextUncoveredLocusInfo(Locus locus) {
        while (this.lastReferenceSequence <= locus.getSequenceIndex() && this.lastReferenceSequence <= this.referenceSequenceMask.getMaxSequenceIndex()) {
            if (this.lastReferenceSequence == locus.getSequenceIndex() && this.lastPosition + 1 >= locus.getPosition()) {
                return null;
            }
            int n = this.referenceSequenceMask.nextPosition(this.lastReferenceSequence, this.lastPosition);
            if (n == -1) {
                if (this.lastReferenceSequence == locus.getSequenceIndex()) {
                    this.lastPosition = locus.getPosition();
                    return null;
                }
                ++this.lastReferenceSequence;
                this.lastPosition = 0;
                continue;
            }
            if (this.lastReferenceSequence < locus.getSequenceIndex() || n < locus.getPosition()) {
                this.lastPosition = n;
                return new LocusInfo(this.getReferenceSequence(this.lastReferenceSequence), this.lastPosition);
            }
            if (n < locus.getPosition()) continue;
            return null;
        }
        return null;
    }

    private void populateCompleteQueue(Locus locus) {
        LocusInfo locusInfo;
        while (!this.accumulator.isEmpty() && this.accumulator.getFirst().getRecordAndPositions().isEmpty() && this.locusComparator.compare(this.accumulator.getFirst(), locus) < 0) {
            this.accumulator.removeFirst();
        }
        if (this.accumulator.isEmpty()) {
            return;
        }
        LocusInfo locusInfo2 = this.accumulator.getFirst();
        if (this.locusComparator.compare(locus, locusInfo2) <= 0) {
            return;
        }
        if (this.emitUncoveredLoci && (locusInfo = this.createNextUncoveredLocusInfo(locusInfo2)) != null) {
            this.complete.addLast(locusInfo);
            return;
        }
        this.accumulator.removeFirst();
        int n = locusInfo2.getSequenceIndex();
        if (this.referenceSequenceMask.get(locusInfo2.getSequenceIndex(), locusInfo2.getPosition())) {
            this.complete.addLast(locusInfo2);
        }
        this.lastReferenceSequence = n;
        this.lastPosition = locusInfo2.getPosition();
    }

    private SAMSequenceRecord getReferenceSequence(int n) {
        return this.samReader.getFileHeader().getSequence(n);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Can not remove records from a SAM file via an iterator!");
    }

    public void setSamFilters(List<SamRecordFilter> list) {
        this.samFilters = list;
    }

    public int getQualityScoreCutoff() {
        return this.qualityScoreCutoff;
    }

    public void setQualityScoreCutoff(int n) {
        this.qualityScoreCutoff = n;
    }

    public int getMappingQualityScoreCutoff() {
        return this.mappingQualityScoreCutoff;
    }

    public void setMappingQualityScoreCutoff(int n) {
        this.mappingQualityScoreCutoff = n;
    }

    public boolean isEmitUncoveredLoci() {
        return this.emitUncoveredLoci;
    }

    public void setEmitUncoveredLoci(boolean bl) {
        this.emitUncoveredLoci = bl;
    }

    public static class LocusInfo
    implements Locus {
        private final SAMSequenceRecord referenceSequence;
        private final int position;
        private final List<RecordAndOffset> recordAndOffsets = new ArrayList<RecordAndOffset>(100);

        LocusInfo(SAMSequenceRecord sAMSequenceRecord, int n) {
            this.referenceSequence = sAMSequenceRecord;
            this.position = n;
        }

        public void add(SAMRecord sAMRecord, int n) {
            this.recordAndOffsets.add(new RecordAndOffset(sAMRecord, n));
        }

        @Override
        public int getSequenceIndex() {
            return this.referenceSequence.getSequenceIndex();
        }

        @Override
        public int getPosition() {
            return this.position;
        }

        public List<RecordAndOffset> getRecordAndPositions() {
            return Collections.unmodifiableList(this.recordAndOffsets);
        }

        public String getSequenceName() {
            return this.referenceSequence.getSequenceName();
        }

        public String toString() {
            return this.referenceSequence.getSequenceName() + ":" + this.position;
        }
    }

    public static class RecordAndOffset {
        private final SAMRecord record;
        private final int offset;

        public RecordAndOffset(SAMRecord sAMRecord, int n) {
            this.offset = n;
            this.record = sAMRecord;
        }

        public int getOffset() {
            return this.offset;
        }

        public SAMRecord getRecord() {
            return this.record;
        }

        public byte getReadBase() {
            return this.record.getReadBases()[this.offset];
        }

        public byte getBaseQuality() {
            return this.record.getBaseQualities()[this.offset];
        }
    }
}

