/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.reference;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.picard.reference.ReferenceSequenceFile;
import net.sf.picard.reference.ReferenceSequenceFileFactory;
import net.sf.picard.util.Log;
import net.sf.samtools.util.RuntimeIOException;

public class NormalizeFasta
extends CommandLineProgram {
    @Usage
    public final String USAGE = "Takes any file that conforms to the fasta format and normalizes it so that all lines of sequence except the last line per named sequence are of the same length.";
    @Option(shortName="I", doc="The input fasta file to normalize.")
    public File INPUT;
    @Option(shortName="O", doc="The output fasta file to write.")
    public File OUTPUT;
    @Option(doc="The line length to be used for the output fasta file.")
    public int LINE_LENGTH = 100;
    @Option(doc="Truncate sequence names at first whitespace.")
    public boolean TRUNCATE_SEQUENCE_NAMES_AT_WHITESPACE = false;
    private final Log log = Log.getInstance(NormalizeFasta.class);

    public static void main(String[] stringArray) {
        new NormalizeFasta().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        IoUtil.assertFileIsReadable(this.INPUT);
        IoUtil.assertFileIsWritable(this.OUTPUT);
        if (this.INPUT.getAbsoluteFile().equals(this.OUTPUT.getAbsoluteFile())) {
            throw new IllegalArgumentException("Input and output cannot be the same file.");
        }
        ReferenceSequenceFile referenceSequenceFile = ReferenceSequenceFileFactory.getReferenceSequenceFile(this.INPUT, this.TRUNCATE_SEQUENCE_NAMES_AT_WHITESPACE);
        BufferedWriter bufferedWriter = IoUtil.openFileForBufferedWriting(this.OUTPUT);
        ReferenceSequence referenceSequence = null;
        while ((referenceSequence = referenceSequenceFile.nextSequence()) != null) {
            String string = referenceSequence.getName();
            byte[] byArray = referenceSequence.getBases();
            try {
                bufferedWriter.write(">");
                bufferedWriter.write(string);
                bufferedWriter.newLine();
                if (byArray.length == 0) {
                    this.log.warn("Sequence " + string + " contains 0 bases.");
                    continue;
                }
                for (int i = 0; i < byArray.length; ++i) {
                    if (i > 0 && i % this.LINE_LENGTH == 0) {
                        bufferedWriter.write("\n");
                    }
                    bufferedWriter.write(byArray[i]);
                }
                bufferedWriter.write("\n");
            }
            catch (IOException iOException) {
                throw new PicardException("Error writing to file " + this.OUTPUT.getAbsolutePath(), iOException);
            }
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(iOException);
        }
        return 0;
    }
}

