/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.metrics;

import java.lang.reflect.Field;
import net.sf.picard.PicardException;
import net.sf.picard.util.FormatUtil;

public class MetricBase {
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        for (Field field : this.getClass().getFields()) {
            try {
                Object object2 = field.get(this);
                Object object3 = field.get(object);
                if (object2 == null) {
                    if (object3 == null || object3 == null) continue;
                    return false;
                }
                if (object2.equals(object3)) continue;
                return false;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new PicardException("Could not read field " + field.getName() + " from a " + this.getClass().getSimpleName());
            }
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        for (Field field : this.getClass().getFields()) {
            try {
                n = 31 * n + field.get(this).hashCode();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new PicardException("Could not read field " + field.getName() + " from a " + this.getClass().getSimpleName());
            }
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        FormatUtil formatUtil = new FormatUtil();
        for (Field field : this.getClass().getFields()) {
            try {
                stringBuilder.append(field.getName());
                stringBuilder.append("\t");
                stringBuilder.append(formatUtil.format(field.get(this)));
                stringBuilder.append("\n");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new PicardException("Could not read field " + field.getName() + " from a " + this.getClass().getSimpleName());
            }
        }
        return stringBuilder.toString();
    }

    public boolean equals(MetricBase metricBase) {
        for (Field field : this.getClass().getFields()) {
            try {
                if (field.get(this).equals(field.get(metricBase))) continue;
                return false;
            }
            catch (IllegalAccessException illegalAccessException) {
                return false;
            }
        }
        return true;
    }
}

