/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.cmdline;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineParseException;
import net.sf.picard.cmdline.CommandLineParserDefinitionException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.NestedOptions;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.PositionalArguments;
import net.sf.picard.cmdline.Usage;
import net.sf.samtools.util.CloserUtil;
import net.sf.samtools.util.CollectionUtil;
import net.sf.samtools.util.StringUtil;

public class CommandLineParser {
    private static final int OPTION_COLUMN_WIDTH = 30;
    private static final int DESCRIPTION_COLUMN_WIDTH = 90;
    private static final Boolean[] TRUE_FALSE_VALUES = new Boolean[]{Boolean.TRUE, Boolean.FALSE};
    private static final String[] PACKAGES_WITH_WEB_DOCUMENTATION = new String[]{"net.sf.picard"};
    private static final String defaultUsagePreamble = "Usage: program [options...]\n";
    private static final String defaultUsagePreambleWithPositionalArguments = "Usage: program [options...] [positional-arguments...]\n";
    private static final String OPTIONS_FILE = "OPTIONS_FILE";
    private static final String PRECEDENCE_SYMBOL = "++";
    private static final String[][] FRAMEWORK_OPTION_DOC = new String[][]{{"--help", "-h", "Displays options specific to this tool."}, {"--stdhelp", "-H", "Displays options specific to this tool AND options common to all Picard command line tools."}, {"--version", null, "Displays program version."}};
    private final Set<String> optionsThatCannotBeOverridden = new HashSet<String>();
    private final Object callerOptions;
    private final String prefix;
    private final String prefixDot;
    private String usagePreamble;
    private Field positionalArguments;
    private int minPositionalArguments;
    private int maxPositionalArguments;
    private final List<OptionDefinition> optionDefinitions = new ArrayList<OptionDefinition>();
    private final Map<String, OptionDefinition> optionMap = new HashMap<String, OptionDefinition>();
    private final Map<String, CommandLineParser> childOptionsMap = new LinkedHashMap<String, CommandLineParser>();
    private final CollectionUtil.MultiMap<String, ChildOptionArg> childOptionArguments = new CollectionUtil.MultiMap();
    private PrintStream messageStream;
    private String[] argv;
    private String programVersion = "";
    private String commandLine = "";
    public File IGNORE_THIS_PROPERTY;

    public static String getStandardUsagePreamble(Class clazz) {
        return "USAGE: " + clazz.getSimpleName() + " [options]\n\n" + (CommandLineParser.hasWebDocumentation(clazz) ? "Documentation: http://picard.sourceforge.net/command-line-overview.shtml#" + clazz.getSimpleName() + "\n\n" : "");
    }

    public static boolean hasWebDocumentation(Class clazz) {
        for (String string : PACKAGES_WITH_WEB_DOCUMENTATION) {
            if (!clazz.getPackage().getName().startsWith(string)) continue;
            return true;
        }
        return false;
    }

    public static String getFaqLink() {
        return "To get help, see http://picard.sourceforge.net/index.shtml#GettingHelp";
    }

    static Map<String, Object> getNestedOptions(Object object) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        Class<?> clazz = object.getClass();
        for (Field field : CommandLineParser.getAllFields(clazz)) {
            if (field.getAnnotation(NestedOptions.class) == null) continue;
            field.setAccessible(true);
            try {
                linkedHashMap.put(field.getName(), field.get(object));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("Should never happen.", illegalAccessException);
            }
        }
        return linkedHashMap;
    }

    public CommandLineParser(Object object) {
        this(object, "");
    }

    private CommandLineParser(Object object, String string) {
        this.callerOptions = object;
        this.prefix = string;
        this.prefixDot = string.isEmpty() ? "" : string + ".";
        for (Field field : CommandLineParser.getAllFields(this.callerOptions.getClass())) {
            if (field.getAnnotation(PositionalArguments.class) != null) {
                this.handlePositionalArgumentAnnotation(field);
            }
            if (field.getAnnotation(Usage.class) != null) {
                this.handleUsageAnnotation(field);
            }
            if (field.getAnnotation(Option.class) != null) {
                this.handleOptionAnnotation(field);
                continue;
            }
            if (this.isCommandLineProgram() || field.getAnnotation(NestedOptions.class) == null) continue;
            this.handleNestedOptionsAnnotation(field);
        }
        if (this.usagePreamble == null) {
            this.usagePreamble = this.positionalArguments == null ? defaultUsagePreamble : defaultUsagePreambleWithPositionalArguments;
        }
    }

    private boolean isCommandLineProgram() {
        return this.callerOptions instanceof CommandLineProgram;
    }

    private static List<Field> getAllFields(Class clazz) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        do {
            arrayList.addAll(Arrays.asList(clazz.getDeclaredFields()));
        } while ((clazz = clazz.getSuperclass()) != null);
        return arrayList;
    }

    public String getVersion() {
        return this.callerOptions.getClass().getPackage().getImplementationVersion();
    }

    /*
     * WARNING - void declaration
     */
    public void usage(PrintStream printStream, boolean bl) {
        String[][] stringArray;
        if (this.prefix.isEmpty()) {
            void commandLineParser;
            printStream.print(this.usagePreamble);
            printStream.println("\nVersion: " + this.getVersion());
            printStream.println("\n\nOptions:\n");
            stringArray = FRAMEWORK_OPTION_DOC;
            int n = stringArray.length;
            boolean bl2 = false;
            while (commandLineParser < n) {
                String[] stringArray2 = stringArray[commandLineParser];
                this.printOptionParamUsage(printStream, stringArray2[0], stringArray2[1], null, stringArray2[2]);
                ++commandLineParser;
            }
        }
        if (!this.optionDefinitions.isEmpty()) {
            for (OptionDefinition optionDefinition : this.optionDefinitions) {
                if (!bl && optionDefinition.isCommon) continue;
                this.printOptionUsage(printStream, optionDefinition);
            }
        }
        if (bl) {
            try {
                stringArray = this.getClass().getField("IGNORE_THIS_PROPERTY");
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new PicardException("Should never happen", noSuchFieldException);
            }
            OptionDefinition optionDefinition = new OptionDefinition((Field)stringArray, OPTIONS_FILE, "", "File of OPTION_NAME=value pairs.  No positional parameters allowed.  Unlike command-line options, unrecognized options are ignored.  A single-valued option set in an options file may be overridden by a subsequent command-line option.  A line starting with '#' is considered a comment.", false, true, 0, Integer.MAX_VALUE, null, true, new String[0]);
            this.printOptionUsage(printStream, optionDefinition);
        }
        stringArray = this.getChildParsersForHelp();
        for (CommandLineParser commandLineParser : stringArray) {
            commandLineParser.usage(printStream, bl);
        }
    }

    private Collection<CommandLineParser> getChildParsersForHelp() {
        ArrayList<CommandLineParser> arrayList;
        if (this.isCommandLineProgram()) {
            arrayList = new ArrayList();
            for (Map.Entry<String, Object> entry : ((CommandLineProgram)this.callerOptions).getNestedOptionsForHelp().entrySet()) {
                if (entry.getKey().contains(".")) {
                    throw new IllegalArgumentException("Prefix for nested options should not contain period: " + entry.getKey());
                }
                arrayList.add(new CommandLineParser(entry.getValue(), this.prefixDot + entry.getKey()));
            }
        } else {
            arrayList = this.childOptionsMap.values();
        }
        return arrayList;
    }

    public void htmlUsage(PrintStream printStream, String string, boolean bl) {
        printStream.println("<a name=\"" + string + "\"/>");
        printStream.println("<h3>" + string + "</h3>");
        printStream.println("<p>" + CommandLineParser.htmlEscape(this.usagePreamble) + "</p>");
        boolean bl2 = false;
        for (OptionDefinition optionDefinition : this.optionDefinitions) {
            if (optionDefinition.isCommon && !bl) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            this.htmlPrintOptions(printStream, bl);
        }
        printStream.println("<br/>");
    }

    public void htmlPrintOptions(PrintStream printStream, boolean bl) {
        printStream.println("<table>");
        printStream.println("<tr><th>Option</th><th>Description</th></tr>");
        if (bl) {
            for (String[] stringArray : FRAMEWORK_OPTION_DOC) {
                printStream.println("<tr><td>" + stringArray[0] + "</td><td>" + CommandLineParser.htmlEscape(stringArray[2]) + "</td></tr>");
            }
        }
        this.htmlPrintOptionTableRows(printStream, bl);
        printStream.println("</table>");
    }

    private void htmlPrintOptionTableRows(PrintStream printStream, boolean bl) {
        for (OptionDefinition object : this.optionDefinitions) {
            if (object.isCommon && !bl) continue;
            this.printHtmlOptionUsage(printStream, object);
        }
        for (CommandLineParser commandLineParser : this.getChildParsersForHelp()) {
            commandLineParser.htmlPrintOptionTableRows(printStream, false);
        }
    }

    private static String htmlEscape(String string) {
        string = string.replaceAll("<", "&lt;");
        string = string.replaceAll("\n", "\n<p>");
        return string;
    }

    public boolean parseOptions(PrintStream printStream, String[] stringArray) {
        this.argv = stringArray;
        this.messageStream = printStream;
        if (this.prefix.isEmpty()) {
            this.commandLine = this.callerOptions.getClass().getName();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.equals("-h") || string.equals("--help")) {
                this.usage(printStream, false);
                return false;
            }
            if (string.equals("-H") || string.equals("--stdhelp")) {
                this.usage(printStream, true);
                return false;
            }
            if (string.equals("--version")) {
                printStream.println(this.getVersion());
                return false;
            }
            String[] stringArray2 = string.split("=", 2);
            if (stringArray2.length == 2 && stringArray2[1].length() == 0 && i < stringArray.length - 1) {
                stringArray2[1] = stringArray[++i];
            }
            if (stringArray2.length == 2) {
                if (this.parseOption(stringArray2[0], stringArray2[1], false)) continue;
                printStream.println();
                this.usage(printStream, true);
                return false;
            }
            if (this.parsePositionalArgument(string)) continue;
            printStream.println();
            this.usage(printStream, false);
            return false;
        }
        if (!this.checkNumArguments()) {
            printStream.println();
            this.usage(printStream, false);
            return false;
        }
        if (!this.parseChildOptions()) {
            printStream.println();
            this.usage(printStream, false);
            return false;
        }
        return true;
    }

    private boolean checkNumArguments() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string;
            for (OptionDefinition object : this.optionDefinitions) {
                string = this.prefixDot + object.name;
                StringBuilder stringBuilder2 = new StringBuilder();
                for (String string2 : object.mutuallyExclusive) {
                    OptionDefinition optionDefinition = this.optionMap.get(string2);
                    if (optionDefinition == null || !optionDefinition.hasBeenSet) continue;
                    stringBuilder2.append(" ").append(this.prefixDot + optionDefinition.name);
                }
                if (object.hasBeenSet && stringBuilder2.length() > 0) {
                    this.messageStream.println("ERROR: Option '" + string + "' cannot be used in conjunction with option(s)" + stringBuilder2.toString());
                    return false;
                }
                if (object.isCollection) {
                    Collection collection = (Collection)object.field.get(this.callerOptions);
                    if (collection.size() >= object.minElements) continue;
                    this.messageStream.println("ERROR: Option '" + string + "' must be specified at least " + object.minElements + " times.");
                    return false;
                }
                if (object.optional || object.hasBeenSet || object.hasBeenSetFromParent || stringBuilder2.length() != 0) continue;
                this.messageStream.print("ERROR: Option '" + string + "' is required");
                if (object.mutuallyExclusive.isEmpty()) {
                    this.messageStream.println(".");
                } else {
                    this.messageStream.println(" unless any of " + object.mutuallyExclusive + " are specified.");
                }
                return false;
            }
            if (this.positionalArguments != null) {
                Collection collection = (Collection)this.positionalArguments.get(this.callerOptions);
                if (collection.size() < this.minPositionalArguments) {
                    this.messageStream.println("ERROR: At least " + this.minPositionalArguments + " positional arguments must be specified.");
                    return false;
                }
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    string = iterator.next();
                    stringBuilder.append(" " + string.toString());
                }
            }
            for (OptionDefinition optionDefinition : this.optionDefinitions) {
                if (!optionDefinition.hasBeenSet) continue;
                stringBuilder.append(" " + this.prefixDot + optionDefinition.name + "=" + optionDefinition.field.get(this.callerOptions));
            }
            stringBuilder.append("   ");
            for (OptionDefinition optionDefinition : this.optionDefinitions) {
                if (optionDefinition.hasBeenSet || optionDefinition.defaultValue.equals("null")) continue;
                stringBuilder.append(" " + this.prefixDot + optionDefinition.name + "=" + optionDefinition.defaultValue);
            }
            this.commandLine = this.commandLine + stringBuilder.toString();
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    private boolean parsePositionalArgument(String string) {
        Collection collection;
        Object object;
        if (this.positionalArguments == null) {
            this.messageStream.println("ERROR: Invalid argument '" + string + "'.");
            return false;
        }
        try {
            object = this.constructFromString(this.getUnderlyingType(this.positionalArguments), string);
        }
        catch (CommandLineParseException commandLineParseException) {
            this.messageStream.println("ERROR: " + commandLineParseException.getMessage());
            return false;
        }
        try {
            collection = (Collection)this.positionalArguments.get(this.callerOptions);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        if (collection.size() >= this.maxPositionalArguments) {
            this.messageStream.println("ERROR: No more than " + this.maxPositionalArguments + " positional arguments may be specified on the command line.");
            return false;
        }
        collection.add(object);
        return true;
    }

    private boolean parseOption(String string, String string2, boolean bl) {
        return this.parseOption(string, string2, bl, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean parseOption(String string, String string2, boolean bl, boolean bl2) {
        Object object;
        Integer n;
        if ((string = string.toUpperCase()).equals(OPTIONS_FILE)) {
            this.commandLine = this.commandLine + " " + this.prefix + OPTIONS_FILE + "=" + string2;
            return this.parseOptionsFile(string2);
        }
        if (string.startsWith(PRECEDENCE_SYMBOL)) {
            string = string.substring(PRECEDENCE_SYMBOL.length());
            bl2 = true;
        }
        if ((n = Integer.valueOf(string.indexOf(46))) != -1) {
            String string3 = string.substring(0, n);
            String string4 = string.substring(n + 1);
            if (!string4.isEmpty()) {
                this.childOptionArguments.append(string3, new ChildOptionArg(string4, string2, bl, bl2));
                return true;
            }
            this.messageStream.println("ERROR: Unrecognized option: " + string);
            return false;
        }
        OptionDefinition optionDefinition = this.optionMap.get(string);
        if (optionDefinition == null) {
            if (bl) {
                return true;
            }
            this.messageStream.println("ERROR: Unrecognized option: " + string);
            return false;
        }
        if (this.optionsThatCannotBeOverridden.contains(optionDefinition.name)) {
            return true;
        }
        if (bl2) {
            this.optionsThatCannotBeOverridden.add(optionDefinition.name);
        }
        if (!optionDefinition.isCollection && optionDefinition.hasBeenSet && !optionDefinition.hasBeenSetFromOptionsFile) {
            this.messageStream.println("ERROR: Option '" + string + "' cannot be specified more than once.");
            return false;
        }
        try {
            if (string2.equals("null")) {
                if (!optionDefinition.optional) {
                    this.messageStream.println("ERROR: non-null value must be provided for '" + string + "'.");
                    return false;
                }
                object = null;
            } else {
                object = this.constructFromString(this.getUnderlyingType(optionDefinition.field), string2);
            }
        }
        catch (CommandLineParseException commandLineParseException) {
            this.messageStream.println("ERROR: " + commandLineParseException.getMessage());
            return false;
        }
        try {
            if (!optionDefinition.isCollection) {
                optionDefinition.field.set(this.callerOptions, object);
                optionDefinition.hasBeenSet = true;
                optionDefinition.hasBeenSetFromOptionsFile = bl;
                return true;
            }
            Collection collection = (Collection)optionDefinition.field.get(this.callerOptions);
            if (object == null) {
                collection.clear();
            } else {
                if (collection.size() >= optionDefinition.maxElements) {
                    this.messageStream.println("ERROR: Option '" + string + "' cannot be used more than " + optionDefinition.maxElements + " times.");
                    return false;
                }
                collection.add(object);
            }
            optionDefinition.hasBeenSet = true;
            optionDefinition.hasBeenSetFromOptionsFile = bl;
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean parseOptionsFile(String var1_1) {
        block8: {
            var2_2 = null;
            try {
                var2_2 = new BufferedReader(new FileReader(var1_1));
                while ((var3_3 = var2_2.readLine()) != null) {
                    if (var3_3.startsWith("#") || var3_3.trim().length() == 0) continue;
                    var4_5 = var3_3.split("=", 2);
                    if (var4_5.length == 2) {
                        if (this.parseOption(var4_5[0], var4_5[1], true)) continue;
                        this.messageStream.println();
                        this.usage(this.messageStream, true);
                        var5_7 = false;
                        break block8;
                    }
                    ** GOTO lbl-1000
                }
                ** GOTO lbl-1000
            }
            catch (IOException var3_4) {
                try {
                    throw new PicardException("I/O error loading OPTIONS_FILE=" + var1_1, var3_4);
                }
                catch (Throwable var6_9) {
                    CloserUtil.close(var2_2);
                    throw var6_9;
                }
            }
        }
        CloserUtil.close(var2_2);
        return var5_7;
lbl-1000:
        // 1 sources

        {
            this.messageStream.println("Strange line in OPTIONS_FILE " + var1_1 + ": " + var3_3);
            this.usage(this.messageStream, true);
            var5_8 = false;
        }
        CloserUtil.close(var2_2);
        return var5_8;
lbl-1000:
        // 1 sources

        {
            var2_2.close();
            var4_6 = true;
        }
        CloserUtil.close(var2_2);
        return var4_6;
    }

    private void printHtmlOptionUsage(PrintStream printStream, OptionDefinition optionDefinition) {
        String string = this.getUnderlyingType(optionDefinition.field).getSimpleName();
        String string2 = this.prefixDot + optionDefinition.name + "=" + string;
        printStream.println("<tr><td>" + string2 + "</td><td>" + CommandLineParser.htmlEscape(this.makeOptionDescription(optionDefinition)) + "</td></tr>");
    }

    private void printOptionUsage(PrintStream printStream, OptionDefinition optionDefinition) {
        this.printOptionParamUsage(printStream, optionDefinition.name, optionDefinition.shortName, this.getUnderlyingType(optionDefinition.field).getSimpleName(), this.makeOptionDescription(optionDefinition));
    }

    private void printOptionParamUsage(PrintStream printStream, String string, String string2, String string3, String string4) {
        String string5 = this.prefixDot + string;
        if (string3 != null) {
            string5 = string5 + "=" + string3;
        }
        printStream.print(string5);
        if (string2 != null && string2.length() > 0) {
            printStream.println();
            string5 = this.prefixDot + string2;
            if (string3 != null) {
                string5 = string5 + "=" + string3;
            }
            printStream.print(string5);
        }
        int n = 30 - string5.length();
        if (string5.length() > 30) {
            printStream.println();
            n = 30;
        }
        this.printSpaces(printStream, n);
        String string6 = StringUtil.wordWrap(string4, 90);
        String[] stringArray = string6.split("\n");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                this.printSpaces(printStream, 30);
            }
            printStream.println(stringArray[i]);
        }
        printStream.println();
    }

    private String makeOptionDescription(OptionDefinition optionDefinition) {
        Object[] objectArray;
        StringBuilder stringBuilder = new StringBuilder();
        if (optionDefinition.doc.length() > 0) {
            stringBuilder.append(optionDefinition.doc);
            stringBuilder.append("  ");
        }
        if (optionDefinition.optional && !optionDefinition.isCollection) {
            stringBuilder.append("Default value: ");
            stringBuilder.append(optionDefinition.defaultValue);
            stringBuilder.append(". ");
            if (!optionDefinition.defaultValue.equals("null")) {
                stringBuilder.append("This option can be set to 'null' to clear the default value. ");
            }
        } else if (!optionDefinition.isCollection) {
            stringBuilder.append("Required. ");
        }
        if ((objectArray = this.getUnderlyingType(optionDefinition.field).getEnumConstants()) == null && this.getUnderlyingType(optionDefinition.field) == Boolean.class) {
            objectArray = TRUE_FALSE_VALUES;
        }
        if (objectArray != null) {
            stringBuilder.append("Possible values: {");
            for (int i = 0; i < objectArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(objectArray[i].toString());
            }
            stringBuilder.append("} ");
        }
        if (optionDefinition.isCollection) {
            if (optionDefinition.minElements == 0) {
                if (optionDefinition.maxElements == Integer.MAX_VALUE) {
                    stringBuilder.append("This option may be specified 0 or more times. ");
                } else {
                    stringBuilder.append("This option must be specified no more than " + optionDefinition.maxElements + " times. ");
                }
            } else if (optionDefinition.maxElements == Integer.MAX_VALUE) {
                stringBuilder.append("This option must be specified at least " + optionDefinition.minElements + " times. ");
            } else {
                stringBuilder.append("This option may be specified between " + optionDefinition.minElements + " and " + optionDefinition.maxElements + " times. ");
            }
            if (!optionDefinition.defaultValue.equals("null")) {
                stringBuilder.append("This option can be set to 'null' to clear the default list. ");
            }
        }
        if (!optionDefinition.mutuallyExclusive.isEmpty()) {
            stringBuilder.append(" Cannot be used in conjuction with option(s)");
            for (String string : optionDefinition.mutuallyExclusive) {
                OptionDefinition optionDefinition2 = this.optionMap.get(string);
                if (optionDefinition2 == null) {
                    throw new PicardException("Invalid option definition in source code.  " + string + " doesn't match any known option.");
                }
                stringBuilder.append(" ").append(optionDefinition2.name);
                if (optionDefinition2.shortName.length() <= 0) continue;
                stringBuilder.append(" (").append(optionDefinition2.shortName).append(")");
            }
        }
        return stringBuilder.toString();
    }

    private void printSpaces(PrintStream printStream, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(" ");
        }
        printStream.print(stringBuilder);
    }

    private void handleOptionAnnotation(Field field) {
        try {
            field.setAccessible(true);
            Option option = field.getAnnotation(Option.class);
            boolean bl = this.isCollectionField(field);
            if (bl) {
                if (option.maxElements() == 0) {
                    throw new CommandLineParserDefinitionException("@Option member " + field.getName() + "has maxElements = 0");
                }
                if (option.minElements() > option.maxElements()) {
                    throw new CommandLineParserDefinitionException("In @Option member " + field.getName() + ", minElements cannot be > maxElements");
                }
                if (field.get(this.callerOptions) == null) {
                    this.createCollection(field, this.callerOptions, "@Option");
                }
            }
            if (!this.canBeMadeFromString(this.getUnderlyingType(field))) {
                throw new CommandLineParserDefinitionException("@Option member " + field.getName() + " must have a String ctor or be an enum");
            }
            OptionDefinition optionDefinition = new OptionDefinition(field, field.getName(), option.shortName(), option.doc(), option.optional() || field.get(this.callerOptions) != null, bl, option.minElements(), option.maxElements(), field.get(this.callerOptions), option.common(), option.mutex());
            for (String string : option.mutex()) {
                OptionDefinition optionDefinition2 = this.optionMap.get(string);
                if (optionDefinition2 == null) continue;
                optionDefinition2.mutuallyExclusive.add(field.getName());
            }
            if (this.optionMap.containsKey(optionDefinition.name)) {
                throw new CommandLineParserDefinitionException(optionDefinition.name + " has already been used");
            }
            this.optionMap.put(optionDefinition.name, optionDefinition);
            if (optionDefinition.shortName.length() > 0) {
                if (this.optionMap.containsKey(optionDefinition.shortName)) {
                    throw new CommandLineParserDefinitionException(optionDefinition.shortName + " has already been used");
                }
                this.optionMap.put(optionDefinition.shortName, optionDefinition);
            }
            this.optionDefinitions.add(optionDefinition);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CommandLineParserDefinitionException(field.getName() + " must have public visibility to have @Option annotation");
        }
    }

    private void handleUsageAnnotation(Field field) {
        if (this.usagePreamble != null) {
            throw new CommandLineParserDefinitionException("@Usage cannot be used more than once in an option class.");
        }
        try {
            field.setAccessible(true);
            this.usagePreamble = (String)field.get(this.callerOptions);
            Usage usage = field.getAnnotation(Usage.class);
            if (usage.programVersion().length() > 0) {
                this.programVersion = usage.programVersion();
                this.usagePreamble = this.usagePreamble + "Version: " + usage.programVersion() + "\n";
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CommandLineParserDefinitionException("@Usage data member must be public");
        }
        catch (ClassCastException classCastException) {
            throw new CommandLineParserDefinitionException("@Usage can only be applied to a String data member.");
        }
    }

    private void handlePositionalArgumentAnnotation(Field field) {
        if (this.positionalArguments != null) {
            throw new CommandLineParserDefinitionException("@PositionalArguments cannot be used more than once in an option class.");
        }
        field.setAccessible(true);
        this.positionalArguments = field;
        if (!this.isCollectionField(field)) {
            throw new CommandLineParserDefinitionException("@PositionalArguments must be applied to a Collection");
        }
        if (!this.canBeMadeFromString(this.getUnderlyingType(field))) {
            throw new CommandLineParserDefinitionException("@PositionalParameters member " + field.getName() + "does not have a String ctor");
        }
        PositionalArguments positionalArguments = field.getAnnotation(PositionalArguments.class);
        this.minPositionalArguments = positionalArguments.minElements();
        this.maxPositionalArguments = positionalArguments.maxElements();
        if (this.minPositionalArguments > this.maxPositionalArguments) {
            throw new CommandLineParserDefinitionException("In @PositionalArguments, minElements cannot be > maxElements");
        }
        try {
            if (field.get(this.callerOptions) == null) {
                this.createCollection(field, this.callerOptions, "@PositionalParameters");
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CommandLineParserDefinitionException(field.getName() + " must have public visibility to have @PositionalParameters annotation");
        }
    }

    private void handleNestedOptionsAnnotation(Field field) {
        field.setAccessible(true);
        try {
            this.childOptionsMap.put(field.getName(), new CommandLineParser(field.get(this.callerOptions), this.prefixDot + field.getName()));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CommandLineParserDefinitionException("Should never happen.", illegalAccessException);
        }
    }

    private boolean isCollectionField(Field field) {
        try {
            field.getType().asSubclass(Collection.class);
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    private void createCollection(Field field, Object object, String string) throws IllegalAccessException {
        try {
            field.set(object, field.getType().newInstance());
        }
        catch (Exception exception) {
            try {
                field.set(object, new ArrayList());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new CommandLineParserDefinitionException("In collection " + string + " member " + field.getName() + " cannot be constructed or auto-initialized with ArrayList, so collection must be initialized explicitly.");
            }
        }
    }

    private Class getUnderlyingType(Field field) {
        if (this.isCollectionField(field)) {
            ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
            Type[] typeArray = parameterizedType.getActualTypeArguments();
            if (typeArray.length != 1) {
                throw new CommandLineParserDefinitionException("Strange collection type for field " + field.getName());
            }
            return (Class)typeArray[0];
        }
        Class<?> clazz = field.getType();
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        return clazz;
    }

    private boolean canBeMadeFromString(Class clazz) {
        if (clazz.isEnum()) {
            return true;
        }
        try {
            clazz.getConstructor(String.class);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    private Object constructFromString(Class clazz, String string) {
        try {
            if (clazz.isEnum()) {
                try {
                    return Enum.valueOf(clazz, string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new CommandLineParseException("'" + string + "' is not a valid value for " + clazz.getSimpleName() + ".", illegalArgumentException);
                }
            }
            Constructor constructor = clazz.getConstructor(String.class);
            return constructor.newInstance(string);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new CommandLineParseException("Cannot find string ctor for " + clazz.getName(), noSuchMethodException);
        }
        catch (InstantiationException instantiationException) {
            throw new CommandLineParseException("Abstract class '" + clazz.getSimpleName() + "'cannot be used for an option value type.", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CommandLineParseException("String constructor for option value type '" + clazz.getSimpleName() + "' must be public.", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new CommandLineParseException("Problem constructing " + clazz.getSimpleName() + " from the string '" + string + "'.", invocationTargetException.getCause());
        }
    }

    public String[] getArgv() {
        return this.argv;
    }

    private boolean parseChildOptions() {
        Object object;
        if (this.isCommandLineProgram()) {
            CommandLineProgram commandLineProgram = (CommandLineProgram)this.callerOptions;
            for (Map.Entry object2 : commandLineProgram.getNestedOptions().entrySet()) {
                if (((String)object2.getKey()).contains(".")) {
                    throw new IllegalArgumentException("Prefix for nested options should not contain period: " + (String)object2.getKey());
                }
                this.childOptionsMap.put((String)object2.getKey(), new CommandLineParser(object2.getValue(), this.prefixDot + (String)object2.getKey()));
            }
        }
        boolean bl = true;
        for (String string : this.childOptionArguments.keySet()) {
            if (this.childOptionsMap.containsKey(string)) continue;
            this.messageStream.println("ERROR: Option prefix '" + string + "' is not valid.");
            bl = false;
        }
        try {
            for (OptionDefinition optionDefinition : this.optionDefinitions) {
                if (optionDefinition.isCollection || (object = optionDefinition.field.get(this.callerOptions)) == null) continue;
                for (CommandLineParser commandLineParser : this.childOptionsMap.values()) {
                    this.maybePropagateValueToChild(commandLineParser, optionDefinition, object);
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Should never happen", illegalAccessException);
        }
        for (Map.Entry entry : this.childOptionsMap.entrySet()) {
            object = (String)entry.getKey();
            CommandLineParser commandLineParser = (CommandLineParser)entry.getValue();
            commandLineParser.messageStream = this.messageStream;
            Collection collection = (Collection)this.childOptionArguments.get(object);
            if (collection != null) {
                for (ChildOptionArg childOptionArg : collection) {
                    super.parseOption(childOptionArg.name, childOptionArg.value, childOptionArg.fromFile, childOptionArg.precedenceSet);
                }
            }
            if (!super.checkNumArguments()) {
                bl = false;
            }
            if (!super.parseChildOptions()) {
                bl = false;
            }
            this.commandLine = this.commandLine + " " + commandLineParser.getCommandLine();
        }
        return bl;
    }

    private void maybePropagateValueToChild(CommandLineParser commandLineParser, OptionDefinition optionDefinition, Object object) {
        try {
            Object object2;
            OptionDefinition optionDefinition2 = commandLineParser.optionMap.get(optionDefinition.name);
            if (optionDefinition2 != null && ((object2 = optionDefinition2.field.get(commandLineParser.callerOptions)) == null || optionDefinition.hasBeenSet)) {
                optionDefinition2.field.set(commandLineParser.callerOptions, object);
                optionDefinition2.hasBeenSetFromParent = true;
                optionDefinition2.hasBeenSetFromOptionsFile = optionDefinition.hasBeenSetFromOptionsFile;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Should never happen", illegalAccessException);
        }
    }

    public String getProgramVersion() {
        return this.programVersion;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    private static class ChildOptionArg {
        final String name;
        final String value;
        final boolean fromFile;
        final boolean precedenceSet;

        private ChildOptionArg(String string, String string2, boolean bl, boolean bl2) {
            this.name = string;
            this.value = string2;
            this.fromFile = bl;
            this.precedenceSet = bl2;
        }
    }

    protected static class OptionDefinition {
        final Field field;
        final String name;
        final String shortName;
        final String doc;
        final boolean optional;
        final boolean isCollection;
        final int minElements;
        final int maxElements;
        final String defaultValue;
        final boolean isCommon;
        boolean hasBeenSet = false;
        boolean hasBeenSetFromOptionsFile = false;
        boolean hasBeenSetFromParent = false;
        final Set<String> mutuallyExclusive;

        private OptionDefinition(Field field, String string, String string2, String string3, boolean bl, boolean bl2, int n, int n2, Object object, boolean bl3, String[] stringArray) {
            this.field = field;
            this.name = string.toUpperCase();
            this.shortName = string2.toUpperCase();
            this.doc = string3;
            this.optional = bl;
            this.isCollection = bl2;
            this.minElements = n;
            this.maxElements = n2;
            this.defaultValue = object != null ? (this.isCollection && ((Collection)object).isEmpty() ? "null" : object.toString()) : "null";
            this.isCommon = bl3;
            this.mutuallyExclusive = new HashSet<String>(Arrays.asList(stringArray));
        }
    }
}

