/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype;

import java.io.File;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.molgenis.genotype.GenotypeDataException;
import org.molgenis.genotype.GenotypeFileType;
import org.molgenis.genotype.RandomAccessGenotypeData;
import org.molgenis.genotype.RandomAccessGenotypeDataReaderFormats;

public class GenotypeLoader {
    private static final Logger LOGGER = Logger.getLogger(GenotypeLoader.class);

    public static RandomAccessGenotypeData load(String ... paths) {
        return GenotypeLoader.load(Arrays.asList(paths));
    }

    private static EnumMap<GenotypeFileType, File> deterimeFileList(List<String> paths) {
        EnumMap<GenotypeFileType, File> files = new EnumMap<GenotypeFileType, File>(GenotypeFileType.class);
        EnumSet<GenotypeFileType> overridableFiles = EnumSet.copyOf(GenotypeFileType.getTrityperFileTypes());
        if (paths.isEmpty()) {
            LOGGER.debug((Object)"No paths to genotype data specified");
            throw new GenotypeDataException("No path to genotype data specified");
        }
        if (paths.size() == 1) {
            LOGGER.debug((Object)"One path for genotype data specified, checking if it is a prefix");
            String path = paths.get(0);
            File file = new File(path);
            if (!file.isDirectory()) {
                for (GenotypeFileType type : GenotypeFileType.values()) {
                    File file2 = new File(path + type.getSuffix());
                    if (!file2.exists()) continue;
                    LOGGER.debug((Object)("Detected " + type.getFriendlyName() + " file at: " + file2.getAbsolutePath()));
                    files.put(type, file2);
                }
            }
        }
        for (String path : paths) {
            File file = new File(path);
            if (file.isDirectory()) {
                LOGGER.debug((Object)"Genotype data path is directory");
                block2: for (File file3 : file.listFiles()) {
                    if (file3.getName().endsWith(".vcf.gz")) {
                        LOGGER.info((Object)("Genotype loader detected vcf.gz files in specified folder. Assuming " + RandomAccessGenotypeDataReaderFormats.VCF_FOLDER.getName() + ", " + RandomAccessGenotypeDataReaderFormats.VCF_FOLDER.getDescription()));
                        if (files.containsKey((Object)GenotypeFileType.VCF_FOLDER)) {
                            throw new GenotypeDataException("Detected second VCF folder. That is currently not supported");
                        }
                        files.put(GenotypeFileType.VCF_FOLDER, file);
                        continue;
                    }
                    for (GenotypeFileType trityerType : GenotypeFileType.getTrityperFileTypes()) {
                        if (files.containsKey((Object)trityerType)) continue;
                        if (file3.getName().equals(trityerType.getSuffix())) {
                            files.put(trityerType, file3);
                            continue block2;
                        }
                        if (trityerType == GenotypeFileType.TRITYPER_GENOTYPE || trityerType == GenotypeFileType.TRITYPER_DOSAGE || !file3.getName().equals(trityerType.getSuffix() + ".gz")) continue;
                        files.put(trityerType, file3);
                        continue block2;
                    }
                }
                continue;
            }
            if (file.exists()) {
                for (GenotypeFileType genotypeFileType : GenotypeFileType.values()) {
                    if (!genotypeFileType.matches(file)) continue;
                    LOGGER.debug((Object)("Found " + genotypeFileType.getFriendlyName() + " file at: " + file.getAbsolutePath()));
                    if (files.containsKey((Object)genotypeFileType) && !overridableFiles.contains((Object)genotypeFileType)) {
                        throw new GenotypeDataException("Found " + genotypeFileType.getFriendlyName() + " file twice. First at: " + files.get((Object)genotypeFileType).getAbsolutePath() + " and then again at: " + file.getAbsolutePath());
                    }
                    files.put(genotypeFileType, file);
                    overridableFiles.remove((Object)genotypeFileType);
                }
                continue;
            }
            if (paths.size() == 1) continue;
            throw new GenotypeDataException("No genotype file found at: " + file.getAbsolutePath());
        }
        if (files.containsKey((Object)GenotypeFileType.SAMPLE) && !files.containsKey((Object)GenotypeFileType.HAPS) && !files.containsKey((Object)GenotypeFileType.GEN) && files.containsKey((Object)GenotypeFileType.UNKNOWN)) {
            LOGGER.info((Object)("Found a file without an extention and and an " + GenotypeFileType.SAMPLE.getFriendlyName() + " file. Assuming that this file: " + files.get((Object)GenotypeFileType.UNKNOWN) + " is a " + GenotypeFileType.GEN.getFriendlyName() + " file"));
            files.put(GenotypeFileType.GEN, files.remove((Object)GenotypeFileType.UNKNOWN));
        }
        return files;
    }

    public static RandomAccessGenotypeData load(List<String> paths) {
        EnumMap<GenotypeFileType, File> files = GenotypeLoader.deterimeFileList(paths);
        RandomAccessGenotypeDataReaderFormats identifiedFormat = null;
        for (RandomAccessGenotypeDataReaderFormats format : RandomAccessGenotypeDataReaderFormats.values()) {
            if (!files.keySet().containsAll(format.getRequiredFiles()) || identifiedFormat == null) continue;
            throw new GenotypeDataException("Unable to unambiguously identify the genotype file format. Could be: " + identifiedFormat.getName() + " or " + format.getName() + " based on the identified files");
        }
        if (identifiedFormat != null) {
            // empty if block
        }
        return null;
    }

    public static RandomAccessGenotypeData loadFormat(String format, String ... paths) {
        return null;
    }

    public static RandomAccessGenotypeData loadFormat(RandomAccessGenotypeDataReaderFormats format, String ... paths) {
        return null;
    }
}

