/*
 * Decompiled with CFR 0.152.
 */
package nl.umcg.deelenp.genotypeharmonizer;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.molgenis.genotype.variant.GeneticVariant;

public class SnpLogWriter
implements Closeable {
    private final BufferedWriter snpLogWriter;

    public SnpLogWriter(File snpLogFile) throws IOException {
        this.snpLogWriter = new BufferedWriter(new FileWriter(snpLogFile));
        this.snpLogWriter.append("chr\tpos\tid\talleles\taction\tmessage\n");
    }

    public void addToLog(GeneticVariant variant, Actions action, String message) throws IOException {
        this.snpLogWriter.append(variant.getSequenceName());
        this.snpLogWriter.append('\t');
        this.snpLogWriter.append(String.valueOf(variant.getStartPos()));
        this.snpLogWriter.append('\t');
        this.snpLogWriter.append(variant.getPrimaryVariantId());
        this.snpLogWriter.append('\t');
        this.snpLogWriter.append(variant.getVariantAlleles().toString());
        this.snpLogWriter.append('\t');
        this.snpLogWriter.append(action.getActionString());
        this.snpLogWriter.append('\t');
        this.snpLogWriter.append(message);
        this.snpLogWriter.append('\n');
    }

    @Override
    public void close() throws IOException {
        this.snpLogWriter.close();
    }

    public static enum Actions {
        EXCLUDED("Excluded"),
        SWAPPED("Swapped"),
        MAINTAINED("Maintained");

        private String actionString;

        private Actions(String actionString) {
            this.actionString = actionString;
        }

        public String getActionString() {
            return this.actionString;
        }
    }
}

