/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import net.sf.samtools.SAMException;
import org.xerial.snappy.SnappyInputStream;

public class SnappyLoader {
    private static final int SNAPPY_BLOCK_SIZE = 32768;
    private final Constructor<InputStream> SnappyInputStreamCtor;
    private final Constructor<OutputStream> SnappyOutputStreamCtor;
    public final boolean SnappyAvailable;
    private final SnappyInputStream ignoreMe = null;
    private static final boolean DefaultVerbosity = Boolean.valueOf(System.getProperty("snappy.loader.verbosity", "false"));

    public SnappyLoader() {
        this(DefaultVerbosity);
    }

    public SnappyLoader(boolean bl) {
        Constructor<?> constructor = null;
        Constructor<?> constructor2 = null;
        Class<?> clazz = null;
        if (Boolean.valueOf(System.getProperty("snappy.disable", "false")).booleanValue()) {
            System.err.println("Snappy is disabled via system property.");
        } else {
            try {
                Class<?> clazz2 = Class.forName("org.xerial.snappy.SnappyInputStream");
                Class<?> clazz3 = Class.forName("org.xerial.snappy.SnappyOutputStream");
                clazz = Class.forName("org.xerial.snappy.SnappyError");
                constructor = clazz2.getConstructor(InputStream.class);
                constructor2 = clazz3.getConstructor(OutputStream.class, Integer.TYPE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        this.SnappyInputStreamCtor = constructor;
        this.SnappyOutputStreamCtor = constructor2;
        if (this.SnappyInputStreamCtor != null && this.SnappyOutputStreamCtor != null) {
            boolean bl2;
            try {
                if (!org.xerial.snappy.SnappyLoader.isNativeLibraryLoaded()) {
                    if (bl) {
                        System.err.println("Snappy dll failed to load.");
                    }
                    bl2 = false;
                } else {
                    if (bl) {
                        System.err.println("Snappy stream classes loaded.");
                    }
                    bl2 = true;
                }
            }
            catch (Error error) {
                if (error.getClass().equals(clazz)) {
                    if (bl) {
                        System.err.println("Snappy dll failed to load: " + error.getMessage());
                    }
                    bl2 = false;
                }
                throw error;
            }
            this.SnappyAvailable = bl2;
        } else {
            if (bl) {
                System.err.println("Snappy stream classes not loaded.");
            }
            this.SnappyAvailable = false;
        }
    }

    public InputStream wrapInputStream(InputStream inputStream) {
        try {
            return this.SnappyInputStreamCtor.newInstance(inputStream);
        }
        catch (Exception exception) {
            throw new SAMException("Error instantiating SnappyInputStream", exception);
        }
    }

    public OutputStream wrapOutputStream(OutputStream outputStream) {
        try {
            return this.SnappyOutputStreamCtor.newInstance(outputStream, 32768);
        }
        catch (Exception exception) {
            throw new SAMException("Error instantiating SnappyOutputStream", exception);
        }
    }
}

