/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble;

import java.io.IOException;
import java.util.regex.Pattern;
import org.broad.tribble.AbstractFeatureCodec;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodecHeader;
import org.broad.tribble.readers.AsciiLineReader;
import org.broad.tribble.readers.LineReader;
import org.broad.tribble.readers.PositionalBufferedStream;
import org.broad.tribble.util.ParsingUtils;

public abstract class AsciiFeatureCodec<T extends Feature>
extends AbstractFeatureCodec<T> {
    private final AsciiLineReader lineReader = new AsciiLineReader();
    protected Pattern splitPattern = Pattern.compile("\\t");

    protected AsciiFeatureCodec(Class<T> clazz) {
        super(clazz);
    }

    @Override
    public Feature decodeLoc(PositionalBufferedStream positionalBufferedStream) throws IOException {
        String string = this.readLine(positionalBufferedStream);
        try {
            return this.decodeLoc(string);
        }
        catch (RuntimeException runtimeException) {
            String string2 = "\nLine: " + string;
            throw new RuntimeException(string2, runtimeException);
        }
    }

    @Override
    public T decode(PositionalBufferedStream positionalBufferedStream) throws IOException {
        String string = this.readLine(positionalBufferedStream);
        try {
            return this.decode(string);
        }
        catch (RuntimeException runtimeException) {
            String string2 = "\nLine: " + string;
            throw new RuntimeException(string2, runtimeException);
        }
    }

    @Override
    public FeatureCodecHeader readHeader(PositionalBufferedStream positionalBufferedStream) throws IOException {
        AsciiLineReader asciiLineReader = new AsciiLineReader(positionalBufferedStream);
        return new FeatureCodecHeader(this.readHeader(asciiLineReader), 0L);
    }

    private final String readLine(PositionalBufferedStream positionalBufferedStream) throws IOException {
        return this.lineReader.readLine(positionalBufferedStream);
    }

    public Feature decodeLoc(String string) {
        return this.decode(string);
    }

    public T decode(String[] stringArray) {
        String string = ParsingUtils.join("\t", stringArray);
        return this.decode(string);
    }

    public abstract T decode(String var1);

    public Object readHeader(LineReader lineReader) {
        return null;
    }
}

