/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.io.File;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sf.picard.PicardException;
import net.sf.picard.util.TabbedInputParser;
import net.sf.samtools.util.CloseableIterator;

public class TabbedTextFileWithHeaderParser
implements Iterable<Row> {
    private final Map<String, Integer> columnLabelIndices = new HashMap<String, Integer>();
    private final TabbedInputParser parser;
    private TheIterator extantIterator;

    public TabbedTextFileWithHeaderParser(TabbedInputParser tabbedInputParser) {
        this.parser = tabbedInputParser;
        if (!tabbedInputParser.hasNext()) {
            throw new PicardException("No header line found in file " + tabbedInputParser.getFileName());
        }
        String[] stringArray = (String[])tabbedInputParser.next();
        for (int i = 0; i < stringArray.length; ++i) {
            this.columnLabelIndices.put(stringArray[i], i);
        }
    }

    public TabbedTextFileWithHeaderParser(File file) {
        this(new TabbedInputParser(false, file));
    }

    public TabbedTextFileWithHeaderParser(File file, String[] stringArray) {
        this.parser = new TabbedInputParser(false, file);
        if (!this.parser.hasNext()) {
            throw new PicardException("No header line found in file " + file);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.columnLabelIndices.put(stringArray[i], i);
        }
    }

    public boolean hasColumn(String string) {
        return this.columnLabelIndices.containsKey(string);
    }

    public Set<String> columnLabels() {
        return this.columnLabelIndices.keySet();
    }

    @Override
    public CloseableIterator<Row> iterator() {
        if (this.extantIterator != null) {
            throw new ConcurrentModificationException("Only one iterator allowed at a time.");
        }
        this.extantIterator = new TheIterator();
        return this.extantIterator;
    }

    public void close() {
        this.parser.close();
    }

    public int getCurrentLineNumber() {
        return this.parser.getCurrentLineNumber();
    }

    public Set<String> getColumnNames() {
        return Collections.unmodifiableSet(this.columnLabelIndices.keySet());
    }

    class TheIterator
    implements CloseableIterator<Row> {
        TheIterator() {
        }

        @Override
        public boolean hasNext() {
            return TabbedTextFileWithHeaderParser.this.parser.hasNext();
        }

        @Override
        public Row next() {
            String[] stringArray = (String[])TabbedTextFileWithHeaderParser.this.parser.next();
            String string = TabbedTextFileWithHeaderParser.this.parser.getCurrentLine();
            return new Row(stringArray, string);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
            TabbedTextFileWithHeaderParser.this.extantIterator = null;
        }
    }

    public class Row {
        private final String[] fields;
        private final String currentLine;

        Row(String[] stringArray, String string) {
            this.fields = stringArray;
            this.currentLine = string;
        }

        public String[] getFields() {
            return this.fields;
        }

        public String getField(String string) {
            return this.fields[(Integer)TabbedTextFileWithHeaderParser.this.columnLabelIndices.get(string)];
        }

        public Integer getIntegerField(String string) {
            if (this.fields[(Integer)TabbedTextFileWithHeaderParser.this.columnLabelIndices.get(string)] == null) {
                return null;
            }
            return Integer.parseInt(this.fields[(Integer)TabbedTextFileWithHeaderParser.this.columnLabelIndices.get(string)]);
        }

        public String getCurrentLine() {
            return this.currentLine;
        }
    }
}

