/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.util.Iterator;
import net.sf.picard.PicardException;
import net.sf.picard.util.AbstractIterator;
import net.sf.samtools.util.CloseableIterator;

public abstract class AbstractInputParser
extends AbstractIterator<String[]>
implements Iterable<String[]>,
CloseableIterator<String[]> {
    private boolean treatGroupedDelimitersAsOne = true;
    private int wordCount = 0;
    private boolean skipBlankLines = true;

    @Override
    public abstract void close();

    protected abstract byte[] readNextLine();

    public abstract String getFileName();

    @Override
    public Iterator<String[]> iterator() {
        if (this.isIterating()) {
            throw new IllegalStateException("iterator() method can only be called once, before thefirst call to hasNext()");
        }
        this.hasNext();
        return this;
    }

    @Override
    protected String[] advance() {
        byte[] byArray;
        while ((byArray = this.readNextLine()) != null && (this.skipBlankLines && this.isBlank(byArray) || this.isComment(byArray))) {
        }
        return byArray == null ? null : this.parseLine(byArray);
    }

    private String[] parseLine(byte[] byArray) {
        if (this.getWordCount() == 0) {
            this.calculateWordCount(byArray);
        }
        String[] stringArray = new String[this.getWordCount()];
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        try {
            for (int i = 0; i < byArray.length; ++i) {
                if (this.isDelimiter(byArray[i])) {
                    if (!bl) {
                        stringArray[n++] = new String(byArray, n2, i - n2);
                    } else if (!this.isTreatGroupedDelimitersAsOne()) {
                        stringArray[n++] = null;
                    }
                    bl = true;
                    continue;
                }
                if (bl) {
                    n2 = i;
                }
                bl = false;
            }
            if (!bl) {
                stringArray[n] = new String(byArray, n2, byArray.length - n2);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new PicardException("Unexpected number of elements found when parsing file " + this.getFileName() + ": " + n + ".  Expected a maximum of " + this.getWordCount() + " elements per line:" + new String(byArray, 0, byArray.length));
        }
        return stringArray;
    }

    protected void calculateWordCount(byte[] byArray) {
        int n = 0;
        boolean bl = true;
        for (byte by : byArray) {
            if (this.isDelimiter(by)) {
                if (bl && !this.isTreatGroupedDelimitersAsOne()) {
                    ++n;
                }
                bl = true;
                continue;
            }
            if (bl) {
                ++n;
            }
            bl = false;
        }
        if (bl && !this.isTreatGroupedDelimitersAsOne()) {
            ++n;
        }
        this.setWordCount(n);
    }

    protected boolean isComment(byte[] byArray) {
        return byArray.length > 0 && byArray[0] == 35;
    }

    protected boolean isBlank(byte[] byArray) {
        return byArray.length == 0;
    }

    protected boolean isDelimiter(byte by) {
        return by == 32 || by == 9;
    }

    protected int getWordCount() {
        return this.wordCount;
    }

    protected void setWordCount(int n) {
        this.wordCount = n;
    }

    protected boolean isTreatGroupedDelimitersAsOne() {
        return this.treatGroupedDelimitersAsOne;
    }

    protected void setTreatGroupedDelimitersAsOne(boolean bl) {
        this.treatGroupedDelimitersAsOne = bl;
    }

    protected boolean isSkipBlankLines() {
        return this.skipBlankLines;
    }

    protected void setSkipBlankLines(boolean bl) {
        this.skipBlankLines = bl;
    }
}

