/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.picard.PicardException;
import net.sf.picard.sam.ReadEnds;
import net.sf.samtools.util.SortingCollection;

class ReadEndsCodec
implements SortingCollection.Codec<ReadEnds> {
    private DataInputStream in;
    private DataOutputStream out;

    ReadEndsCodec() {
    }

    @Override
    public SortingCollection.Codec<ReadEnds> clone() {
        return new ReadEndsCodec();
    }

    @Override
    public void setOutputStream(OutputStream outputStream) {
        this.out = new DataOutputStream(outputStream);
    }

    @Override
    public void setInputStream(InputStream inputStream) {
        this.in = new DataInputStream(inputStream);
    }

    public DataInputStream getInputStream() {
        return this.in;
    }

    public DataOutputStream getOutputStream() {
        return this.out;
    }

    @Override
    public void encode(ReadEnds readEnds) {
        try {
            this.out.writeShort(readEnds.score);
            this.out.writeShort(readEnds.libraryId);
            this.out.writeByte(readEnds.orientation);
            this.out.writeInt(readEnds.read1Sequence);
            this.out.writeInt(readEnds.read1Coordinate);
            this.out.writeLong(readEnds.read1IndexInFile);
            this.out.writeInt(readEnds.read2Sequence);
            if (readEnds.orientation > 1) {
                this.out.writeInt(readEnds.read2Coordinate);
                this.out.writeLong(readEnds.read2IndexInFile);
            }
            this.out.writeShort(readEnds.readGroup);
            this.out.writeByte(readEnds.tile);
            this.out.writeShort(readEnds.x);
            this.out.writeShort(readEnds.y);
        }
        catch (IOException iOException) {
            throw new PicardException("Exception writing ReadEnds to file.", iOException);
        }
    }

    @Override
    public ReadEnds decode() {
        ReadEnds readEnds = new ReadEnds();
        try {
            try {
                readEnds.score = this.in.readShort();
            }
            catch (EOFException eOFException) {
                return null;
            }
            readEnds.libraryId = this.in.readShort();
            readEnds.orientation = this.in.readByte();
            readEnds.read1Sequence = this.in.readInt();
            readEnds.read1Coordinate = this.in.readInt();
            readEnds.read1IndexInFile = this.in.readLong();
            readEnds.read2Sequence = this.in.readInt();
            if (readEnds.orientation > 1) {
                readEnds.read2Coordinate = this.in.readInt();
                readEnds.read2IndexInFile = this.in.readLong();
            }
            readEnds.readGroup = this.in.readShort();
            readEnds.tile = this.in.readByte();
            readEnds.x = this.in.readShort();
            readEnds.y = this.in.readShort();
            return readEnds;
        }
        catch (IOException iOException) {
            throw new PicardException("Exception writing ReadEnds to file.", iOException);
        }
    }
}

