/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import net.sf.picard.PicardException;
import net.sf.picard.filter.SamRecordFilter;
import net.sf.picard.io.IoUtil;
import net.sf.picard.reference.ReferenceSequenceFileWalker;
import net.sf.picard.sam.MultiHitAlignedReadIterator;
import net.sf.picard.sam.PrimaryAlignmentSelectionStrategy;
import net.sf.picard.sam.ReservedTagConstants;
import net.sf.picard.sam.SamPairUtil;
import net.sf.picard.util.CigarUtil;
import net.sf.picard.util.Log;
import net.sf.samtools.BAMRecordCodec;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMProgramRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordCoordinateComparator;
import net.sf.samtools.SAMRecordIterator;
import net.sf.samtools.SAMRecordQueryNameComparator;
import net.sf.samtools.SAMRecordUtil;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.SAMTag;
import net.sf.samtools.SAMUtils;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.SequenceUtil;
import net.sf.samtools.util.SortingCollection;

public abstract class AbstractAlignmentMerger {
    public static final int MAX_RECORDS_IN_RAM = 500000;
    private static final char[] RESERVED_ATTRIBUTE_STARTS = new char[]{'X', 'Y', 'Z'};
    private final NumberFormat FMT = new DecimalFormat("#,###");
    private final Log log = Log.getInstance(AbstractAlignmentMerger.class);
    private final File unmappedBamFile;
    private final File targetBamFile;
    private final SAMSequenceDictionary sequenceDictionary;
    private ReferenceSequenceFileWalker refSeq = null;
    private final boolean clipAdapters;
    private final boolean bisulfiteSequence;
    private SAMProgramRecord programRecord;
    private final boolean alignedReadsOnly;
    private final SAMFileHeader header;
    private final List<String> attributesToRetain = new ArrayList<String>();
    private final File referenceFasta;
    private final Integer read1BasesTrimmed;
    private final Integer read2BasesTrimmed;
    private final List<SamPairUtil.PairOrientation> expectedOrientations;
    private final SAMFileHeader.SortOrder sortOrder;
    private MultiHitAlignedReadIterator alignedIterator = null;
    private boolean clipOverlappingReads = true;
    private int maxRecordsInRam = 500000;
    private final PrimaryAlignmentSelectionStrategy primaryAlignmentSelectionStrategy;
    private boolean keepAlignerProperPairFlags = false;
    private final SamRecordFilter alignmentFilter = new SamRecordFilter(){

        @Override
        public boolean filterOut(SAMRecord sAMRecord) {
            return AbstractAlignmentMerger.this.ignoreAlignment(sAMRecord);
        }

        @Override
        public boolean filterOut(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
            throw new UnsupportedOperationException("Paired SamRecordFilter not implemented!");
        }
    };

    protected abstract CloseableIterator<SAMRecord> getQuerynameSortedAlignedRecords();

    protected boolean ignoreAlignment(SAMRecord sAMRecord) {
        return false;
    }

    public AbstractAlignmentMerger(File file, File file2, File file3, boolean bl, boolean bl2, boolean bl3, SAMProgramRecord sAMProgramRecord, List<String> list, Integer n, Integer n2, List<SamPairUtil.PairOrientation> list2, SAMFileHeader.SortOrder sortOrder, PrimaryAlignmentSelectionStrategy primaryAlignmentSelectionStrategy) {
        IoUtil.assertFileIsReadable(file);
        IoUtil.assertFileIsWritable(file2);
        IoUtil.assertFileIsReadable(file3);
        this.unmappedBamFile = file;
        this.targetBamFile = file2;
        this.referenceFasta = file3;
        this.refSeq = new ReferenceSequenceFileWalker(file3);
        this.sequenceDictionary = this.refSeq.getSequenceDictionary();
        if (this.sequenceDictionary == null) {
            throw new PicardException("No sequence dictionary found for " + file3.getAbsolutePath() + ".  Use CreateSequenceDictionary.jar to create a sequence dictionary.");
        }
        this.clipAdapters = bl;
        this.bisulfiteSequence = bl2;
        this.alignedReadsOnly = bl3;
        this.header = new SAMFileHeader();
        this.sortOrder = sortOrder != null ? sortOrder : SAMFileHeader.SortOrder.coordinate;
        this.header.setSortOrder(SAMFileHeader.SortOrder.coordinate);
        if (sAMProgramRecord != null) {
            this.setProgramRecord(sAMProgramRecord);
        }
        this.header.setSequenceDictionary(this.sequenceDictionary);
        if (list != null) {
            this.attributesToRetain.addAll(list);
        }
        this.read1BasesTrimmed = n;
        this.read2BasesTrimmed = n2;
        this.expectedOrientations = list2;
        this.primaryAlignmentSelectionStrategy = primaryAlignmentSelectionStrategy;
    }

    public void setMaxRecordsInRam(int n) {
        this.maxRecordsInRam = n;
    }

    private void maybeSetPgTag(SAMRecord sAMRecord) {
        if (this.programRecord != null) {
            sAMRecord.setAttribute(ReservedTagConstants.PROGRAM_GROUP_ID, (Object)this.programRecord.getProgramGroupId());
        }
    }

    public void mergeAlignment() {
        Object object;
        int n;
        Object object2;
        SAMFileReader sAMFileReader = new SAMFileReader(this.unmappedBamFile);
        SAMRecordIterator sAMRecordIterator = sAMFileReader.iterator();
        this.header.setReadGroups(sAMFileReader.getFileHeader().getReadGroups());
        int n2 = 0;
        int n3 = 0;
        this.alignedIterator = new MultiHitAlignedReadIterator(this.getQuerynameSortedAlignedRecords(), this.primaryAlignmentSelectionStrategy);
        MultiHitAlignedReadIterator.HitsForInsert hitsForInsert = this.nextAligned();
        SortingCollection<SAMRecord> sortingCollection = SortingCollection.newInstance(SAMRecord.class, new BAMRecordCodec(this.header), new SAMRecordCoordinateComparator(), 500000);
        while (sAMRecordIterator.hasNext()) {
            SAMRecord sAMRecord = (SAMRecord)sAMRecordIterator.next();
            sAMRecord.setHeader(this.header);
            this.maybeSetPgTag(sAMRecord);
            if (sAMRecord.getReadPairedFlag()) {
                object2 = (SAMRecord)sAMRecordIterator.next();
                ((SAMRecord)object2).setHeader(this.header);
                this.maybeSetPgTag((SAMRecord)object2);
                if (!sAMRecord.getReadName().equals(((SAMRecord)object2).getReadName())) {
                    throw new PicardException("Second read from pair not found in unmapped bam: " + sAMRecord.getReadName() + ", " + ((SAMRecord)object2).getReadName());
                }
                if (!sAMRecord.getFirstOfPairFlag()) {
                    throw new PicardException("First record in unmapped bam is not first of pair: " + sAMRecord.getReadName());
                }
                if (!((SAMRecord)object2).getReadPairedFlag()) {
                    throw new PicardException("Second record in unmapped bam is not marked as paired: " + ((SAMRecord)object2).getReadName());
                }
                if (!((SAMRecord)object2).getSecondOfPairFlag()) {
                    throw new PicardException("Second record in unmapped bam is not second of pair: " + ((SAMRecord)object2).getReadName());
                }
            } else {
                object2 = null;
            }
            if (hitsForInsert != null && sAMRecord.getReadName().equals(hitsForInsert.getReadName())) {
                SAMRecord sAMRecord2;
                int n4;
                int n5 = n = hitsForInsert.numHits() > 1 ? 1 : 0;
                if (sAMRecord.getReadPairedFlag()) {
                    for (n4 = 0; n4 < hitsForInsert.numHits(); ++n4) {
                        if (n != 0) {
                            sAMRecord2 = this.clone(sAMRecord);
                            object = this.clone((SAMRecord)object2);
                        } else {
                            sAMRecord2 = sAMRecord;
                            object = object2;
                        }
                        SAMRecord sAMRecord3 = hitsForInsert.getFirstOfPair(n4);
                        SAMRecord sAMRecord4 = hitsForInsert.getSecondOfPair(n4);
                        boolean bl = sAMRecord3 != null && !sAMRecord3.getNotPrimaryAlignmentFlag() || sAMRecord4 != null && !sAMRecord4.getNotPrimaryAlignmentFlag();
                        this.transferAlignmentInfoToPairedRead(sAMRecord2, (SAMRecord)object, sAMRecord3, sAMRecord4);
                        if (!sAMRecord2.getReadUnmappedFlag() || bl) {
                            sortingCollection.add(sAMRecord2);
                            if (sAMRecord2.getReadUnmappedFlag()) {
                                ++n3;
                            } else {
                                ++n2;
                            }
                        }
                        if (((SAMRecord)object).getReadUnmappedFlag() && !bl) continue;
                        sortingCollection.add((SAMRecord)object);
                        if (!((SAMRecord)object).getReadUnmappedFlag()) {
                            ++n2;
                            continue;
                        }
                        ++n3;
                    }
                } else {
                    for (n4 = 0; n4 < hitsForInsert.numHits(); ++n4) {
                        sAMRecord2 = n != 0 ? this.clone(sAMRecord) : sAMRecord;
                        this.transferAlignmentInfoToFragment(sAMRecord2, hitsForInsert.getFragment(n4));
                        sortingCollection.add(sAMRecord2);
                        if (sAMRecord2.getReadUnmappedFlag()) {
                            ++n3;
                            continue;
                        }
                        ++n2;
                    }
                }
                hitsForInsert = this.nextAligned();
            } else {
                if (hitsForInsert != null && SAMRecordQueryNameComparator.compareReadNames(sAMRecord.getReadName(), hitsForInsert.getReadName()) > 0) {
                    throw new IllegalStateException("Aligned record iterator (" + hitsForInsert.getReadName() + ") is behind the unmapped reads (" + sAMRecord.getReadName() + ")");
                }
                if (!this.alignedReadsOnly) {
                    sortingCollection.add(sAMRecord);
                    ++n3;
                    if (object2 != null) {
                        sortingCollection.add((SAMRecord)object2);
                        ++n3;
                    }
                }
            }
            if ((n2 + n3) % 1000000 != 0) continue;
            this.log.info("Processed " + this.FMT.format(n2 + n3) + " records in query name order.");
        }
        sAMRecordIterator.close();
        if (this.alignedIterator.hasNext()) {
            throw new IllegalStateException("Reads remaining on alignment iterator: " + this.alignedIterator.next().getReadName() + "!");
        }
        this.alignedIterator.close();
        this.header.setSortOrder(this.sortOrder);
        boolean bl = this.sortOrder == SAMFileHeader.SortOrder.coordinate;
        object2 = new SAMFileWriterFactory().makeSAMOrBAMWriter(this.header, bl, this.targetBamFile);
        n = 0;
        for (SAMRecord sAMRecord2 : sortingCollection) {
            if (!sAMRecord2.getReadUnmappedFlag() && this.refSeq != null) {
                object = this.refSeq.get(this.sequenceDictionary.getSequenceIndex(sAMRecord2.getReferenceName())).getBases();
                sAMRecord2.setAttribute(SAMTag.NM.name(), (Object)SequenceUtil.calculateSamNmTag(sAMRecord2, (byte[])object, 0, this.bisulfiteSequence));
                if (sAMRecord2.getBaseQualities() != SAMRecord.NULL_QUALS) {
                    sAMRecord2.setAttribute(SAMTag.UQ.name(), (Object)SequenceUtil.sumQualitiesOfMismatches(sAMRecord2, (byte[])object, 0, this.bisulfiteSequence));
                }
            }
            object2.addAlignment(sAMRecord2);
            if (++n % 1000000 != 0) continue;
            this.log.info(this.FMT.format(n) + " SAMRecords written to " + this.targetBamFile.getName());
        }
        object2.close();
        sortingCollection.cleanup();
        this.log.info("Wrote " + n2 + " alignment records and " + (this.alignedReadsOnly ? 0 : n3) + " unmapped reads.");
    }

    private SAMRecord clone(SAMRecord sAMRecord) {
        try {
            return (SAMRecord)sAMRecord.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new PicardException("Should never happen.");
        }
    }

    private MultiHitAlignedReadIterator.HitsForInsert nextAligned() {
        while (this.alignedIterator.hasNext()) {
            MultiHitAlignedReadIterator.HitsForInsert hitsForInsert = this.alignedIterator.next();
            hitsForInsert.filterReads(this.alignmentFilter, this.primaryAlignmentSelectionStrategy);
            if (hitsForInsert.numHits() <= 0) continue;
            return hitsForInsert;
        }
        return null;
    }

    private void transferAlignmentInfoToFragment(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
        this.setValuesFromAlignment(sAMRecord, sAMRecord2);
        this.updateCigarForTrimmedOrClippedBases(sAMRecord, sAMRecord2);
        if (SAMUtils.cigarMapsNoBasesToRef(sAMRecord.getCigar())) {
            SAMUtils.makeReadUnmapped(sAMRecord);
        }
    }

    private void transferAlignmentInfoToPairedRead(SAMRecord sAMRecord, SAMRecord sAMRecord2, SAMRecord sAMRecord3, SAMRecord sAMRecord4) {
        if (sAMRecord3 != null) {
            this.transferAlignmentInfoToFragment(sAMRecord, sAMRecord3);
        }
        if (sAMRecord4 != null) {
            this.transferAlignmentInfoToFragment(sAMRecord2, sAMRecord4);
        }
        if (this.isClipOverlappingReads()) {
            this.clipForOverlappingReads(sAMRecord, sAMRecord2);
        }
        SamPairUtil.setMateInfo(sAMRecord2, sAMRecord, this.header);
        if (!this.keepAlignerProperPairFlags) {
            SamPairUtil.setProperPairFlags(sAMRecord2, sAMRecord, this.expectedOrientations);
        }
    }

    protected void clipForOverlappingReads(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
        if (!sAMRecord.getReadUnmappedFlag() && !sAMRecord2.getReadUnmappedFlag() && sAMRecord.getReadNegativeStrandFlag() != sAMRecord2.getReadNegativeStrandFlag()) {
            SAMRecord sAMRecord3;
            SAMRecord sAMRecord4 = sAMRecord.getReadNegativeStrandFlag() ? sAMRecord2 : sAMRecord;
            SAMRecord sAMRecord5 = sAMRecord3 = sAMRecord.getReadNegativeStrandFlag() ? sAMRecord : sAMRecord2;
            if (sAMRecord4.getAlignmentStart() < sAMRecord3.getAlignmentEnd()) {
                int n = sAMRecord4.getAlignmentEnd() - sAMRecord3.getAlignmentEnd();
                int n2 = sAMRecord4.getAlignmentStart() - sAMRecord3.getAlignmentStart();
                if (n > 0) {
                    CigarUtil.softClip3PrimeEndOfRead(sAMRecord4, Math.min(sAMRecord4.getReadLength(), sAMRecord4.getReadLength() - n + 1));
                }
                if (n2 > 0) {
                    CigarUtil.softClip3PrimeEndOfRead(sAMRecord3, Math.min(sAMRecord3.getReadLength(), sAMRecord3.getReadLength() - n2 + 1));
                }
            }
        }
    }

    protected void setValuesFromAlignment(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
        for (SAMRecord.SAMTagAndValue sAMTagAndValue : sAMRecord2.getAttributes()) {
            if (this.isReservedTag(sAMTagAndValue.tag) && !this.attributesToRetain.contains(sAMTagAndValue.tag)) continue;
            sAMRecord.setAttribute(sAMTagAndValue.tag, sAMTagAndValue.value);
        }
        sAMRecord.setReadUnmappedFlag(sAMRecord2.getReadUnmappedFlag());
        sAMRecord.setReferenceName(sAMRecord2.getReferenceName());
        sAMRecord.setAlignmentStart(sAMRecord2.getAlignmentStart());
        sAMRecord.setReadNegativeStrandFlag(sAMRecord2.getReadNegativeStrandFlag());
        sAMRecord.setNotPrimaryAlignmentFlag(sAMRecord2.getNotPrimaryAlignmentFlag());
        if (!sAMRecord2.getReadUnmappedFlag()) {
            sAMRecord.setCigar(sAMRecord2.getCigar());
            sAMRecord.setMappingQuality(sAMRecord2.getMappingQuality());
        }
        if (sAMRecord.getReadPairedFlag()) {
            sAMRecord.setProperPairFlag(sAMRecord2.getProperPairFlag());
        }
        if (sAMRecord.getReadNegativeStrandFlag()) {
            SAMRecordUtil.reverseComplement(sAMRecord);
        }
    }

    protected void updateCigarForTrimmedOrClippedBases(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
        int n;
        SAMSequenceRecord sAMSequenceRecord = sAMRecord.getHeader().getSequence(sAMRecord.getReferenceIndex());
        if (sAMRecord.getAlignmentEnd() > sAMSequenceRecord.getSequenceLength()) {
            n = sAMSequenceRecord.getSequenceLength() - sAMRecord.getAlignmentStart() + 1;
            List<CigarElement> list = CigarUtil.softClipEndOfRead(n, sAMRecord.getCigar().getCigarElements());
            sAMRecord.setCigar(new Cigar(list));
        }
        n = sAMRecord2.getReadLength();
        int n2 = sAMRecord.getReadLength();
        int n3 = !sAMRecord.getReadPairedFlag() || sAMRecord.getFirstOfPairFlag() ? (this.read1BasesTrimmed != null ? this.read1BasesTrimmed : 0) : (this.read2BasesTrimmed != null ? this.read2BasesTrimmed : 0);
        int n4 = n2 - (n + n3);
        sAMRecord.setCigar(CigarUtil.addSoftClippedBasesToEndsOfCigar(sAMRecord.getCigar(), sAMRecord.getReadNegativeStrandFlag(), n4, n3));
        if (this.clipAdapters && sAMRecord.getAttribute("XT") != null) {
            CigarUtil.softClip3PrimeEndOfRead(sAMRecord, sAMRecord.getIntegerAttribute("XT"));
        }
    }

    protected SAMSequenceDictionary getSequenceDictionary() {
        return this.sequenceDictionary;
    }

    protected SAMProgramRecord getProgramRecord() {
        return this.programRecord;
    }

    protected void setProgramRecord(SAMProgramRecord sAMProgramRecord) {
        if (this.programRecord != null) {
            throw new IllegalStateException("Cannot set program record more than once on alignment merger.");
        }
        this.programRecord = sAMProgramRecord;
        this.header.addProgramRecord(sAMProgramRecord);
        SAMUtils.chainSAMProgramRecord(this.header, sAMProgramRecord);
    }

    protected boolean isReservedTag(String string) {
        char c = string.charAt(0);
        if (Character.isLowerCase(c)) {
            return true;
        }
        for (char c2 : RESERVED_ATTRIBUTE_STARTS) {
            if (c != c2) continue;
            return true;
        }
        return false;
    }

    protected SAMFileHeader getHeader() {
        return this.header;
    }

    protected void resetRefSeqFileWalker() {
        this.refSeq = new ReferenceSequenceFileWalker(this.referenceFasta);
    }

    public boolean isClipOverlappingReads() {
        return this.clipOverlappingReads;
    }

    public void setClipOverlappingReads(boolean bl) {
        this.clipOverlappingReads = bl;
    }

    public boolean isKeepAlignerProperPairFlags() {
        return this.keepAlignerProperPairFlags;
    }

    public void setKeepAlignerProperPairFlags(boolean bl) {
        this.keepAlignerProperPairFlags = bl;
    }
}

