/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import net.sf.picard.illumina.parser.BclData;
import net.sf.picard.illumina.parser.CycleIlluminaFileMap;
import net.sf.picard.illumina.parser.IlluminaDataType;
import net.sf.picard.illumina.parser.OutputMapping;
import net.sf.picard.illumina.parser.PerTilePerCycleParser;
import net.sf.picard.illumina.parser.readers.BclReader;
import net.sf.picard.util.CollectionUtil;

class BclParser
extends PerTilePerCycleParser<BclData> {
    private static final int EAMSS_M2_GE_THRESHOLD = 30;
    private static final int EAMSS_S1_LT_THRESHOLD = 15;
    public static final byte MASKING_QUALITY = 2;
    private static final Set<IlluminaDataType> SUPPORTED_TYPES = Collections.unmodifiableSet(CollectionUtil.makeSet(IlluminaDataType.BaseCalls, IlluminaDataType.QualityScores));

    public BclParser(File file, int n, CycleIlluminaFileMap cycleIlluminaFileMap, OutputMapping outputMapping) {
        super(file, n, cycleIlluminaFileMap, outputMapping);
    }

    @Override
    protected BclData makeData(int[] nArray) {
        return new BclData(nArray);
    }

    @Override
    protected PerTilePerCycleParser.CycleFileParser<BclData> makeCycleFileParser(final File file, final int n) {
        return new PerTilePerCycleParser.CycleFileParser<BclData>(){
            final OutputMapping.TwoDIndex cycleOutputIndex;
            BclReader reader;
            {
                this.cycleOutputIndex = BclParser.this.outputMapping.getOutputIndexForCycle(n);
                this.reader = new BclReader(file);
            }

            @Override
            public void close() {
                this.reader = null;
            }

            @Override
            public void next(BclData bclData) {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                BclReader.BclValue bclValue = this.reader.next();
                bclData.getBases()[this.cycleOutputIndex.majorIndex][this.cycleOutputIndex.minorIndex] = bclValue.base;
                bclData.getQualities()[this.cycleOutputIndex.majorIndex][this.cycleOutputIndex.minorIndex] = bclValue.quality;
            }

            @Override
            public boolean hasNext() {
                return this.reader != null && this.reader.hasNext();
            }
        };
    }

    @Override
    public Set<IlluminaDataType> supportedTypes() {
        return SUPPORTED_TYPES;
    }

    @Override
    public BclData next() {
        BclData bclData = (BclData)super.next();
        byte[][] byArray = bclData.bases;
        byte[][] byArray2 = bclData.qualities;
        for (int i = 0; i < byArray.length; ++i) {
            BclParser.runEamssForReadInPlace(byArray[i], byArray2[i]);
        }
        return bclData;
    }

    protected static void runEamssForReadInPlace(byte[] byArray, byte[] byArray2) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = Integer.MIN_VALUE;
        int n5 = -1;
        for (n2 = byArray.length - 1; n2 >= 0; --n2) {
            n = 0xFF & byArray2[n2];
            if (n >= 30) {
                n3 -= 2;
            } else if (n < 15) {
                ++n3;
            }
            if (n3 < n4) continue;
            n5 = n2;
            n4 = n3;
        }
        if (n4 >= 1) {
            int n6;
            n2 = 0;
            n = 0;
            for (n6 = n5; n6 >= 0; --n6) {
                if (byArray[n6] == 71) {
                    ++n2;
                    continue;
                }
                Integer n7 = BclParser.skipBy(n6, n2, n, byArray);
                if (n7 == null) break;
                n += n7.intValue();
                n2 += n7.intValue();
                n6 -= n7 - 1;
            }
            if (n2 >= 10) {
                n5 = n5 + 1 - n2;
            }
            for (n6 = n5; n6 < byArray2.length; ++n6) {
                byArray2[n6] = 2;
            }
        }
    }

    private static Integer skipBy(int n, int n2, int n3, byte[] byArray) {
        int n4;
        Integer n5 = null;
        for (int i = 1; i <= n && n3 + i <= (n4 = Math.max((n2 + i) / 10, 1)); ++i) {
            if (byArray[n - i] != 71) continue;
            n5 = i;
            break;
        }
        return n5;
    }
}

