/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.analysis;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.picard.PicardException;
import net.sf.picard.analysis.MetricAccumulationLevel;
import net.sf.picard.analysis.SinglePassSamProgram;
import net.sf.picard.analysis.directed.RnaSeqMetricsCollector;
import net.sf.picard.annotation.Gene;
import net.sf.picard.annotation.GeneAnnotationReader;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.metrics.MetricsFile;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.picard.util.CollectionUtil;
import net.sf.picard.util.Histogram;
import net.sf.picard.util.Interval;
import net.sf.picard.util.Log;
import net.sf.picard.util.OverlapDetector;
import net.sf.picard.util.RExecutor;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;

public class CollectRnaSeqMetrics
extends SinglePassSamProgram {
    private static final Log LOG = Log.getInstance(CollectRnaSeqMetrics.class);
    @Usage
    public final String USAGE = this.getStandardUsagePreamble() + "Program to collect metrics about the alignment of RNA to various functional classes of loci in the genome:" + " coding, intronic, UTR, intergenic, ribosomal.\n" + "Also determines strand-specificity for strand-specific libraries.";
    @Option(doc="Gene annotations in refFlat form.  Format described here: http://genome.ucsc.edu/goldenPath/gbdDescriptionsOld.html#RefFlat")
    public File REF_FLAT;
    @Option(doc="Location of rRNA sequences in genome, in interval_list format.  If not specified no bases will be identified as being ribosomal.  Format described here: http://picard.sourceforge.net/javadoc/net/sf/picard/util/IntervalList.html", optional=true)
    public File RIBOSOMAL_INTERVALS;
    @Option(shortName="STRAND", doc="For strand-specific library prep. For unpaired reads, use FIRST_READ_TRANSCRIPTION_STRAND if the reads are expected to be on the transcription strand.")
    public RnaSeqMetricsCollector.StrandSpecificity STRAND_SPECIFICITY;
    @Option(doc="When calculating coverage based values (e.g. CV of coverage) only use transcripts of this length or greater.")
    public int MINIMUM_LENGTH = 500;
    @Option(doc="The PDF file to write out a plot of normalized position vs. coverage.", shortName="CHART", optional=true)
    public File CHART_OUTPUT;
    @Option(doc="If a read maps to a sequence specified with this option, all the bases in the read are counted as ignored bases.  These reads are not counted as ")
    public Set<String> IGNORE_SEQUENCE = new HashSet<String>();
    @Option(doc="This percentage of the length of a fragment must overlap one of the ribosomal intervals for a read or read pair by this must in order to be considered rRNA.")
    public double RRNA_FRAGMENT_PERCENTAGE = 0.8;
    @Option(shortName="LEVEL", doc="The level(s) at which to accumulate metrics.  ")
    private Set<MetricAccumulationLevel> METRIC_ACCUMULATION_LEVEL = CollectionUtil.makeSet(MetricAccumulationLevel.ALL_READS);
    private RnaSeqMetricsCollector collector;
    private String plotSubtitle = "";

    public static void main(String[] stringArray) {
        new CollectRnaSeqMetrics().instanceMainWithExit(stringArray);
    }

    @Override
    protected void setup(SAMFileHeader sAMFileHeader, File file) {
        if (this.CHART_OUTPUT != null) {
            IoUtil.assertFileIsWritable(this.CHART_OUTPUT);
        }
        OverlapDetector<Gene> overlapDetector = GeneAnnotationReader.loadRefFlat(this.REF_FLAT, sAMFileHeader.getSequenceDictionary());
        LOG.info("Loaded " + overlapDetector.getAll().size() + " genes.");
        Long l = this.RIBOSOMAL_INTERVALS != null ? Long.valueOf(0L) : null;
        OverlapDetector<Interval> overlapDetector2 = RnaSeqMetricsCollector.makeOverlapDetector(file, sAMFileHeader, this.RIBOSOMAL_INTERVALS);
        HashSet<Integer> hashSet = RnaSeqMetricsCollector.makeIgnoredSequenceIndicesSet(sAMFileHeader, this.IGNORE_SEQUENCE);
        this.collector = new RnaSeqMetricsCollector(this.METRIC_ACCUMULATION_LEVEL, sAMFileHeader.getReadGroups(), l, overlapDetector, overlapDetector2, hashSet, this.MINIMUM_LENGTH, this.STRAND_SPECIFICITY, this.RRNA_FRAGMENT_PERCENTAGE);
        List<SAMReadGroupRecord> list = sAMFileHeader.getReadGroups();
        if (list.size() == 1) {
            this.plotSubtitle = list.get(0).getLibrary();
        }
    }

    @Override
    protected void acceptRead(SAMRecord sAMRecord, ReferenceSequence referenceSequence) {
        this.collector.acceptRecord(sAMRecord, referenceSequence);
    }

    @Override
    protected void finish() {
        int n;
        this.collector.finish();
        MetricsFile metricsFile = this.getMetricsFile();
        this.collector.addAllLevelsToFile(metricsFile);
        metricsFile.write(this.OUTPUT);
        boolean bl = false;
        for (Histogram histogram : metricsFile.getAllHistograms()) {
            bl = bl || !histogram.isEmpty();
        }
        if (this.CHART_OUTPUT != null && bl && (n = RExecutor.executeFromClasspath("net/sf/picard/analysis/rnaSeqCoverage.R", this.OUTPUT.getAbsolutePath(), this.CHART_OUTPUT.getAbsolutePath(), this.INPUT.getName(), this.plotSubtitle)) != 0) {
            throw new PicardException("Problem invoking R to generate plot.");
        }
    }
}

