/*
 * Decompiled with CFR 0.152.
 */
package JSci.util;

import JSci.maths.Complex;
import JSci.maths.matrices.AbstractComplexMatrix;
import JSci.maths.matrices.AbstractDoubleMatrix;
import JSci.maths.matrices.ComplexDiagonalMatrix;
import JSci.maths.matrices.ComplexSquareMatrix;
import JSci.maths.matrices.ComplexTridiagonalMatrix;
import JSci.maths.matrices.DoubleDiagonalMatrix;
import JSci.maths.matrices.DoubleSquareMatrix;
import JSci.maths.matrices.DoubleTridiagonalMatrix;
import JSci.util.RandomMap;

public final class MatrixToolkit {
    private MatrixToolkit() {
    }

    public static DoubleSquareMatrix randomSquareMatrix(int n) {
        return (DoubleSquareMatrix)new DoubleSquareMatrix(n).mapElements(RandomMap.MAP);
    }

    public static DoubleTridiagonalMatrix randomTridiagonalMatrix(int n) {
        return new DoubleTridiagonalMatrix(MatrixToolkit.toArray(MatrixToolkit.randomSquareMatrix(n)));
    }

    public static DoubleDiagonalMatrix randomDiagonalMatrix(int n) {
        return new DoubleDiagonalMatrix(MatrixToolkit.toArray(MatrixToolkit.randomSquareMatrix(n)));
    }

    public static ComplexSquareMatrix randomComplexSquareMatrix(int n) {
        return (ComplexSquareMatrix)new ComplexSquareMatrix(n).mapElements(RandomMap.MAP);
    }

    public static ComplexTridiagonalMatrix randomComplexTridiagonalMatrix(int n) {
        return new ComplexTridiagonalMatrix(MatrixToolkit.toArray(MatrixToolkit.randomComplexSquareMatrix(n)));
    }

    public static ComplexDiagonalMatrix randomComplexDiagonalMatrix(int n) {
        return new ComplexDiagonalMatrix(MatrixToolkit.toArray(MatrixToolkit.randomComplexSquareMatrix(n)));
    }

    public static double[][] toArray(AbstractDoubleMatrix abstractDoubleMatrix) {
        double[][] dArray = new double[abstractDoubleMatrix.rows()][abstractDoubleMatrix.columns()];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                dArray[i][j] = abstractDoubleMatrix.getElement(i, j);
            }
        }
        return dArray;
    }

    public static Complex[][] toArray(AbstractComplexMatrix abstractComplexMatrix) {
        Complex[][] complexArray = new Complex[abstractComplexMatrix.rows()][abstractComplexMatrix.columns()];
        for (int i = 0; i < complexArray.length; ++i) {
            for (int j = 0; j < complexArray[0].length; ++j) {
                complexArray[i][j] = abstractComplexMatrix.getElement(i, j);
            }
        }
        return complexArray;
    }

    public static DoubleSquareMatrix rosserMatrix() {
        return new DoubleSquareMatrix(new double[][]{{611.0, 196.0, -192.0, 407.0, -8.0, -52.0, -49.0, 29.0}, {196.0, 899.0, 113.0, -192.0, -71.0, -43.0, -8.0, -44.0}, {-192.0, 113.0, 899.0, 196.0, 61.0, 49.0, 8.0, 52.0}, {407.0, -192.0, 196.0, 611.0, 8.0, 44.0, 59.0, -23.0}, {-8.0, -71.0, 61.0, 8.0, 411.0, -599.0, 208.0, 208.0}, {-52.0, -43.0, 49.0, 44.0, -599.0, 411.0, 208.0, 208.0}, {-49.0, -8.0, 8.0, 59.0, 208.0, 208.0, 99.0, -911.0}, {29.0, -44.0, 52.0, -23.0, 208.0, 208.0, -911.0, 99.0}});
    }

    public static DoubleTridiagonalMatrix wilkinsonMatrix(int n) {
        DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(n);
        int n2 = (n - 1) / 2;
        for (int i = 0; i < n2; ++i) {
            doubleTridiagonalMatrix.setElement(i, i + 1, 1.0);
            doubleTridiagonalMatrix.setElement(i + 1, i, 1.0);
            doubleTridiagonalMatrix.setElement(i, i, n2 - i);
            doubleTridiagonalMatrix.setElement(n - 1 - i, n - 1 - i, n2 - i);
            doubleTridiagonalMatrix.setElement(n - 1 - i, n - 2 - i, 1.0);
            doubleTridiagonalMatrix.setElement(n - 2 - i, n - 1 - i, 1.0);
        }
        return doubleTridiagonalMatrix;
    }
}

