/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.matrices;

import JSci.maths.algebras.Algebra;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;
import JSci.maths.matrices.AbstractDoubleMatrix;
import JSci.maths.matrices.AbstractDoubleSquareMatrix;
import JSci.maths.matrices.DoubleDiagonalMatrix;
import JSci.maths.matrices.DoubleMatrix;
import java.awt.Dimension;
import java.util.Hashtable;

public final class DoubleMatrixAlgebra
implements Algebra,
Ring {
    private static final Hashtable algebras = new Hashtable();
    private final int rows;
    private final int cols;
    private AbstractDoubleMatrix zero;
    private AbstractDoubleSquareMatrix one;

    static DoubleMatrixAlgebra get(int n, int n2) {
        Dimension dimension = new Dimension(n, n2);
        DoubleMatrixAlgebra doubleMatrixAlgebra = (DoubleMatrixAlgebra)algebras.get(dimension);
        if (doubleMatrixAlgebra == null) {
            doubleMatrixAlgebra = new DoubleMatrixAlgebra(n, n2);
            algebras.put(dimension, doubleMatrixAlgebra);
        }
        return doubleMatrixAlgebra;
    }

    private DoubleMatrixAlgebra(int n, int n2) {
        this.rows = n;
        this.cols = n2;
    }

    public Ring.Member one() {
        if (this.one == null) {
            this.one = DoubleDiagonalMatrix.identity(this.cols);
        }
        return this.one;
    }

    public boolean isOne(Ring.Member member) {
        return this.one().equals(member);
    }

    public AbelianGroup.Member zero() {
        if (this.zero == null) {
            this.zero = new DoubleMatrix(this.rows, this.cols);
        }
        return this.zero;
    }

    public boolean isZero(AbelianGroup.Member member) {
        return this.zero().equals(member);
    }

    public boolean isNegative(AbelianGroup.Member member, AbelianGroup.Member member2) {
        return this.zero().equals(member.add(member2));
    }
}

