/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.oxford;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.molgenis.genotype.Allele;
import org.molgenis.genotype.GenotypeData;
import org.molgenis.genotype.GenotypeWriter;
import org.molgenis.genotype.Sample;
import org.molgenis.genotype.oxford.HapsGenotypeWriter;
import org.molgenis.genotype.oxford.OxfordSampleFileWriter;
import org.molgenis.genotype.util.Utils;
import org.molgenis.genotype.variant.GeneticVariant;

public class GenGenotypeWriter
implements GenotypeWriter {
    public static final Charset FILE_ENCODING = Charset.forName("UTF-8");
    public static final char LINE_ENDING = '\n';
    private static final char SEPARATOR = ' ';
    private static final Logger LOGGER = Logger.getLogger(HapsGenotypeWriter.class);
    private GenotypeData genotypeData;

    public GenGenotypeWriter(GenotypeData genotypeData) {
        this.genotypeData = genotypeData;
    }

    @Override
    public void write(String basePath) throws IOException {
        if (!this.genotypeData.isOnlyContaingSaveProbabilityGenotypes()) {
            LOGGER.warn((Object)"WARNING!!! writing dosage genotype data to .gen posterior probabilities file. Using heuristic method to convert to probabilities, this is not guaranteed to be accurate. See manual for more details.");
        }
        this.write(new File(basePath + ".gen"), new File(basePath + ".sample"));
    }

    public void write(File genFile, File sampleFile) throws IOException {
        LOGGER.info((Object)("Writing gen file " + genFile.getAbsolutePath() + " and sample file " + sampleFile.getAbsolutePath()));
        Utils.createEmptyFile(genFile, "gen");
        Utils.createEmptyFile(sampleFile, "sample");
        HashMap<Sample, Float> sampleMissingness = this.writeGenFile(genFile);
        OxfordSampleFileWriter.writeSampleFile(sampleFile, this.genotypeData, sampleMissingness);
    }

    private HashMap<Sample, Float> writeGenFile(File hapsFile) throws IOException {
        BufferedWriter hapsFileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(hapsFile), FILE_ENCODING));
        float[] sampleMissingCount = new float[this.genotypeData.getSamples().size()];
        int totalVariants = 0;
        for (GeneticVariant variant : this.genotypeData) {
            ++totalVariants;
            if (variant.getAlleleCount() > 2) {
                LOGGER.warn((Object)("Skipping variant: " + variant.getPrimaryVariantId() + " at " + variant.getSequenceName() + ":" + variant.getStartPos() + " with more than 2 alleles: " + variant.getVariantAlleles()));
            }
            Allele allele0 = variant.getVariantAlleles().get(0);
            Allele allele1 = variant.getAlleleCount() == 1 ? Allele.ZERO : variant.getVariantAlleles().get(1);
            hapsFileWriter.append(variant.getSequenceName());
            hapsFileWriter.append(' ');
            hapsFileWriter.append(variant.getPrimaryVariantId());
            hapsFileWriter.append(' ');
            hapsFileWriter.append(String.valueOf(variant.getStartPos()));
            hapsFileWriter.append(' ');
            hapsFileWriter.append(allele0.getAlleleAsString());
            hapsFileWriter.append(' ');
            hapsFileWriter.append(allele1.getAlleleAsString());
            float[][] probs = variant.getSampleGenotypeProbilities();
            for (int i = 0; i < probs.length; ++i) {
                boolean isMissing = true;
                for (float prob : probs[i]) {
                    if (prob > 0.0f) {
                        isMissing = false;
                    }
                    hapsFileWriter.append(' ');
                    if (prob == 0.0f) {
                        hapsFileWriter.append('0');
                        continue;
                    }
                    if (prob == 1.0f) {
                        hapsFileWriter.append('1');
                        continue;
                    }
                    hapsFileWriter.append(String.valueOf(prob));
                }
                if (!isMissing) continue;
                int n = i;
                sampleMissingCount[n] = sampleMissingCount[n] + 1.0f;
            }
            hapsFileWriter.append('\n');
        }
        hapsFileWriter.close();
        HashMap<Sample, Float> sampleMissingness = new HashMap<Sample, Float>();
        for (int i = 0; i < sampleMissingCount.length; ++i) {
            sampleMissingness.put(this.genotypeData.getSamples().get(i), Float.valueOf(sampleMissingCount[i] / (float)totalVariants));
        }
        return sampleMissingness;
    }
}

