/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.variantFilter;

import org.molgenis.genotype.variant.GeneticVariant;
import org.molgenis.genotype.variantFilter.VariantFilter;

public class VariantQcChecker
implements VariantFilter {
    private double maf;
    private double callRate;
    private double hwe;

    public VariantQcChecker(float maf, float callRate, double hwe) {
        this.maf = maf;
        this.callRate = callRate;
        this.hwe = hwe;
    }

    public void setMafCutoff(float maf) {
        this.maf = maf;
    }

    public void setHweCutoff(double hwe) {
        this.hwe = hwe;
    }

    public void setCallRateCutoff(double callRate) {
        this.callRate = callRate;
    }

    @Override
    public boolean doesVariantPassFilter(GeneticVariant variant) {
        if (variant.getCallRate() < this.callRate) {
            return false;
        }
        if (variant.getMinorAlleleFrequency() < this.maf) {
            return false;
        }
        return !(variant.getHwePvalue() < this.hwe);
    }

    @Override
    public boolean doesIdPassFilter(String id) {
        return true;
    }
}

