/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.util;

import java.util.LinkedHashMap;
import org.molgenis.genotype.util.Ld;
import org.molgenis.genotype.util.LdCalculatorException;
import org.molgenis.genotype.variant.GeneticVariant;

public class LdCalculator {
    public static Ld calculateLd(GeneticVariant variant1, GeneticVariant variant2) throws LdCalculatorException {
        double b;
        double a;
        byte[] variant2Genotypes;
        if (variant1 == null) {
            throw new IllegalArgumentException("Variant1 = null");
        }
        if (variant2 == null) {
            throw new IllegalArgumentException("Variant2 = null");
        }
        if (variant1.getAlleleCount() != 2 || variant2.getAlleleCount() != 2) {
            throw new UnsupportedOperationException("Ld calculator currently only supports biallelic variants");
        }
        byte[] variant1Genotypes = variant1.getSampleCalledDosages();
        if (variant1Genotypes.length != (variant2Genotypes = variant2.getSampleCalledDosages()).length) {
            throw new LdCalculatorException("Error calculating LD: " + variant1.getPrimaryVariantId() + " contains " + variant1Genotypes.length + " samples and " + variant2.getPrimaryVariantId() + " contains " + variant2Genotypes.length + " samples. This should be identical");
        }
        int[][] genotypes = new int[3][3];
        int calledGenoypes = 0;
        for (int ind = 0; ind < variant1Genotypes.length; ++ind) {
            byte genotypeVariant1 = variant1Genotypes[ind];
            byte genotypeVariant2 = variant2Genotypes[ind];
            if (genotypeVariant1 == -1 || genotypeVariant2 == -1) continue;
            int[] nArray = genotypes[genotypeVariant1];
            byte by = genotypeVariant2;
            nArray[by] = nArray[by] + 1;
            ++calledGenoypes;
        }
        double[][] genotypesFreq = new double[3][3];
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                genotypesFreq[x][y] = (double)genotypes[x][y] / (double)calledGenoypes;
            }
        }
        double[][] alleleFreq = new double[2][2];
        alleleFreq[0][0] = genotypesFreq[0][0] + genotypesFreq[0][1] + genotypesFreq[0][2] + (genotypesFreq[1][0] + genotypesFreq[1][1] + genotypesFreq[1][2]) / 2.0;
        alleleFreq[0][1] = genotypesFreq[2][0] + genotypesFreq[2][1] + genotypesFreq[2][2] + (genotypesFreq[1][0] + genotypesFreq[1][1] + genotypesFreq[1][2]) / 2.0;
        alleleFreq[1][0] = genotypesFreq[0][0] + genotypesFreq[1][0] + genotypesFreq[2][0] + (genotypesFreq[0][1] + genotypesFreq[1][1] + genotypesFreq[2][1]) / 2.0;
        alleleFreq[1][1] = genotypesFreq[0][2] + genotypesFreq[1][2] + genotypesFreq[2][2] + (genotypesFreq[0][1] + genotypesFreq[1][1] + genotypesFreq[2][1]) / 2.0;
        double[][] genotypesTriangleFreq = new double[3][3];
        genotypesTriangleFreq[0][0] = 2.0 * genotypesFreq[0][0] + genotypesFreq[1][0] + genotypesFreq[0][1];
        genotypesTriangleFreq[2][0] = 2.0 * genotypesFreq[2][0] + genotypesFreq[1][0] + genotypesFreq[2][1];
        genotypesTriangleFreq[0][2] = 2.0 * genotypesFreq[0][2] + genotypesFreq[1][2] + genotypesFreq[0][1];
        genotypesTriangleFreq[2][2] = 2.0 * genotypesFreq[2][2] + genotypesFreq[1][2] + genotypesFreq[2][1];
        double h11 = alleleFreq[0][0] * alleleFreq[1][0];
        double h12 = alleleFreq[0][0] * alleleFreq[1][1];
        double h21 = alleleFreq[0][1] * alleleFreq[1][0];
        double h22 = alleleFreq[0][1] * alleleFreq[1][1];
        double x12y12 = h11 * h22 / (h11 * h22 + h12 * h21) * genotypesFreq[1][1];
        double x12y21 = h12 * h21 / (h11 * h22 + h12 * h21) * genotypesFreq[1][1];
        for (int itr = 0; itr < 25; ++itr) {
            h11 = (x12y12 + genotypesTriangleFreq[0][0]) / 2.0;
            h12 = (x12y21 + genotypesTriangleFreq[0][2]) / 2.0;
            h21 = (x12y21 + genotypesTriangleFreq[2][0]) / 2.0;
            h22 = (x12y12 + genotypesTriangleFreq[2][2]) / 2.0;
            x12y12 = h11 * h22 / (h11 * h22 + h12 * h21) * genotypesFreq[1][1];
            x12y21 = h12 * h21 / (h11 * h22 + h12 * h21) * genotypesFreq[1][1];
        }
        double d = h11 - alleleFreq[0][0] * alleleFreq[1][0];
        double rSquared = d * d / (alleleFreq[0][0] * alleleFreq[0][1] * alleleFreq[1][0] * alleleFreq[1][1]);
        double dMax = 0.0;
        if (d < 0.0) {
            a = alleleFreq[0][1] * alleleFreq[1][1];
            if (alleleFreq[0][0] > alleleFreq[1][0]) {
                a = alleleFreq[0][0] * alleleFreq[1][0];
            }
            b = alleleFreq[0][0] * alleleFreq[1][0];
            if (alleleFreq[0][0] > alleleFreq[1][0]) {
                b = alleleFreq[0][1] * alleleFreq[1][1];
            }
            dMax = Math.min(a, b);
        } else {
            a = alleleFreq[0][1] * alleleFreq[1][0];
            if (alleleFreq[0][0] > alleleFreq[1][0]) {
                a = alleleFreq[0][0] * alleleFreq[1][1];
            }
            b = alleleFreq[0][0] * alleleFreq[1][1];
            if (alleleFreq[0][0] > alleleFreq[1][0]) {
                b = alleleFreq[0][1] * alleleFreq[1][0];
            }
            dMax = Math.min(a, b);
        }
        double dPrime = Math.abs(d / dMax);
        dPrime = Math.min(1.0, dPrime);
        String variant1Alt = variant1.getVariantAlleles().get(1).getAlleleAsString();
        String variant1Ref = variant1.getVariantAlleles().get(0).getAlleleAsString();
        String variant2Alt = variant2.getVariantAlleles().get(1).getAlleleAsString();
        String variant2Ref = variant2.getVariantAlleles().get(0).getAlleleAsString();
        LinkedHashMap<String, Double> haplotypesFreq = new LinkedHashMap<String, Double>(4);
        haplotypesFreq.put(variant1Alt + variant2Alt, h11);
        haplotypesFreq.put(variant1Alt + variant2Ref, h12);
        haplotypesFreq.put(variant1Ref + variant2Alt, h21);
        haplotypesFreq.put(variant1Ref + variant2Ref, h22);
        return new Ld(variant1, variant2, rSquared, dPrime, haplotypesFreq);
    }
}

