/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.plink;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.molgenis.genotype.AbstractRandomAccessGenotypeData;
import org.molgenis.genotype.Allele;
import org.molgenis.genotype.Alleles;
import org.molgenis.genotype.GenotypeDataException;
import org.molgenis.genotype.Sample;
import org.molgenis.genotype.Sequence;
import org.molgenis.genotype.SimpleSequence;
import org.molgenis.genotype.annotation.Annotation;
import org.molgenis.genotype.annotation.SampleAnnotation;
import org.molgenis.genotype.annotation.SexAnnotation;
import org.molgenis.genotype.plink.BedBimFamGenotypeWriter;
import org.molgenis.genotype.plink.PlinkSampleAnnotations;
import org.molgenis.genotype.util.CalledDosageConvertor;
import org.molgenis.genotype.util.FixedSizeIterable;
import org.molgenis.genotype.util.ProbabilitiesConvertor;
import org.molgenis.genotype.util.RecordIteratorCreators;
import org.molgenis.genotype.variant.GeneticVariant;
import org.molgenis.genotype.variant.GeneticVariantMeta;
import org.molgenis.genotype.variant.GeneticVariantMetaMap;
import org.molgenis.genotype.variant.GenotypeRecord;
import org.molgenis.genotype.variant.ReadOnlyGeneticVariant;
import org.molgenis.genotype.variant.range.GeneticVariantRange;
import org.molgenis.genotype.variant.sampleProvider.CachedSampleVariantProvider;
import org.molgenis.genotype.variant.sampleProvider.SampleVariantUniqueIdProvider;
import org.molgenis.genotype.variant.sampleProvider.SampleVariantsProvider;

public class BedBimFamGenotypeData
extends AbstractRandomAccessGenotypeData
implements SampleVariantsProvider {
    private static final Pattern SEPARATOR_PATTERN = Pattern.compile("[ \\t]+");
    private static final byte MAGIC_NUMBER_1 = 108;
    private static final byte MAGIC_NUMBER_2 = 27;
    private static final byte MODE = 1;
    private static final int READER_MASK = 3;
    private static final int HOMOZYGOTE_FIRST = 0;
    private static final int HOMOZYGOTE_SECOND = 3;
    private static final int HETEROZYGOTE = 2;
    private static final int MISSING = 1;
    private static final Alleles BI_ALLELIC_MISSING = Alleles.createAlleles(Allele.ZERO, Allele.ZERO);
    private static final Logger LOGGER = Logger.getLogger(BedBimFamGenotypeWriter.class);
    private static final Charset FILE_ENCODING = Charset.forName("UTF-8");
    private final ArrayList<Sample> samples;
    private final Map<String, SampleAnnotation> sampleAnnotations;
    private final HashMap<String, Sequence> sequences;
    private final GeneticVariantRange snps;
    private final TObjectIntHashMap<GeneticVariant> snpIndexces;
    private final RandomAccessFile bedFileReader;
    private final SampleVariantsProvider sampleVariantProvider;
    private final int sampleVariantProviderUniqueId;
    private final int cacheSize;
    private final List<Boolean> phasing;
    private final long bytesPerVariant;
    private final int originalSnpCount;
    private GeneticVariantMeta geneticVariantMeta = GeneticVariantMetaMap.getGeneticVariantMetaGt();

    public BedBimFamGenotypeData(String basePath) throws IOException {
        this(basePath, 100);
    }

    public BedBimFamGenotypeData(String basePath, int cacheSize) throws IOException {
        this(new File(basePath + ".bed"), new File(basePath + ".bim"), new File(basePath + ".fam"), cacheSize);
    }

    public BedBimFamGenotypeData(File bedFile, File bimFile, File famFile, int cacheSize) throws IOException {
        if (bedFile == null) {
            throw new IllegalArgumentException("BedFile is null");
        }
        if (bimFile == null) {
            throw new IllegalArgumentException("BimFile is null");
        }
        if (famFile == null) {
            throw new IllegalArgumentException("FamFile is null");
        }
        if (!bedFile.isFile()) {
            throw new FileNotFoundException("BED file not found at " + bedFile.getAbsolutePath());
        }
        if (!bedFile.canRead()) {
            throw new IOException("BED file not found at " + bedFile.getAbsolutePath());
        }
        if (!bimFile.isFile()) {
            throw new FileNotFoundException("BIM file not found at " + bimFile.getAbsolutePath());
        }
        if (!bimFile.canRead()) {
            throw new IOException("BIM file not found at " + bimFile.getAbsolutePath());
        }
        if (!famFile.isFile()) {
            throw new FileNotFoundException("FAM file not found at " + famFile.getAbsolutePath());
        }
        if (!famFile.canRead()) {
            throw new IOException("FAM file not found at " + famFile.getAbsolutePath());
        }
        this.sampleVariantProviderUniqueId = SampleVariantUniqueIdProvider.getNextUniqueId();
        this.sampleVariantProvider = cacheSize <= 0 ? this : new CachedSampleVariantProvider(this, cacheSize);
        this.cacheSize = cacheSize;
        this.sampleAnnotations = PlinkSampleAnnotations.getSampleAnnotations();
        this.samples = new ArrayList();
        this.readFamFile(famFile);
        this.phasing = Collections.unmodifiableList(Collections.nCopies(this.samples.size(), false));
        this.snpIndexces = new TObjectIntHashMap(10000, 0.75f, -1);
        GeneticVariantRange.GeneticVariantRangeCreate snpsFactory = GeneticVariantRange.createRangeFactory();
        this.sequences = new HashMap();
        this.originalSnpCount = this.readBimFile(bimFile, snpsFactory);
        this.snps = snpsFactory.createRange();
        long l = this.bytesPerVariant = this.samples.size() % 4 == 0 ? (long)(this.samples.size() / 4) : (long)(this.samples.size() / 4 + 1);
        if (bedFile.length() != this.bytesPerVariant * (long)this.originalSnpCount + 3L) {
            throw new GenotypeDataException("Invalid plink BED file not the expected file size. " + bedFile.getAbsolutePath() + " expected: " + (this.bytesPerVariant * (long)this.snpIndexces.size() + 3L) + " found: " + bedFile.length() + " bytes per variant: " + this.bytesPerVariant + " snps: " + this.originalSnpCount);
        }
        this.bedFileReader = new RandomAccessFile(bedFile, "r");
        if (this.bedFileReader.read() != 108 || this.bedFileReader.read() != 27) {
            throw new GenotypeDataException("Error reading plink BED file, magic number not found. " + bedFile.getAbsolutePath());
        }
        int bedFileMode = this.bedFileReader.read();
        if (bedFileMode != 1) {
            if (bedFileMode == 0) {
                throw new GenotypeDataException("Error reading BED file, only SNP major mode is supported. " + bedFile.getAbsolutePath());
            }
            throw new GenotypeDataException("Error reading BED file, ivalid mode byte detected. " + bedFile.getAbsolutePath());
        }
    }

    @Override
    public Map<String, SampleAnnotation> getSampleAnnotationsMap() {
        return this.sampleAnnotations;
    }

    @Override
    public Map<String, Annotation> getVariantAnnotationsMap() {
        return Collections.emptyMap();
    }

    @Override
    public List<Sample> getSamples() {
        return this.samples;
    }

    @Override
    public void close() throws IOException {
        this.bedFileReader.close();
    }

    @Override
    public List<String> getSeqNames() {
        return new ArrayList<String>(this.sequences.keySet());
    }

    @Override
    public Iterable<Sequence> getSequences() {
        return this.sequences.values();
    }

    @Override
    public Iterable<GeneticVariant> getVariantsByPos(String seqName, int startPos) {
        return this.snps.getVariantAtPos(seqName, startPos);
    }

    @Override
    public Iterable<GeneticVariant> getSequenceGeneticVariants(String seqName) {
        return this.snps.getVariantsBySequence(seqName);
    }

    @Override
    public Iterable<GeneticVariant> getVariantsByRange(String seqName, int rangeStart, int rangeEnd) {
        return this.snps.getVariantsByRange(seqName, rangeStart, rangeEnd);
    }

    @Override
    public List<Alleles> getSampleVariants(GeneticVariant variant) {
        int index = this.snpIndexces.get((Object)variant);
        if (index == -1) {
            throw new GenotypeDataException("Error reading variant from bed file. ID: " + variant.getPrimaryVariantId() + " chr: " + variant.getSequenceName() + " pos: " + variant.getStartPos() + " alleles" + variant.getVariantAlleles().toString());
        }
        long startByte = (long)index * this.bytesPerVariant + 3L;
        long stopByte = startByte + this.bytesPerVariant;
        byte[] variantBytes = new byte[(int)(stopByte - startByte)];
        try {
            this.bedFileReader.seek(startByte);
            if (this.bedFileReader.read(variantBytes) != variantBytes.length) {
                throw new GenotypeDataException("Error reading bed file");
            }
        }
        catch (IOException ex) {
            throw new GenotypeDataException("Error reading bed file", ex);
        }
        ArrayList<Alleles> alleles = new ArrayList<Alleles>(this.samples.size());
        Alleles heterozygote = variant.getVariantAlleles();
        Alleles homozygoteFirst = Alleles.createAlleles(heterozygote.get(0), heterozygote.get(0));
        Alleles homozygoteSecond = Alleles.createAlleles(heterozygote.get(1), heterozygote.get(1));
        int sampleCounter = 0;
        for (int n : variantBytes) {
            for (int i = 0; i < 4; ++i) {
                block14: {
                    block13: {
                        if (sampleCounter >= this.samples.size()) break block13;
                        switch (n & 3) {
                            case 0: {
                                alleles.add(homozygoteFirst);
                                break block14;
                            }
                            case 3: {
                                alleles.add(homozygoteSecond);
                                break block14;
                            }
                            case 2: {
                                alleles.add(heterozygote);
                                break block14;
                            }
                            case 1: {
                                alleles.add(BI_ALLELIC_MISSING);
                                break block14;
                            }
                            default: {
                                throw new GenotypeDataException("Error reading BED, this should not be reachable");
                            }
                        }
                    }
                    if ((n & 3) != 0) {
                        throw new GenotypeDataException("Error reading BED file, found data in padding bits of variant: " + variant.getPrimaryVariantId());
                    }
                }
                n >>>= 2;
                ++sampleCounter;
            }
        }
        return Collections.unmodifiableList(alleles);
    }

    @Override
    public List<Boolean> getSamplePhasing(GeneticVariant variant) {
        return this.phasing;
    }

    @Override
    public int cacheSize() {
        return this.cacheSize;
    }

    @Override
    public int getSampleVariantProviderUniqueId() {
        return this.sampleVariantProviderUniqueId;
    }

    @Override
    public byte[] getSampleCalledDosage(GeneticVariant variant) {
        return CalledDosageConvertor.convertCalledAllelesToCalledDosage(this.getSampleVariants(variant), variant.getVariantAlleles(), variant.getRefAllele());
    }

    @Override
    public float[] getSampleDosage(GeneticVariant variant) {
        return CalledDosageConvertor.convertCalledAllelesToDosage(this.getSampleVariants(variant), variant.getVariantAlleles(), variant.getRefAllele());
    }

    private void readFamFile(File famFile) throws FileNotFoundException, IOException {
        String line;
        BufferedReader famFileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(famFile), FILE_ENCODING));
        while ((line = famFileReader.readLine()) != null) {
            String[] elements = SEPARATOR_PATTERN.split(line);
            LinkedHashMap<String, Object> annotationValues = new LinkedHashMap<String, Object>();
            annotationValues.put("fatherId", elements[2]);
            annotationValues.put("motherId", elements[3]);
            annotationValues.put("sex_generic", (Object)SexAnnotation.getSexAnnotationForPlink(Byte.parseByte(elements[4])));
            annotationValues.put("phenotype", Double.parseDouble(elements[5]));
            this.samples.add(new Sample(elements[1], elements[0], annotationValues));
        }
        LOGGER.info((Object)("Read " + this.samples.size() + " samples from " + famFile.getAbsolutePath()));
        famFileReader.close();
    }

    private int readBimFile(File bimFile, GeneticVariantRange.GeneticVariantRangeCreate snpsFactory) throws FileNotFoundException, IOException {
        String line;
        BufferedReader bimFileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(bimFile), FILE_ENCODING));
        int snpIndex = 0;
        while ((line = bimFileReader.readLine()) != null) {
            GeneticVariant variant;
            String[] elements = SEPARATOR_PATTERN.split(line);
            String sequenceName = elements[0].intern();
            if (!this.sequences.containsKey(sequenceName)) {
                this.sequences.put(sequenceName, new SimpleSequence(sequenceName, 0, this));
            }
            if (this.snpIndexces.containsKey((Object)(variant = ReadOnlyGeneticVariant.createVariant(this.geneticVariantMeta, new String(elements[1]), Integer.parseInt(elements[3]), sequenceName, this.sampleVariantProvider, Allele.create(elements[4]), Allele.create(elements[5]))))) {
                LOGGER.warn((Object)("Found two SNPs at " + sequenceName + ":" + variant.getStartPos() + " Only first is read!"));
            } else {
                snpsFactory.addVariant(variant);
                this.snpIndexces.put((Object)variant, snpIndex);
            }
            ++snpIndex;
        }
        LOGGER.info((Object)("Read " + snpIndex + " SNPs from " + bimFile.getAbsolutePath()));
        bimFileReader.close();
        return snpIndex;
    }

    @Override
    public Iterator<GeneticVariant> iterator() {
        return this.snps.iterator();
    }

    @Override
    public boolean isOnlyContaingSaveProbabilityGenotypes() {
        return true;
    }

    @Override
    public float[][] getSampleProbilities(GeneticVariant variant) {
        return ProbabilitiesConvertor.convertCalledAllelesToProbability(variant.getSampleVariants(), variant.getVariantAlleles());
    }

    @Override
    public FixedSizeIterable<GenotypeRecord> getSampleGenotypeRecords(GeneticVariant variant) {
        return RecordIteratorCreators.createIteratorFromAlleles(variant.getSampleVariants());
    }
}

