/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.oxford;

import au.com.bytecode.opencsv.CSVReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.molgenis.genotype.Sample;
import org.molgenis.genotype.annotation.Annotation;
import org.molgenis.genotype.annotation.SampleAnnotation;

public class OxfordSampleFile {
    private static final Logger LOGGER = Logger.getLogger(OxfordSampleFile.class);
    private final File sampleFile;
    private final Map<String, SampleAnnotation> sampleAnnotations;
    private final List<Sample> samples;

    public OxfordSampleFile(File sampleFile) throws FileNotFoundException, IOException {
        if (sampleFile == null) {
            throw new IllegalArgumentException("sampleFile is null");
        }
        if (!sampleFile.isFile()) {
            throw new FileNotFoundException("sample file file not found at " + sampleFile.getAbsolutePath());
        }
        if (!sampleFile.canRead()) {
            throw new IOException("Can not read sample file " + sampleFile.getAbsolutePath());
        }
        this.sampleFile = sampleFile;
        this.sampleAnnotations = new LinkedHashMap<String, SampleAnnotation>();
        this.samples = new ArrayList<Sample>();
        this.loadAnnotations();
        this.loadSamples();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAnnotations() throws IOException {
        SampleAnnotation missingAnnotation = new SampleAnnotation("sampleMissingRateFloat", "missing", "Missing data proportion of each individual", Annotation.Type.FLOAT, SampleAnnotation.SampleAnnotationType.OTHER, false);
        this.sampleAnnotations.put(missingAnnotation.getId(), missingAnnotation);
        CSVReader reader = new CSVReader((Reader)new InputStreamReader((InputStream)new FileInputStream(this.sampleFile), Charset.forName("UTF-8")), ' ');
        try {
            List<String> colNames = Arrays.asList(reader.readNext());
            List<String> dataTypes = Arrays.asList(reader.readNext());
            for (int i = 3; i < colNames.size(); ++i) {
                SampleAnnotation annotation = null;
                if (dataTypes.get(i).equalsIgnoreCase("D")) {
                    annotation = new SampleAnnotation(colNames.get(i), colNames.get(i), "", Annotation.Type.STRING, SampleAnnotation.SampleAnnotationType.COVARIATE, false);
                } else if (dataTypes.get(i).equalsIgnoreCase("C")) {
                    annotation = new SampleAnnotation(colNames.get(i), colNames.get(i), "", Annotation.Type.FLOAT, SampleAnnotation.SampleAnnotationType.COVARIATE, false);
                } else if (dataTypes.get(i).equalsIgnoreCase("P")) {
                    annotation = new SampleAnnotation(colNames.get(i), colNames.get(i), "", Annotation.Type.FLOAT, SampleAnnotation.SampleAnnotationType.PHENOTYPE, false);
                } else if (dataTypes.get(i).equalsIgnoreCase("B")) {
                    annotation = new SampleAnnotation(colNames.get(i), colNames.get(i), "", Annotation.Type.BOOLEAN, SampleAnnotation.SampleAnnotationType.PHENOTYPE, false);
                } else {
                    LOGGER.warn((Object)("Unknown datatype [" + dataTypes.get(i) + "]"));
                }
                if (annotation == null) continue;
                this.sampleAnnotations.put(annotation.getId(), annotation);
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSamples() throws IOException {
        CSVReader reader = new CSVReader((Reader)new InputStreamReader((InputStream)new FileInputStream(this.sampleFile), Charset.forName("UTF-8")), ' ');
        try {
            String[] tokens;
            HashMap<String, Integer> colNamesIndex = new HashMap<String, Integer>();
            String[] colNames = reader.readNext();
            for (int i = 0; i < colNames.length; ++i) {
                colNamesIndex.put(colNames[i], i);
            }
            reader.readNext();
            while ((tokens = reader.readNext()) != null) {
                String familyId = tokens[0];
                String sampleId = tokens[1];
                LinkedHashMap<String, Object> annotationValues = new LinkedHashMap<String, Object>();
                annotationValues.put("sampleMissingRateFloat", Float.valueOf(tokens[2].equals("NA") ? Float.NaN : Float.parseFloat(tokens[2])));
                for (String colName : this.sampleAnnotations.keySet()) {
                    if (colName.equals("sampleMissingRateFloat")) continue;
                    SampleAnnotation annotation = this.sampleAnnotations.get(colName);
                    Object value = null;
                    String token = tokens[(Integer)colNamesIndex.get(colName)];
                    switch (annotation.getType()) {
                        case STRING: {
                            value = token;
                            break;
                        }
                        case INTEGER: {
                            value = token.equals("NA") ? null : Integer.valueOf(token);
                            break;
                        }
                        case BOOLEAN: {
                            if (token.equals("-9") || token.equals("NA")) {
                                value = null;
                                break;
                            }
                            value = token.equals("1");
                            break;
                        }
                        case FLOAT: {
                            value = Float.valueOf(token.equals("NA") || token.equals("-9") ? Float.NaN : Float.parseFloat(token));
                            break;
                        }
                        default: {
                            LOGGER.warn((Object)("Unsupported data type encountered for column [" + colName + "]"));
                        }
                    }
                    annotationValues.put(colName, value);
                }
                this.samples.add(new Sample(sampleId, familyId, annotationValues));
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)reader);
        }
    }

    public List<Sample> getSamples() {
        return Collections.unmodifiableList(this.samples);
    }

    public Map<String, SampleAnnotation> getSampleAnnotations() {
        return this.sampleAnnotations;
    }
}

