/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype;

import java.io.File;
import java.util.EnumSet;
import java.util.regex.Pattern;

public enum GenotypeFileType {
    BIM(Pattern.compile(".*\\.bim$", 2), ".bim", "Plink bim"),
    FAM(Pattern.compile(".*\\.fam$", 2), ".fam", "Plink fam"),
    BED(Pattern.compile(".*\\.bed$", 2), ".bed", "Plink bed"),
    PED(Pattern.compile(".*\\.ped$", 2), ".ped", "Plink ped"),
    MAP(Pattern.compile(".*\\.map$", 2), ".map", "Plink map"),
    GEN(Pattern.compile(".*\\.gen$", 2), ".gen", "Oxford gen"),
    HAPS(Pattern.compile(".*\\.haps$", 2), ".haps", "Oxford haps"),
    SAMPLE(Pattern.compile(".*\\.sample$", 2), ".sample", "Oxford sample"),
    VCF(Pattern.compile(".*\\.vcf\\.gz$", 2), ".vcf.gz", "gzipped vcf"),
    VCF_FOLDER(null, "", "folder with gzipped vcf"),
    TRITYPER_GENOTYPE(Pattern.compile(".*GenotypeMatrix.dat$", 2), "GenotypeMatrix.dat", "Trityper GenotypeMatrix.dat"),
    TRITYPER_DOSAGE(Pattern.compile(".*ImputedDosageMatrix.dat$", 2), "ImputedDosageMatrix.dat", "Trityper ImputedDosageMatrix.dat"),
    TRITYPER_SNPS(Pattern.compile(".*SNPs.txt(\\.gz)?$", 2), "SNPs.txt", "Trityper SNPs.txt"),
    TRITYPER_MAPPINGS(Pattern.compile(".*SNPMappings.txt(\\.gz)?$", 2), "SNPMappings.txt", "Trityper SNPMappings.txt"),
    TRITYPER_IND(Pattern.compile(".*Individuals.txt(\\.gz)?$", 2), "Individuals.txt", "Trityper Individuals.txt"),
    TRITYPER_PHENO(Pattern.compile(".*PhenotypeInformation.txt(\\.gz)?$", 2), "PhenotypeInformation.txt", "Trityper PhenotypeInformation.txt"),
    UNKNOWN(null, "", "unspecified type, potentially oxford gen without extention");

    private final Pattern namePattern;
    private final String suffix;
    private final String friendlyName;
    private static final EnumSet<GenotypeFileType> TRITYPER_TYPES;

    private GenotypeFileType(Pattern namePattern, String suffix, String friendlyName) {
        this.namePattern = namePattern;
        this.suffix = suffix;
        this.friendlyName = friendlyName;
    }

    public static GenotypeFileType getTypeForPath(String path) {
        for (GenotypeFileType type : GenotypeFileType.values()) {
            if (type.namePattern == null || !type.namePattern.matcher(path).matches()) continue;
            return type;
        }
        return null;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String toString() {
        return this.friendlyName;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public static EnumSet<GenotypeFileType> getTrityperFileTypes() {
        return TRITYPER_TYPES;
    }

    public boolean matches(File file) {
        return this.namePattern.matcher(file.getAbsolutePath()).matches();
    }

    static {
        TRITYPER_TYPES = EnumSet.of(TRITYPER_DOSAGE, new GenotypeFileType[]{TRITYPER_GENOTYPE, TRITYPER_IND, TRITYPER_MAPPINGS, TRITYPER_PHENO, TRITYPER_SNPS});
    }
}

