/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser.readers;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Iterator;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.readers.BinaryFileIterator;
import net.sf.picard.illumina.parser.readers.MMapBackedIteratorFactory;
import net.sf.picard.util.UnsignedTypeUtil;

public class BclReader
implements Iterator<BclValue> {
    private final BinaryFileIterator<Byte> bbIterator;
    private static final int HEADER_SIZE = 4;
    public final long numClusters;
    private static final byte BASE_MASK = 3;
    private static final byte A_VAL = 0;
    private static final byte C_VAL = 1;
    private static final byte G_VAL = 2;
    private static final byte T_VAL = 3;
    private long nextCluster;

    public BclReader(File file) {
        this.bbIterator = MMapBackedIteratorFactory.getByteIterator(4, file);
        ByteBuffer byteBuffer = this.bbIterator.getHeaderBytes();
        this.numClusters = UnsignedTypeUtil.uIntToLong(byteBuffer.getInt());
        this.bbIterator.assertTotalElementsEqual(this.numClusters);
        this.nextCluster = 0L;
    }

    @Override
    public boolean hasNext() {
        return this.nextCluster < this.numClusters;
    }

    @Override
    public BclValue next() {
        byte by;
        byte by2;
        byte by3 = this.bbIterator.next();
        if (by3 == 0) {
            by2 = 46;
            by = 2;
        } else {
            switch (by3 & 3) {
                case 0: {
                    by2 = 65;
                    break;
                }
                case 1: {
                    by2 = 67;
                    break;
                }
                case 2: {
                    by2 = 71;
                    break;
                }
                case 3: {
                    by2 = 84;
                    break;
                }
                default: {
                    throw new PicardException("Impossible case! BCL Base value neither A, C, G, nor T! Value(" + (by3 & 3) + ") + in file(" + this.bbIterator.getFile().getAbsolutePath() + ")");
                }
            }
            by = (byte)(UnsignedTypeUtil.uByteToInt(by3) >>> 2);
            if (by == 0 || by == 1) {
                throw new PicardException("If base is NOT a NO CALL then it should have a quality of 2 or greater!  Quality Found(" + by + ")  Cluster(" + this.nextCluster + ")");
            }
        }
        ++this.nextCluster;
        return new BclValue(by2, by);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public class BclValue {
        public final byte base;
        public final byte quality;

        public BclValue(byte by, byte by2) {
            this.base = by;
            this.quality = by2;
        }
    }
}

