/*
 * Decompiled with CFR 0.152.
 */
package nl.umcg.deelenp.genotypeharmonizer;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.molgenis.genotype.variant.GeneticVariant;

public class SnpLogWriter
implements Closeable {
    private final BufferedWriter snpLogWriter;

    public SnpLogWriter(File snpLogFile) throws IOException {
        this.snpLogWriter = new BufferedWriter(new FileWriter(snpLogFile));
        this.snpLogWriter.append("chr\tpos\tid\talleles\taction\tmessage\n");
    }

    public void addToLog(GeneticVariant variant, String action, String message) throws IOException {
        this.snpLogWriter.append(variant.getSequenceName());
        this.snpLogWriter.append('\t');
        this.snpLogWriter.append(String.valueOf(variant.getStartPos()));
        this.snpLogWriter.append('\t');
        this.snpLogWriter.append(variant.getPrimaryVariantId());
        this.snpLogWriter.append('\t');
        this.snpLogWriter.append(variant.getVariantAlleles().toString());
        this.snpLogWriter.append('\t');
        this.snpLogWriter.append(action);
        this.snpLogWriter.append('\t');
        this.snpLogWriter.append(message);
        this.snpLogWriter.append('\n');
    }

    @Override
    public void close() throws IOException {
        this.snpLogWriter.close();
    }
}

